/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.WalkerConstellationSlot;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class WalkerConstellation {
    private final int t;
    private final int p;
    private final int f;

    public WalkerConstellation(int t, int p, int f) {
        this.t = t;
        this.p = p;
        this.f = f;
        if (t % p != 0) {
            throw new OrekitException((Localizable)OrekitMessages.WALKER_INCONSISTENT_PLANES, p, t);
        }
    }

    public int getT() {
        return this.t;
    }

    public int getP() {
        return this.p;
    }

    public int getF() {
        return this.f;
    }

    public <O extends Orbit> List<List<WalkerConstellationSlot<O>>> buildRegularSlots(O referenceOrbit) {
        WalkerConstellationSlot<O> referenceSlot = this.buildReferenceSlot(referenceOrbit);
        ArrayList<List<WalkerConstellationSlot<O>>> all = new ArrayList<List<WalkerConstellationSlot<O>>>(this.p);
        for (int plane = 0; plane < this.p; ++plane) {
            ArrayList<WalkerConstellationSlot<O>> planeSlots = new ArrayList<WalkerConstellationSlot<O>>(this.t / this.p);
            for (int satellite = 0; satellite < this.t / this.p; ++satellite) {
                planeSlots.add(plane == 0 && satellite == 0 ? referenceSlot : this.buildSlot(referenceSlot, plane, satellite));
            }
            all.add(planeSlots);
        }
        return all;
    }

    public <O extends Orbit> WalkerConstellationSlot<O> buildReferenceSlot(O referenceOrbit) {
        return new WalkerConstellationSlot<O>(this, 0, 0.0, referenceOrbit);
    }

    public <O extends Orbit> WalkerConstellationSlot<O> buildSlot(WalkerConstellationSlot<O> existingSlot, int plane, double satellite) {
        O refOrbit = existingSlot.getOrbit();
        int dp = plane - existingSlot.getPlane();
        double ds = satellite - existingSlot.getSatellite();
        double deltaT = ((double)(dp * this.f) + ds * (double)this.p) * ((Orbit)refOrbit).getKeplerianPeriod() / (double)this.t;
        Orbit shifted = ((Orbit)refOrbit).shiftedBy(deltaT);
        Rotation r = new Rotation(Vector3D.PLUS_K, Math.PI * 2 * (double)dp / (double)this.p, RotationConvention.VECTOR_OPERATOR);
        TimeStampedPVCoordinates pv = shifted.getPVCoordinates();
        PVCoordinates rotated = new PVCoordinates(r.applyTo(pv.getPosition()), r.applyTo(pv.getVelocity()));
        CartesianOrbit c = new CartesianOrbit(rotated, ((Orbit)refOrbit).getFrame(), ((Orbit)refOrbit).getDate(), ((Orbit)refOrbit).getMu());
        Orbit orbit = ((Orbit)refOrbit).getType().convertType(c);
        return new WalkerConstellationSlot<Orbit>(this, plane, satellite, orbit);
    }
}

