/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldCircularOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public enum OrbitType {
    CARTESIAN{

        @Override
        public CartesianOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (CartesianOrbit)orbit : new CartesianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngleType type, double[] stateVector, double[] stateVectorDot) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            Vector3D p = pv.getPosition();
            Vector3D v = pv.getVelocity();
            stateVector[0] = p.getX();
            stateVector[1] = p.getY();
            stateVector[2] = p.getZ();
            stateVector[3] = v.getX();
            stateVector[4] = v.getY();
            stateVector[5] = v.getZ();
            if (stateVectorDot != null) {
                Vector3D a = pv.getAcceleration();
                stateVectorDot[0] = v.getX();
                stateVectorDot[1] = v.getY();
                stateVectorDot[2] = v.getZ();
                stateVectorDot[3] = a.getX();
                stateVectorDot[4] = a.getY();
                stateVectorDot[5] = a.getZ();
            }
        }

        @Override
        public CartesianOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngleType type, AbsoluteDate date, double mu, Frame frame) {
            Vector3D p = new Vector3D(stateVector[0], stateVector[1], stateVector[2]);
            Vector3D v = new Vector3D(stateVector[3], stateVector[4], stateVector[5]);
            if (stateVectorDot == null) {
                return new CartesianOrbit(new PVCoordinates(p, v), frame, date, mu);
            }
            Vector3D a = new Vector3D(stateVectorDot[3], stateVectorDot[4], stateVectorDot[5]);
            return new CartesianOrbit(new PVCoordinates(p, v, a), frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldCartesianOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldCartesianOrbit)orbit : new FieldCartesianOrbit<T>(orbit);
        }

        @Override
        public <T extends CalculusFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngleType type, T[] stateVector, T[] stateVectorDot) {
            TimeStampedFieldPVCoordinates<T> pv = orbit.getPVCoordinates();
            FieldVector3D p = pv.getPosition();
            FieldVector3D v = pv.getVelocity();
            stateVector[0] = p.getX();
            stateVector[1] = p.getY();
            stateVector[2] = p.getZ();
            stateVector[3] = v.getX();
            stateVector[4] = v.getY();
            stateVector[5] = v.getZ();
            if (stateVectorDot != null) {
                FieldVector3D a = pv.getAcceleration();
                stateVectorDot[0] = v.getX();
                stateVectorDot[1] = v.getY();
                stateVectorDot[2] = v.getZ();
                stateVectorDot[3] = a.getX();
                stateVectorDot[4] = a.getY();
                stateVectorDot[5] = a.getZ();
            }
        }

        public <T extends CalculusFieldElement<T>> FieldCartesianOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngleType type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            FieldVector3D p = new FieldVector3D(stateVector[0], stateVector[1], stateVector[2]);
            FieldVector3D v = new FieldVector3D(stateVector[3], stateVector[4], stateVector[5]);
            if (stateVectorDot == null) {
                return new FieldCartesianOrbit(new FieldPVCoordinates(p, v), frame, date, mu);
            }
            FieldVector3D a = new FieldVector3D(stateVectorDot[3], stateVectorDot[4], stateVectorDot[5]);
            return new FieldCartesianOrbit(new FieldPVCoordinates(p, v, a), frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldCartesianOrbit<T> convertToFieldOrbit(Field<T> field, Orbit orbit) {
            return new FieldCartesianOrbit<T>(field, CARTESIAN.convertType(orbit));
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngleType type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            drivers.add(new ParameterDriver(OrbitType.POS_X, array[0], scale[0], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.POS_Y, array[1], scale[1], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.POS_Z, array[2], scale[2], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_X, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_Y, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.VEL_Z, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }

        @Override
        public CartesianOrbit normalize(Orbit orbit, Orbit reference) {
            return this.convertType(orbit);
        }

        public <T extends CalculusFieldElement<T>> FieldCartesianOrbit<T> normalize(FieldOrbit<T> orbit, FieldOrbit<T> reference) {
            return this.convertType((FieldOrbit)orbit);
        }

        @Override
        public boolean isPositionAngleBased() {
            return false;
        }
    }
    ,
    CIRCULAR{

        @Override
        public CircularOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (CircularOrbit)orbit : new CircularOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngleType type, double[] stateVector, double[] stateVectorDot) {
            CircularOrbit circularOrbit = (CircularOrbit)CIRCULAR.convertType(orbit);
            stateVector[0] = circularOrbit.getA();
            stateVector[1] = circularOrbit.getCircularEx();
            stateVector[2] = circularOrbit.getCircularEy();
            stateVector[3] = circularOrbit.getI();
            stateVector[4] = circularOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = circularOrbit.getAlpha(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = circularOrbit.getADot();
                    stateVectorDot[1] = circularOrbit.getCircularExDot();
                    stateVectorDot[2] = circularOrbit.getCircularEyDot();
                    stateVectorDot[3] = circularOrbit.getIDot();
                    stateVectorDot[4] = circularOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = circularOrbit.getAlphaDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public CircularOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngleType type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new CircularOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new CircularOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldCircularOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldCircularOrbit)orbit : new FieldCircularOrbit<T>(orbit);
        }

        @Override
        public <T extends CalculusFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngleType type, T[] stateVector, T[] stateVectorDot) {
            FieldCircularOrbit circularOrbit = (FieldCircularOrbit)CIRCULAR.convertType(orbit);
            stateVector[0] = circularOrbit.getA();
            stateVector[1] = circularOrbit.getCircularEx();
            stateVector[2] = circularOrbit.getCircularEy();
            stateVector[3] = circularOrbit.getI();
            stateVector[4] = circularOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = circularOrbit.getAlpha(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = circularOrbit.getADot();
                    stateVectorDot[1] = circularOrbit.getCircularExDot();
                    stateVectorDot[2] = circularOrbit.getCircularEyDot();
                    stateVectorDot[3] = circularOrbit.getIDot();
                    stateVectorDot[4] = circularOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = circularOrbit.getAlphaDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, orbit.getZero().add(Double.NaN));
                }
            }
        }

        public <T extends CalculusFieldElement<T>> FieldCircularOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngleType type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldCircularOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldCircularOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldCircularOrbit<T> convertToFieldOrbit(Field<T> field, Orbit orbit) {
            return new FieldCircularOrbit<T>(field, CIRCULAR.convertType(orbit));
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngleType type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngleType.MEAN ? OrbitType.MEAN_LAT_ARG : (type == PositionAngleType.ECCENTRIC ? OrbitType.ECC_LAT_ARG : OrbitType.TRUE_LAT_ARG);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.E_X, array[1], scale[1], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.E_Y, array[2], scale[2], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.INC, array[3], scale[3], 0.0, Math.PI));
            drivers.add(new ParameterDriver(OrbitType.RAAN, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }

        @Override
        public CircularOrbit normalize(Orbit orbit, Orbit reference) {
            CircularOrbit cO = this.convertType(orbit);
            CircularOrbit cR = this.convertType(reference);
            PositionAngleType cachedPositionAngleType = cO.getCachedPositionAngleType();
            if (cO.hasDerivatives()) {
                return new CircularOrbit(cO.getA(), cO.getCircularEx(), cO.getCircularEy(), cO.getI(), MathUtils.normalizeAngle((double)cO.getRightAscensionOfAscendingNode(), (double)cR.getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle((double)cO.getAlpha(cachedPositionAngleType), (double)cR.getAlpha(cachedPositionAngleType)), cO.getADot(), cO.getCircularExDot(), cO.getCircularEyDot(), cO.getIDot(), cO.getRightAscensionOfAscendingNodeDot(), cO.getAlphaDot(cachedPositionAngleType), cachedPositionAngleType, cO.getFrame(), cO.getDate(), cO.getMu());
            }
            return new CircularOrbit(cO.getA(), cO.getCircularEx(), cO.getCircularEy(), cO.getI(), MathUtils.normalizeAngle((double)cO.getRightAscensionOfAscendingNode(), (double)cR.getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle((double)cO.getAlpha(cachedPositionAngleType), (double)cR.getAlpha(cachedPositionAngleType)), cachedPositionAngleType, cO.getFrame(), cO.getDate(), cO.getMu());
        }

        public <T extends CalculusFieldElement<T>> FieldCircularOrbit<T> normalize(FieldOrbit<T> orbit, FieldOrbit<T> reference) {
            FieldOrbit cO = this.convertType((FieldOrbit)orbit);
            FieldOrbit cR = this.convertType((FieldOrbit)reference);
            PositionAngleType positionAngleType = ((FieldCircularOrbit)cO).getCachedPositionAngleType();
            if (((FieldCircularOrbit)cO).hasDerivatives()) {
                return new FieldCircularOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldCircularOrbit)cO).getA(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularEx(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularEy(), (CalculusFieldElement)((FieldCircularOrbit)cO).getI(), MathUtils.normalizeAngle(((FieldCircularOrbit)cO).getRightAscensionOfAscendingNode(), ((FieldCircularOrbit)cR).getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle(((FieldCircularOrbit)cO).getAlpha(positionAngleType), ((FieldCircularOrbit)cR).getAlpha(positionAngleType)), (CalculusFieldElement)((FieldCircularOrbit)cO).getADot(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularExDot(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularEyDot(), (CalculusFieldElement)((FieldCircularOrbit)cO).getIDot(), (CalculusFieldElement)((FieldCircularOrbit)cO).getRightAscensionOfAscendingNodeDot(), (CalculusFieldElement)((FieldCircularOrbit)cO).getAlphaDot(positionAngleType), positionAngleType, cO.getFrame(), cO.getDate(), (CalculusFieldElement)cO.getMu());
            }
            return new FieldCircularOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldCircularOrbit)cO).getA(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularEx(), (CalculusFieldElement)((FieldCircularOrbit)cO).getCircularEy(), (CalculusFieldElement)((FieldCircularOrbit)cO).getI(), MathUtils.normalizeAngle(((FieldCircularOrbit)cO).getRightAscensionOfAscendingNode(), ((FieldCircularOrbit)cR).getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle(((FieldCircularOrbit)cO).getAlpha(positionAngleType), ((FieldCircularOrbit)cR).getAlpha(positionAngleType)), positionAngleType, cO.getFrame(), cO.getDate(), (CalculusFieldElement)cO.getMu());
        }

        @Override
        public boolean isPositionAngleBased() {
            return true;
        }
    }
    ,
    EQUINOCTIAL{

        @Override
        public EquinoctialOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (EquinoctialOrbit)orbit : new EquinoctialOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngleType type, double[] stateVector, double[] stateVectorDot) {
            EquinoctialOrbit equinoctialOrbit = (EquinoctialOrbit)EQUINOCTIAL.convertType(orbit);
            stateVector[0] = equinoctialOrbit.getA();
            stateVector[1] = equinoctialOrbit.getEquinoctialEx();
            stateVector[2] = equinoctialOrbit.getEquinoctialEy();
            stateVector[3] = equinoctialOrbit.getHx();
            stateVector[4] = equinoctialOrbit.getHy();
            stateVector[5] = equinoctialOrbit.getL(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = equinoctialOrbit.getADot();
                    stateVectorDot[1] = equinoctialOrbit.getEquinoctialExDot();
                    stateVectorDot[2] = equinoctialOrbit.getEquinoctialEyDot();
                    stateVectorDot[3] = equinoctialOrbit.getHxDot();
                    stateVectorDot[4] = equinoctialOrbit.getHyDot();
                    stateVectorDot[5] = equinoctialOrbit.getLDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public EquinoctialOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngleType type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new EquinoctialOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new EquinoctialOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldEquinoctialOrbit)orbit : new FieldEquinoctialOrbit<T>(orbit);
        }

        @Override
        public <T extends CalculusFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngleType type, T[] stateVector, T[] stateVectorDot) {
            FieldEquinoctialOrbit equinoctialOrbit = (FieldEquinoctialOrbit)EQUINOCTIAL.convertType(orbit);
            stateVector[0] = equinoctialOrbit.getA();
            stateVector[1] = equinoctialOrbit.getEquinoctialEx();
            stateVector[2] = equinoctialOrbit.getEquinoctialEy();
            stateVector[3] = equinoctialOrbit.getHx();
            stateVector[4] = equinoctialOrbit.getHy();
            stateVector[5] = equinoctialOrbit.getL(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = equinoctialOrbit.getADot();
                    stateVectorDot[1] = equinoctialOrbit.getEquinoctialExDot();
                    stateVectorDot[2] = equinoctialOrbit.getEquinoctialEyDot();
                    stateVectorDot[3] = equinoctialOrbit.getHxDot();
                    stateVectorDot[4] = equinoctialOrbit.getHyDot();
                    stateVectorDot[5] = equinoctialOrbit.getLDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, orbit.getZero().add(Double.NaN));
                }
            }
        }

        public <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngleType type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldEquinoctialOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldEquinoctialOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> convertToFieldOrbit(Field<T> field, Orbit orbit) {
            return new FieldEquinoctialOrbit<T>(field, EQUINOCTIAL.convertType(orbit));
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngleType type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngleType.MEAN ? OrbitType.MEAN_LON_ARG : (type == PositionAngleType.ECCENTRIC ? OrbitType.ECC_LON_ARG : OrbitType.TRUE_LON_ARG);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.E_X, array[1], scale[1], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.E_Y, array[2], scale[2], -1.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.H_X, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.H_Y, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }

        @Override
        public EquinoctialOrbit normalize(Orbit orbit, Orbit reference) {
            EquinoctialOrbit eO = this.convertType(orbit);
            EquinoctialOrbit eR = this.convertType(reference);
            PositionAngleType cachedPositionAngleType = eO.getCachedPositionAngleType();
            if (eO.hasDerivatives()) {
                return new EquinoctialOrbit(eO.getA(), eO.getEquinoctialEx(), eO.getEquinoctialEy(), eO.getHx(), eO.getHy(), MathUtils.normalizeAngle((double)eO.getL(cachedPositionAngleType), (double)eR.getL(cachedPositionAngleType)), eO.getADot(), eO.getEquinoctialExDot(), eO.getEquinoctialEyDot(), eO.getHxDot(), eO.getHyDot(), eO.getLDot(cachedPositionAngleType), cachedPositionAngleType, eO.getFrame(), eO.getDate(), eO.getMu());
            }
            return new EquinoctialOrbit(eO.getA(), eO.getEquinoctialEx(), eO.getEquinoctialEy(), eO.getHx(), eO.getHy(), MathUtils.normalizeAngle((double)eO.getL(cachedPositionAngleType), (double)eR.getL(cachedPositionAngleType)), cachedPositionAngleType, eO.getFrame(), eO.getDate(), eO.getMu());
        }

        public <T extends CalculusFieldElement<T>> FieldEquinoctialOrbit<T> normalize(FieldOrbit<T> orbit, FieldOrbit<T> reference) {
            FieldOrbit eO = this.convertType((FieldOrbit)orbit);
            FieldOrbit eR = this.convertType((FieldOrbit)reference);
            PositionAngleType positionAngleType = ((FieldEquinoctialOrbit)eO).getCachedPositionAngleType();
            if (((FieldEquinoctialOrbit)eO).hasDerivatives()) {
                return new FieldEquinoctialOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldEquinoctialOrbit)eO).getA(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialEx(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialEy(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHx(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHy(), MathUtils.normalizeAngle(((FieldEquinoctialOrbit)eO).getL(positionAngleType), ((FieldEquinoctialOrbit)eR).getL(positionAngleType)), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getADot(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialExDot(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialEyDot(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHxDot(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHyDot(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getLDot(positionAngleType), positionAngleType, eO.getFrame(), eO.getDate(), (CalculusFieldElement)eO.getMu());
            }
            return new FieldEquinoctialOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldEquinoctialOrbit)eO).getA(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialEx(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getEquinoctialEy(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHx(), (CalculusFieldElement)((FieldEquinoctialOrbit)eO).getHy(), MathUtils.normalizeAngle(((FieldEquinoctialOrbit)eO).getL(positionAngleType), ((FieldEquinoctialOrbit)eR).getL(positionAngleType)), positionAngleType, eO.getFrame(), eO.getDate(), (CalculusFieldElement)eO.getMu());
        }

        @Override
        public boolean isPositionAngleBased() {
            return true;
        }
    }
    ,
    KEPLERIAN{

        @Override
        public KeplerianOrbit convertType(Orbit orbit) {
            return orbit.getType() == this ? (KeplerianOrbit)orbit : new KeplerianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngleType type, double[] stateVector, double[] stateVectorDot) {
            KeplerianOrbit keplerianOrbit = (KeplerianOrbit)KEPLERIAN.convertType(orbit);
            stateVector[0] = keplerianOrbit.getA();
            stateVector[1] = keplerianOrbit.getE();
            stateVector[2] = keplerianOrbit.getI();
            stateVector[3] = keplerianOrbit.getPerigeeArgument();
            stateVector[4] = keplerianOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = keplerianOrbit.getAnomaly(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = keplerianOrbit.getADot();
                    stateVectorDot[1] = keplerianOrbit.getEDot();
                    stateVectorDot[2] = keplerianOrbit.getIDot();
                    stateVectorDot[3] = keplerianOrbit.getPerigeeArgumentDot();
                    stateVectorDot[4] = keplerianOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = keplerianOrbit.getAnomalyDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, Double.NaN);
                }
            }
        }

        @Override
        public KeplerianOrbit mapArrayToOrbit(double[] stateVector, double[] stateVectorDot, PositionAngleType type, AbsoluteDate date, double mu, Frame frame) {
            if (stateVectorDot == null) {
                return new KeplerianOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new KeplerianOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> convertType(FieldOrbit<T> orbit) {
            return orbit.getType() == this ? (FieldKeplerianOrbit)orbit : new FieldKeplerianOrbit<T>(orbit);
        }

        @Override
        public <T extends CalculusFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> orbit, PositionAngleType type, T[] stateVector, T[] stateVectorDot) {
            FieldKeplerianOrbit keplerianOrbit = (FieldKeplerianOrbit)KEPLERIAN.convertType(orbit);
            stateVector[0] = keplerianOrbit.getA();
            stateVector[1] = keplerianOrbit.getE();
            stateVector[2] = keplerianOrbit.getI();
            stateVector[3] = keplerianOrbit.getPerigeeArgument();
            stateVector[4] = keplerianOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = keplerianOrbit.getAnomaly(type);
            if (stateVectorDot != null) {
                if (orbit.hasDerivatives()) {
                    stateVectorDot[0] = keplerianOrbit.getADot();
                    stateVectorDot[1] = keplerianOrbit.getEDot();
                    stateVectorDot[2] = keplerianOrbit.getIDot();
                    stateVectorDot[3] = keplerianOrbit.getPerigeeArgumentDot();
                    stateVectorDot[4] = keplerianOrbit.getRightAscensionOfAscendingNodeDot();
                    stateVectorDot[5] = keplerianOrbit.getAnomalyDot(type);
                } else {
                    Arrays.fill(stateVectorDot, 0, 6, orbit.getZero().add(Double.NaN));
                }
            }
        }

        public <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> mapArrayToOrbit(T[] stateVector, T[] stateVectorDot, PositionAngleType type, FieldAbsoluteDate<T> date, T mu, Frame frame) {
            if (stateVectorDot == null) {
                return new FieldKeplerianOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
            }
            return new FieldKeplerianOrbit<T>(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], stateVectorDot[0], stateVectorDot[1], stateVectorDot[2], stateVectorDot[3], stateVectorDot[4], stateVectorDot[5], type, frame, date, mu);
        }

        public <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> convertToFieldOrbit(Field<T> field, Orbit orbit) {
            return new FieldKeplerianOrbit<T>(field, KEPLERIAN.convertType(orbit));
        }

        @Override
        public ParameterDriversList getDrivers(double dP, Orbit orbit, PositionAngleType type) {
            ParameterDriversList drivers = new ParameterDriversList();
            double[] array = new double[6];
            this.mapOrbitToArray(orbit, type, array, null);
            double[] scale = this.scale(dP, orbit);
            String name = type == PositionAngleType.MEAN ? OrbitType.MEAN_ANOM : (type == PositionAngleType.ECCENTRIC ? OrbitType.ECC_ANOM : OrbitType.TRUE_ANOM);
            drivers.add(new ParameterDriver(OrbitType.A, array[0], scale[0], 0.0, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.ECC, array[1], scale[1], 0.0, 1.0));
            drivers.add(new ParameterDriver(OrbitType.INC, array[2], scale[2], 0.0, Math.PI));
            drivers.add(new ParameterDriver(OrbitType.PA, array[3], scale[3], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(OrbitType.RAAN, array[4], scale[4], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            drivers.add(new ParameterDriver(name, array[5], scale[5], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
            return drivers;
        }

        @Override
        public KeplerianOrbit normalize(Orbit orbit, Orbit reference) {
            KeplerianOrbit kO = this.convertType(orbit);
            KeplerianOrbit kR = this.convertType(reference);
            PositionAngleType cachedPositionAngleType = kO.getCachedPositionAngleType();
            if (kO.hasDerivatives()) {
                return new KeplerianOrbit(kO.getA(), kO.getE(), kO.getI(), MathUtils.normalizeAngle((double)kO.getPerigeeArgument(), (double)kR.getPerigeeArgument()), MathUtils.normalizeAngle((double)kO.getRightAscensionOfAscendingNode(), (double)kR.getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle((double)kO.getAnomaly(cachedPositionAngleType), (double)kR.getAnomaly(cachedPositionAngleType)), kO.getADot(), kO.getEDot(), kO.getIDot(), kO.getPerigeeArgumentDot(), kO.getRightAscensionOfAscendingNodeDot(), kO.getAnomalyDot(cachedPositionAngleType), cachedPositionAngleType, kO.getFrame(), kO.getDate(), kO.getMu());
            }
            return new KeplerianOrbit(kO.getA(), kO.getE(), kO.getI(), MathUtils.normalizeAngle((double)kO.getPerigeeArgument(), (double)kR.getPerigeeArgument()), MathUtils.normalizeAngle((double)kO.getRightAscensionOfAscendingNode(), (double)kR.getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle((double)kO.getAnomaly(cachedPositionAngleType), (double)kR.getAnomaly(cachedPositionAngleType)), cachedPositionAngleType, kO.getFrame(), kO.getDate(), kO.getMu());
        }

        public <T extends CalculusFieldElement<T>> FieldKeplerianOrbit<T> normalize(FieldOrbit<T> orbit, FieldOrbit<T> reference) {
            FieldOrbit kO = this.convertType((FieldOrbit)orbit);
            FieldOrbit kR = this.convertType((FieldOrbit)reference);
            PositionAngleType positionAngleType = ((FieldKeplerianOrbit)kO).getCachedPositionAngleType();
            if (((FieldKeplerianOrbit)kO).hasDerivatives()) {
                return new FieldKeplerianOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldKeplerianOrbit)kO).getA(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getE(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getI(), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getPerigeeArgument(), ((FieldKeplerianOrbit)kR).getPerigeeArgument()), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getRightAscensionOfAscendingNode(), ((FieldKeplerianOrbit)kR).getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getAnomaly(positionAngleType), ((FieldKeplerianOrbit)kR).getAnomaly(positionAngleType)), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getADot(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getEDot(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getIDot(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getPerigeeArgumentDot(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getRightAscensionOfAscendingNodeDot(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getAnomalyDot(positionAngleType), positionAngleType, kO.getFrame(), kO.getDate(), (CalculusFieldElement)kO.getMu());
            }
            return new FieldKeplerianOrbit<CalculusFieldElement>((CalculusFieldElement)((FieldKeplerianOrbit)kO).getA(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getE(), (CalculusFieldElement)((FieldKeplerianOrbit)kO).getI(), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getPerigeeArgument(), ((FieldKeplerianOrbit)kR).getPerigeeArgument()), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getRightAscensionOfAscendingNode(), ((FieldKeplerianOrbit)kR).getRightAscensionOfAscendingNode()), MathUtils.normalizeAngle(((FieldKeplerianOrbit)kO).getAnomaly(positionAngleType), ((FieldKeplerianOrbit)kR).getAnomaly(positionAngleType)), positionAngleType, kO.getFrame(), kO.getDate(), (CalculusFieldElement)kO.getMu());
        }

        @Override
        public boolean isPositionAngleBased() {
            return true;
        }
    };

    public static final String POS_X = "Px";
    public static final String POS_Y = "Py";
    public static final String POS_Z = "Pz";
    public static final String VEL_X = "Vx";
    public static final String VEL_Y = "Vy";
    public static final String VEL_Z = "Vz";
    public static final String A = "a";
    public static final String ECC = "e";
    public static final String E_X = "ex";
    public static final String E_Y = "ey";
    public static final String INC = "i";
    public static final String H_X = "hx";
    public static final String H_Y = "hy";
    public static final String PA = "\u03c9";
    public static final String RAAN = "\u03a9";
    public static final String MEAN_ANOM = "M";
    public static final String ECC_ANOM = "E";
    public static final String TRUE_ANOM = "v";
    public static final String MEAN_LAT_ARG = "\u03b1M";
    public static final String ECC_LAT_ARG = "\u03b1E";
    public static final String TRUE_LAT_ARG = "\u03b1v";
    public static final String MEAN_LON_ARG = "\u03bbM";
    public static final String ECC_LON_ARG = "\u03bbE";
    public static final String TRUE_LON_ARG = "\u03bbv";

    public abstract Orbit convertType(Orbit var1);

    public abstract void mapOrbitToArray(Orbit var1, PositionAngleType var2, double[] var3, double[] var4);

    public abstract Orbit mapArrayToOrbit(double[] var1, double[] var2, PositionAngleType var3, AbsoluteDate var4, double var5, Frame var7);

    public abstract <T extends CalculusFieldElement<T>> FieldOrbit<T> convertType(FieldOrbit<T> var1);

    public abstract <T extends CalculusFieldElement<T>> void mapOrbitToArray(FieldOrbit<T> var1, PositionAngleType var2, T[] var3, T[] var4);

    public abstract <T extends CalculusFieldElement<T>> FieldOrbit<T> mapArrayToOrbit(T[] var1, T[] var2, PositionAngleType var3, FieldAbsoluteDate<T> var4, T var5, Frame var6);

    public abstract <T extends CalculusFieldElement<T>> FieldOrbit<T> convertToFieldOrbit(Field<T> var1, Orbit var2);

    public abstract ParameterDriversList getDrivers(double var1, Orbit var3, PositionAngleType var4);

    public abstract <T extends CalculusFieldElement<T>> FieldOrbit<T> normalize(FieldOrbit<T> var1, FieldOrbit<T> var2);

    public abstract Orbit normalize(Orbit var1, Orbit var2);

    public abstract boolean isPositionAngleBased();

    protected double[] scale(double dP, Orbit orbit) {
        TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
        double r2 = pv.getPosition().getNormSq();
        double v = pv.getVelocity().getNorm();
        double dV = orbit.getMu() * dP / (v * r2);
        double[] scale = new double[6];
        double[][] jacobian = new double[6][6];
        Orbit converted = this.convertType(orbit);
        converted.getJacobianWrtCartesian(PositionAngleType.TRUE, jacobian);
        for (int i = 0; i < 6; ++i) {
            double[] row = jacobian[i];
            scale[i] = FastMath.abs((double)row[0]) * dP + FastMath.abs((double)row[1]) * dP + FastMath.abs((double)row[2]) * dP + FastMath.abs((double)row[3]) * dV + FastMath.abs((double)row[4]) * dV + FastMath.abs((double)row[5]) * dV;
            if (!Double.isNaN(scale[i])) continue;
            throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{this});
        }
        return scale;
    }
}

