/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import org.hipparchus.analysis.polynomials.SmoothStepFactory;
import org.orekit.frames.Frame;
import org.orekit.orbits.AbstractOrbitInterpolator;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OrbitBlender
extends AbstractOrbitInterpolator {
    private final Propagator blendingPropagator;
    private final SmoothStepFactory.SmoothStepFunction blendingFunction;

    public OrbitBlender(SmoothStepFactory.SmoothStepFunction blendingFunction, Propagator blendingPropagator, Frame outputInertialFrame) {
        super(2, 0.0, outputInertialFrame);
        this.blendingFunction = blendingFunction;
        this.blendingPropagator = blendingPropagator;
    }

    @Override
    protected Orbit interpolate(AbstractTimeInterpolator.InterpolationData interpolationData) {
        List neighborList = interpolationData.getNeighborList();
        Orbit previousOrbit = (Orbit)neighborList.get(0);
        Orbit nextOrbit = (Orbit)neighborList.get(1);
        AbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        Orbit forwardedOrbit = this.propagateOrbit(previousOrbit, interpolationDate);
        Orbit backwardedOrbit = this.propagateOrbit(nextOrbit, interpolationDate);
        TimeStampedPVCoordinates forwardedPV = forwardedOrbit.getPVCoordinates(this.getOutputInertialFrame());
        TimeStampedPVCoordinates backwardedPV = backwardedOrbit.getPVCoordinates(this.getOutputInertialFrame());
        double timeParameter = this.getTimeParameter(interpolationDate, previousOrbit.getDate(), nextOrbit.getDate());
        double blendingValue = this.blendingFunction.value(timeParameter);
        PVCoordinates blendedPV = forwardedPV.blendArithmeticallyWith(backwardedPV, blendingValue);
        return new CartesianOrbit(blendedPV, this.getOutputInertialFrame(), interpolationDate, previousOrbit.getMu());
    }

    private Orbit propagateOrbit(Orbit tabulatedOrbit, AbsoluteDate propagationDate) {
        this.blendingPropagator.resetInitialState(new SpacecraftState(tabulatedOrbit));
        return this.blendingPropagator.propagate(propagationDate).getOrbit();
    }
}

