/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.complex.Complex;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.EigenDecompositionNonSymmetric;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.orbits.CR3BPDifferentialCorrection;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.utils.PVCoordinates;

public abstract class LibrationOrbit {
    private final CR3BPSystem syst;
    private PVCoordinates initialPV;
    private double orbitalPeriod;

    protected LibrationOrbit(CR3BPSystem system, PVCoordinates initialPV, double orbitalPeriod) {
        this.syst = system;
        this.initialPV = initialPV;
        this.orbitalPeriod = orbitalPeriod;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }

    public PVCoordinates getInitialPV() {
        return this.initialPV;
    }

    public void applyDifferentialCorrection() {
        CR3BPDifferentialCorrection diff = new CR3BPDifferentialCorrection(this.initialPV, this.syst, this.orbitalPeriod);
        this.initialPV = this.applyCorrectionOnPV(diff);
        this.orbitalPeriod = diff.getOrbitalPeriod();
    }

    public PVCoordinates getManifolds(SpacecraftState s, boolean isStable) {
        int eigenVectorIndex = isStable ? 1 : 0;
        double epsilon = this.syst.getVdim() * 100.0 / this.syst.getDdim();
        RealMatrix phi = new STMEquations(this.syst).getStateTransitionMatrix(s);
        EigenDecompositionNonSymmetric eigen = new EigenDecompositionNonSymmetric(phi);
        FieldVector cv = eigen.getEigenvector(eigenVectorIndex);
        RealVector rv = MatrixUtils.createRealVector((int)cv.getDimension());
        for (int i = 0; i < cv.getDimension(); ++i) {
            rv.setEntry(i, ((Complex)cv.getEntry(i)).getRealPart());
        }
        RealVector eigenVector = rv.unitVector();
        return new PVCoordinates(s.getPosition().add((Vector)new Vector3D(eigenVector.getEntry(0), eigenVector.getEntry(1), eigenVector.getEntry(2)).scalarMultiply(epsilon)), s.getPVCoordinates().getVelocity().add((Vector)new Vector3D(eigenVector.getEntry(3), eigenVector.getEntry(4), eigenVector.getEntry(5)).scalarMultiply(epsilon)));
    }

    protected abstract PVCoordinates applyCorrectionOnPV(CR3BPDifferentialCorrection var1);
}

