/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.orbits.FieldKeplerianAnomalyUtility;
import org.orekit.orbits.KeplerianAnomalyUtility;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;

public class KeplerianMotionCartesianUtility {
    private KeplerianMotionCartesianUtility() {
    }

    public static PVCoordinates predictPositionVelocity(double dt, Vector3D position, Vector3D velocity, double mu) {
        double r = position.getNorm();
        double a = r / (2.0 - r * velocity.getNormSq() / mu);
        if (a >= 0.0) {
            return KeplerianMotionCartesianUtility.predictPVElliptic(dt, position, velocity, mu, a, r);
        }
        return KeplerianMotionCartesianUtility.predictPVHyperbolic(dt, position, velocity, mu, a, r);
    }

    private static PVCoordinates predictPVElliptic(double dt, Vector3D position, Vector3D velocity, double mu, double a, double r) {
        Vector3D pvM = position.crossProduct((Vector)velocity);
        double muA = mu * a;
        double eSE = position.dotProduct((Vector)velocity) / FastMath.sqrt((double)muA);
        double eCE = 1.0 - r / a;
        double E0 = FastMath.atan2((double)eSE, (double)eCE);
        double M0 = E0 - eSE;
        double e = FastMath.sqrt((double)(eCE * eCE + eSE * eSE));
        double sqrt = FastMath.sqrt((double)((1.0 + e) / (1.0 - e)));
        double v0 = 2.0 * FastMath.atan((double)(sqrt * FastMath.tan((double)(E0 / 2.0))));
        Rotation rotation = new Rotation(pvM, v0, RotationConvention.FRAME_TRANSFORM);
        Vector3D p = (Vector3D)rotation.applyTo(position).normalize();
        Vector3D q = (Vector3D)pvM.crossProduct((Vector)p).normalize();
        double sqrtRatio = FastMath.sqrt((double)(mu / a));
        double meanMotion = sqrtRatio / a;
        double M1 = M0 + meanMotion * dt;
        double E1 = KeplerianAnomalyUtility.ellipticMeanToEccentric(e, M1);
        SinCos scE = FastMath.sinCos((double)E1);
        double cE = scE.cos();
        double sE = scE.sin();
        double sE2m1 = FastMath.sqrt((double)((1.0 - e) * (1.0 + e)));
        double x = a * (cE - e);
        double y = a * sE2m1 * sE;
        double factor = sqrtRatio / (1.0 - e * cE);
        double xDot = -factor * sE;
        double yDot = factor * sE2m1 * cE;
        Vector3D predictedPosition = new Vector3D(x, p, y, q);
        Vector3D predictedVelocity = new Vector3D(xDot, p, yDot, q);
        return new PVCoordinates(predictedPosition, predictedVelocity);
    }

    private static PVCoordinates predictPVHyperbolic(double dt, Vector3D position, Vector3D velocity, double mu, double a, double r) {
        Vector3D pvM = position.crossProduct((Vector)velocity);
        double muA = mu * a;
        double e = FastMath.sqrt((double)(1.0 - pvM.getNormSq() / muA));
        double sqrt = FastMath.sqrt((double)((e + 1.0) / (e - 1.0)));
        double eSH = position.dotProduct((Vector)velocity) / FastMath.sqrt((double)(-muA));
        double eCH = 1.0 - r / a;
        double H0 = FastMath.log((double)((eCH + eSH) / (eCH - eSH))) / 2.0;
        double M0 = e * FastMath.sinh((double)H0) - H0;
        double v0 = 2.0 * FastMath.atan((double)(sqrt * FastMath.tanh((double)(H0 / 2.0))));
        Rotation rotation = new Rotation(pvM, v0, RotationConvention.FRAME_TRANSFORM);
        Vector3D p = (Vector3D)rotation.applyTo(position).normalize();
        Vector3D q = (Vector3D)pvM.crossProduct((Vector)p).normalize();
        double absA = FastMath.abs((double)a);
        double sqrtRatio = FastMath.sqrt((double)(mu / absA));
        double meanMotion = sqrtRatio / absA;
        double M1 = M0 + meanMotion * dt;
        double H1 = KeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, M1);
        double cH = FastMath.cosh((double)H1);
        double sH = FastMath.sinh((double)H1);
        double sE2m1 = FastMath.sqrt((double)((e - 1.0) * (e + 1.0)));
        double x = a * (cH - e);
        double y = -a * sE2m1 * sH;
        double factor = sqrtRatio / (e * cH - 1.0);
        double xDot = -factor * sH;
        double yDot = factor * sE2m1 * cH;
        Vector3D predictedPosition = new Vector3D(x, p, y, q);
        Vector3D predictedVelocity = new Vector3D(xDot, p, yDot, q);
        return new PVCoordinates(predictedPosition, predictedVelocity);
    }

    public static <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> predictPositionVelocity(T dt, FieldVector3D<T> position, FieldVector3D<T> velocity, T mu) {
        CalculusFieldElement r = position.getNorm();
        CalculusFieldElement a = (CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)velocity.getNormSq())).divide(mu)).negate()).add(2.0)));
        if (a.getReal() >= 0.0) {
            return KeplerianMotionCartesianUtility.predictPVElliptic(dt, position, velocity, mu, a, r);
        }
        return KeplerianMotionCartesianUtility.predictPVHyperbolic(dt, position, velocity, mu, a, r);
    }

    private static <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> predictPVElliptic(T dt, FieldVector3D<T> position, FieldVector3D<T> velocity, T mu, T a, T r) {
        FieldVector3D pvM = position.crossProduct(velocity);
        CalculusFieldElement muA = (CalculusFieldElement)mu.multiply(a);
        CalculusFieldElement eSE = (CalculusFieldElement)position.dotProduct(velocity).divide((FieldElement)((CalculusFieldElement)muA.sqrt()));
        CalculusFieldElement eCE = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.divide(a)).negate()).add(1.0);
        CalculusFieldElement E0 = FastMath.atan2((CalculusFieldElement)eSE, (CalculusFieldElement)eCE);
        CalculusFieldElement M0 = (CalculusFieldElement)E0.subtract((FieldElement)eSE);
        CalculusFieldElement e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCE.square()).add((FieldElement)((CalculusFieldElement)eSE.square()))).sqrt();
        CalculusFieldElement ePlusOne = (CalculusFieldElement)e.add(1.0);
        CalculusFieldElement oneMinusE = (CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0);
        CalculusFieldElement sqrt = (CalculusFieldElement)((CalculusFieldElement)ePlusOne.divide((FieldElement)oneMinusE)).sqrt();
        CalculusFieldElement v0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)E0.divide(2.0)).tan()))).atan()).multiply(2);
        FieldRotation rotation = new FieldRotation(pvM, v0, RotationConvention.FRAME_TRANSFORM);
        FieldVector3D p = rotation.applyTo(position).normalize();
        FieldVector3D q = pvM.crossProduct(p).normalize();
        CalculusFieldElement sqrtRatio = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.reciprocal()).multiply(mu)).sqrt();
        CalculusFieldElement meanMotion = (CalculusFieldElement)sqrtRatio.divide(a);
        CalculusFieldElement M1 = (CalculusFieldElement)M0.add((FieldElement)((CalculusFieldElement)meanMotion.multiply(dt)));
        CalculusFieldElement E1 = FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(e, M1);
        FieldSinCos scE = FastMath.sinCos((CalculusFieldElement)E1);
        CalculusFieldElement cE = (CalculusFieldElement)scE.cos();
        CalculusFieldElement sE = (CalculusFieldElement)scE.sin();
        CalculusFieldElement sE2m1 = (CalculusFieldElement)((CalculusFieldElement)oneMinusE.multiply((FieldElement)ePlusOne)).sqrt();
        CalculusFieldElement x = (CalculusFieldElement)a.multiply((FieldElement)((CalculusFieldElement)cE.subtract((FieldElement)e)));
        CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)a.multiply((FieldElement)sE2m1)).multiply((FieldElement)sE);
        CalculusFieldElement factor = (CalculusFieldElement)sqrtRatio.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)cE)).negate()).add(1.0)));
        CalculusFieldElement xDot = (CalculusFieldElement)((CalculusFieldElement)factor.multiply((FieldElement)sE)).negate();
        CalculusFieldElement yDot = (CalculusFieldElement)((CalculusFieldElement)factor.multiply((FieldElement)sE2m1)).multiply((FieldElement)cE);
        FieldVector3D predictedPosition = new FieldVector3D(x, p, y, q);
        FieldVector3D predictedVelocity = new FieldVector3D(xDot, p, yDot, q);
        return new FieldPVCoordinates(predictedPosition, predictedVelocity);
    }

    private static <T extends CalculusFieldElement<T>> FieldPVCoordinates<T> predictPVHyperbolic(T dt, FieldVector3D<T> position, FieldVector3D<T> velocity, T mu, T a, T r) {
        FieldVector3D pvM = position.crossProduct(velocity);
        CalculusFieldElement muA = (CalculusFieldElement)a.multiply(mu);
        CalculusFieldElement e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.newInstance(1.0)).subtract((FieldElement)((CalculusFieldElement)pvM.getNormSq().divide((FieldElement)muA)))).sqrt();
        CalculusFieldElement ePlusOne = (CalculusFieldElement)e.add(1.0);
        CalculusFieldElement eMinusOne = (CalculusFieldElement)e.subtract(1.0);
        CalculusFieldElement sqrt = (CalculusFieldElement)((CalculusFieldElement)ePlusOne.divide((FieldElement)eMinusOne)).sqrt();
        CalculusFieldElement eSH = (CalculusFieldElement)position.dotProduct(velocity).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)muA.negate()).sqrt()));
        CalculusFieldElement eCH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.divide(a)).negate()).add(1.0);
        CalculusFieldElement H0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCH.add((FieldElement)eSH)).divide((FieldElement)((CalculusFieldElement)eCH.subtract((FieldElement)eSH)))).log()).divide(2.0);
        CalculusFieldElement M0 = (CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)H0.sinh()))).subtract((FieldElement)H0);
        CalculusFieldElement v0 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrt.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)H0.divide(2.0)).tanh()))).atan()).multiply(2);
        FieldRotation rotation = new FieldRotation(pvM, v0, RotationConvention.FRAME_TRANSFORM);
        FieldVector3D p = rotation.applyTo(position).normalize();
        FieldVector3D q = pvM.crossProduct(p).normalize();
        CalculusFieldElement sqrtRatio = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.reciprocal()).negate()).multiply(mu)).sqrt();
        CalculusFieldElement meanMotion = (CalculusFieldElement)((CalculusFieldElement)sqrtRatio.divide(a)).negate();
        CalculusFieldElement M1 = (CalculusFieldElement)M0.add((FieldElement)((CalculusFieldElement)meanMotion.multiply(dt)));
        CalculusFieldElement H1 = FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, M1);
        CalculusFieldElement cH = (CalculusFieldElement)H1.cosh();
        CalculusFieldElement sH = (CalculusFieldElement)H1.sinh();
        CalculusFieldElement sE2m1 = (CalculusFieldElement)((CalculusFieldElement)eMinusOne.multiply((FieldElement)ePlusOne)).sqrt();
        CalculusFieldElement x = (CalculusFieldElement)a.multiply((FieldElement)((CalculusFieldElement)cH.subtract((FieldElement)e)));
        CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.negate()).multiply((FieldElement)sE2m1)).multiply((FieldElement)sH);
        CalculusFieldElement factor = (CalculusFieldElement)sqrtRatio.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)cH)).subtract(1.0)));
        CalculusFieldElement xDot = (CalculusFieldElement)((CalculusFieldElement)factor.negate()).multiply((FieldElement)sH);
        CalculusFieldElement yDot = (CalculusFieldElement)((CalculusFieldElement)factor.multiply((FieldElement)sE2m1)).multiply((FieldElement)cH);
        FieldVector3D predictedPosition = new FieldVector3D(x, p, y, q);
        FieldVector3D predictedVelocity = new FieldVector3D(xDot, p, yDot, q);
        return new FieldPVCoordinates(predictedPosition, predictedVelocity);
    }
}

