/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public final class KeplerianAnomalyUtility {
    private static final double A;
    private static final double B;

    private KeplerianAnomalyUtility() {
    }

    public static double ellipticMeanToTrue(double e, double M) {
        double E = KeplerianAnomalyUtility.ellipticMeanToEccentric(e, M);
        double v = KeplerianAnomalyUtility.ellipticEccentricToTrue(e, E);
        return v;
    }

    public static double ellipticTrueToMean(double e, double v) {
        double E = KeplerianAnomalyUtility.ellipticTrueToEccentric(e, v);
        double M = KeplerianAnomalyUtility.ellipticEccentricToMean(e, E);
        return M;
    }

    public static double ellipticEccentricToTrue(double e, double E) {
        double beta = e / (1.0 + FastMath.sqrt((double)((1.0 - e) * (1.0 + e))));
        SinCos scE = FastMath.sinCos((double)E);
        return E + 2.0 * FastMath.atan((double)(beta * scE.sin() / (1.0 - beta * scE.cos())));
    }

    public static double ellipticTrueToEccentric(double e, double v) {
        double beta = e / (1.0 + FastMath.sqrt((double)(1.0 - e * e)));
        SinCos scv = FastMath.sinCos((double)v);
        return v - 2.0 * FastMath.atan((double)(beta * scv.sin() / (1.0 + beta * scv.cos())));
    }

    public static double ellipticMeanToEccentric(double e, double M) {
        double w;
        double E;
        double reducedM = MathUtils.normalizeAngle((double)M, (double)0.0);
        if (FastMath.abs((double)reducedM) < 0.16666666666666666) {
            E = reducedM + e * (FastMath.cbrt((double)(6.0 * reducedM)) - reducedM);
        } else if (reducedM < 0.0) {
            w = Math.PI + reducedM;
            E = reducedM + e * (A * w / (B - w) - Math.PI - reducedM);
        } else {
            w = Math.PI - reducedM;
            E = reducedM + e * (Math.PI - A * w / (B - w) - reducedM);
        }
        double e1 = 1.0 - e;
        boolean noCancellationRisk = e1 + E * E / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            double fd;
            double f;
            SinCos sc = FastMath.sinCos((double)E);
            double fdd = e * sc.sin();
            double fddd = e * sc.cos();
            if (noCancellationRisk) {
                f = E - fdd - reducedM;
                fd = 1.0 - fddd;
            } else {
                f = KeplerianAnomalyUtility.eMeSinE(e, E) - reducedM;
                double s = FastMath.sin((double)(0.5 * E));
                fd = e1 + 2.0 * e * s * s;
            }
            double dee = f * fd / (0.5 * f * fdd - fd * fd);
            double w2 = fd + 0.5 * dee * (fdd + dee * fddd / 3.0);
            E -= (f - dee * ((fd += dee * (fdd + 0.5 * dee * fddd)) - w2)) / fd;
        }
        return E += M - reducedM;
    }

    private static double eMeSinE(double e, double E) {
        double x = (1.0 - e) * FastMath.sin((double)E);
        double mE2 = -E * E;
        double term = E;
        double d = 0.0;
        double x0 = Double.NaN;
        while (!Double.valueOf(x).equals(x0)) {
            x0 = x;
            x -= (term *= mE2 / ((d += 2.0) * (d + 1.0)));
        }
        return x;
    }

    public static double ellipticEccentricToMean(double e, double E) {
        return E - e * FastMath.sin((double)E);
    }

    public static double hyperbolicMeanToTrue(double e, double M) {
        double H = KeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, M);
        double v = KeplerianAnomalyUtility.hyperbolicEccentricToTrue(e, H);
        return v;
    }

    public static double hyperbolicTrueToMean(double e, double v) {
        double H = KeplerianAnomalyUtility.hyperbolicTrueToEccentric(e, v);
        double M = KeplerianAnomalyUtility.hyperbolicEccentricToMean(e, H);
        return M;
    }

    public static double hyperbolicEccentricToTrue(double e, double H) {
        return 2.0 * FastMath.atan((double)(FastMath.sqrt((double)((e + 1.0) / (e - 1.0))) * FastMath.tanh((double)(0.5 * H))));
    }

    public static double hyperbolicTrueToEccentric(double e, double v) {
        SinCos scv = FastMath.sinCos((double)v);
        double sinhH = FastMath.sqrt((double)(e * e - 1.0)) * scv.sin() / (1.0 + e * scv.cos());
        return FastMath.asinh((double)sinhH);
    }

    public static double hyperbolicMeanToEccentric(double e, double M) {
        double L = M / e;
        double g = 1.0 / e;
        double g1 = 1.0 - g;
        double S = L;
        if (L == 0.0) {
            return 0.0;
        }
        double cl = FastMath.sqrt((double)(1.0 + L * L));
        double al = FastMath.asinh((double)L);
        double w = g * g * al / (cl * cl * cl);
        S = 1.0 - g / cl;
        S = L + g * al / FastMath.cbrt((double)(S * S * S + w * L * (1.5 - 1.3333333333333333 * g)));
        for (int i = 0; i < 2; ++i) {
            double fd;
            double f;
            double s0 = S * S;
            double s1 = s0 + 1.0;
            double s2 = FastMath.sqrt((double)s1);
            double s3 = s1 * s2;
            double fdd = g * S / s3;
            double fddd = g * (1.0 - 2.0 * s0) / (s1 * s3);
            if (s0 / 6.0 + g1 >= 0.5) {
                f = S - g * FastMath.asinh((double)S) - L;
                fd = 1.0 - g / s2;
            } else {
                double x0;
                double t = S / (1.0 + FastMath.sqrt((double)(1.0 + S * S)));
                double tsq = t * t;
                double x = S * (g1 + g * tsq);
                double term = 2.0 * g * t;
                double twoI1 = 1.0;
                int j = 0;
                do {
                    if (++j != 1000000) continue;
                    throw new MathIllegalStateException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{j});
                } while ((x -= (term *= tsq) / (twoI1 += 2.0)) != (x0 = x));
                f = x - L;
                fd = (s0 / (s2 + 1.0) + g1) / s2;
            }
            double ds = f * fd / (0.5 * f * fdd - fd * fd);
            double stemp = S + ds;
            if (S == stemp) break;
            f += ds * (fd + 0.5 * ds * (fdd + ds / 3.0 * fddd));
            S = stemp - f / (fd += ds * (fdd + 0.5 * ds * fddd));
        }
        double H = FastMath.asinh((double)S);
        return H;
    }

    public static double hyperbolicEccentricToMean(double e, double H) {
        return e * FastMath.sinh((double)H) - H;
    }

    public static double convertAnomaly(PositionAngleType oldType, double anomaly, double e, PositionAngleType newType) {
        if (newType == oldType) {
            return anomaly;
        }
        if (e > 1.0) {
            switch (newType) {
                case MEAN: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return KeplerianAnomalyUtility.hyperbolicEccentricToMean(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.hyperbolicTrueToMean(e, anomaly);
                }
                case ECCENTRIC: {
                    if (oldType == PositionAngleType.MEAN) {
                        return KeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.hyperbolicTrueToEccentric(e, anomaly);
                }
                case TRUE: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return KeplerianAnomalyUtility.hyperbolicEccentricToTrue(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.hyperbolicMeanToTrue(e, anomaly);
                }
            }
        } else {
            switch (newType) {
                case MEAN: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return KeplerianAnomalyUtility.ellipticEccentricToMean(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.ellipticTrueToMean(e, anomaly);
                }
                case ECCENTRIC: {
                    if (oldType == PositionAngleType.MEAN) {
                        return KeplerianAnomalyUtility.ellipticMeanToEccentric(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.ellipticTrueToEccentric(e, anomaly);
                }
                case TRUE: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return KeplerianAnomalyUtility.ellipticEccentricToTrue(e, anomaly);
                    }
                    return KeplerianAnomalyUtility.ellipticMeanToTrue(e, anomaly);
                }
            }
        }
        throw new OrekitInternalError(null);
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

