/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitInternalError;
import org.orekit.frames.Frame;
import org.orekit.orbits.AbstractFieldOrbitInterpolator;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldCircularOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldKeplerianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinatesHermiteInterpolator;

public class FieldOrbitHermiteInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldOrbitInterpolator<KK> {
    private final CartesianDerivativesFilter pvaFilter;
    private Field<KK> field;
    private KK zero;
    private KK one;

    public FieldOrbitHermiteInterpolator(Frame outputInertialFrame) {
        this(2, outputInertialFrame);
    }

    public FieldOrbitHermiteInterpolator(int interpolationPoints, Frame outputInertialFrame) {
        this(interpolationPoints, outputInertialFrame, CartesianDerivativesFilter.USE_PVA);
    }

    public FieldOrbitHermiteInterpolator(int interpolationPoints, Frame outputInertialFrame, CartesianDerivativesFilter pvaFilter) {
        this(interpolationPoints, 0.001, outputInertialFrame, pvaFilter);
    }

    public FieldOrbitHermiteInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputInertialFrame, CartesianDerivativesFilter pvaFilter) {
        super(interpolationPoints, extrapolationThreshold, outputInertialFrame);
        this.pvaFilter = pvaFilter;
    }

    public CartesianDerivativesFilter getPVAFilter() {
        return this.pvaFilter;
    }

    @Override
    protected FieldOrbit<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List<FieldOrbit<KK>> sample = interpolationData.getNeighborList();
        FieldOrbit firstEntry = (FieldOrbit)sample.get(0);
        OrbitType orbitType = firstEntry.getType();
        this.field = firstEntry.getA().getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
        if (orbitType == OrbitType.CARTESIAN) {
            return this.interpolateCartesian(interpolationDate, sample);
        }
        return this.interpolateCommon(interpolationDate, sample, orbitType);
    }

    private FieldCartesianOrbit<KK> interpolateCartesian(FieldAbsoluteDate<KK> interpolationDate, List<FieldOrbit<KK>> sample) {
        TimeStampedFieldPVCoordinatesHermiteInterpolator<KK> interpolator = new TimeStampedFieldPVCoordinatesHermiteInterpolator<KK>(this.getNbInterpolationPoints(), this.getExtrapolationThreshold(), this.pvaFilter);
        Stream sampleStream = sample.stream();
        Stream<TimeStampedFieldPVCoordinates> sampleTimeStampedPV = sampleStream.map(FieldOrbit::getPVCoordinates);
        TimeStampedFieldPVCoordinates interpolated = interpolator.interpolate(interpolationDate, sampleTimeStampedPV);
        KK mu = sample.get(0).getMu();
        return new FieldCartesianOrbit<KK>(interpolated, this.getOutputInertialFrame(), interpolationDate, mu);
    }

    private FieldOrbit<KK> interpolateCommon(FieldAbsoluteDate<KK> interpolationDate, List<FieldOrbit<KK>> orbits, OrbitType orbitType) {
        boolean useDerivatives = true;
        for (FieldOrbit<KK> orbit : orbits) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        KK mu = orbits.get(0).getMu();
        switch (orbitType) {
            case CIRCULAR: {
                CalculusFieldElement[][] interpolated = this.interpolateCircular(interpolationDate, orbits, useDerivatives);
                return new FieldCircularOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngleType.MEAN, this.getOutputInertialFrame(), (FieldAbsoluteDate<CalculusFieldElement>)interpolationDate, (CalculusFieldElement)mu);
            }
            case KEPLERIAN: {
                CalculusFieldElement[][] interpolated = this.interpolateKeplerian(interpolationDate, orbits, useDerivatives);
                return new FieldKeplerianOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngleType.MEAN, this.getOutputInertialFrame(), (FieldAbsoluteDate<CalculusFieldElement>)interpolationDate, (CalculusFieldElement)mu);
            }
            case EQUINOCTIAL: {
                CalculusFieldElement[][] interpolated = this.interpolateEquinoctial(interpolationDate, orbits, useDerivatives);
                return new FieldEquinoctialOrbit<CalculusFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngleType.MEAN, this.getOutputInertialFrame(), (FieldAbsoluteDate<CalculusFieldElement>)interpolationDate, (CalculusFieldElement)mu);
            }
        }
        throw new OrekitInternalError(null);
    }

    private KK[][] interpolateCircular(FieldAbsoluteDate<KK> interpolationDate, List<FieldOrbit<KK>> orbits, boolean useDerivatives) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousRAAN = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousAlphaM = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit<KK> orbit : orbits) {
            Object continuousAlphaM;
            Object continuousRAAN;
            FieldCircularOrbit circ = (FieldCircularOrbit)OrbitType.CIRCULAR.convertType(orbit);
            if (previousDate == null) {
                continuousRAAN = circ.getRightAscensionOfAscendingNode();
                continuousAlphaM = circ.getAlphaM();
            } else {
                Object dt = circ.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerAM = (CalculusFieldElement)previousAlphaM.add((FieldElement)((CalculusFieldElement)circ.getKeplerianMeanMotion().multiply(dt)));
                continuousRAAN = MathUtils.normalizeAngle(circ.getRightAscensionOfAscendingNode(), (CalculusFieldElement)previousRAAN);
                continuousAlphaM = MathUtils.normalizeAngle(circ.getAlphaM(), (CalculusFieldElement)keplerAM);
            }
            previousDate = circ.getDate();
            previousRAAN = continuousRAAN;
            previousAlphaM = continuousAlphaM;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
            toAdd[0] = circ.getA();
            toAdd[1] = circ.getCircularEx();
            toAdd[2] = circ.getCircularEy();
            toAdd[3] = circ.getI();
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousAlphaM;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = circ.getADot();
                toAddDot[1] = circ.getCircularExDot();
                toAddDot[2] = circ.getCircularEyDot();
                toAddDot[3] = circ.getIDot();
                toAddDot[4] = circ.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = circ.getAlphaMDot();
                interpolator.addSamplePoint(circ.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(circ.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        return (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
    }

    private KK[][] interpolateKeplerian(FieldAbsoluteDate<KK> interpolationDate, List<FieldOrbit<KK>> orbits, boolean useDerivatives) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousPA = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousRAAN = (CalculusFieldElement)this.zero.add(Double.NaN);
        Object previousM = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit<KK> orbit : orbits) {
            Object continuousM;
            Object continuousRAAN;
            Object continuousPA;
            FieldKeplerianOrbit kep = (FieldKeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
            if (previousDate == null) {
                continuousPA = kep.getPerigeeArgument();
                continuousRAAN = kep.getRightAscensionOfAscendingNode();
                continuousM = kep.getMeanAnomaly();
            } else {
                Object dt = kep.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerM = (CalculusFieldElement)previousM.add((FieldElement)((CalculusFieldElement)kep.getKeplerianMeanMotion().multiply(dt)));
                continuousPA = MathUtils.normalizeAngle(kep.getPerigeeArgument(), (CalculusFieldElement)previousPA);
                continuousRAAN = MathUtils.normalizeAngle(kep.getRightAscensionOfAscendingNode(), (CalculusFieldElement)previousRAAN);
                continuousM = MathUtils.normalizeAngle(kep.getMeanAnomaly(), (CalculusFieldElement)keplerM);
            }
            previousDate = kep.getDate();
            previousPA = continuousPA;
            previousRAAN = continuousRAAN;
            previousM = continuousM;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)6);
            toAdd[0] = kep.getA();
            toAdd[1] = kep.getE();
            toAdd[2] = kep.getI();
            toAdd[3] = continuousPA;
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousM;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)6);
                toAddDot[0] = kep.getADot();
                toAddDot[1] = kep.getEDot();
                toAddDot[2] = kep.getIDot();
                toAddDot[3] = kep.getPerigeeArgumentDot();
                toAddDot[4] = kep.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = kep.getMeanAnomalyDot();
                interpolator.addSamplePoint(kep.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint((FieldElement)((CalculusFieldElement)this.zero.add(kep.getDate().durationFrom(interpolationDate))), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        return (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
    }

    private KK[][] interpolateEquinoctial(FieldAbsoluteDate<KK> interpolationDate, List<FieldOrbit<KK>> orbits, boolean useDerivatives) {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousLm = (CalculusFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit<KK> orbit : orbits) {
            Object continuousLm;
            FieldEquinoctialOrbit equi = (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(orbit);
            if (previousDate == null) {
                continuousLm = equi.getLM();
            } else {
                Object dt = equi.getDate().durationFrom(previousDate);
                CalculusFieldElement keplerLm = (CalculusFieldElement)previousLm.add((FieldElement)((CalculusFieldElement)equi.getKeplerianMeanMotion().multiply(dt)));
                continuousLm = MathUtils.normalizeAngle(equi.getLM(), (CalculusFieldElement)keplerLm);
            }
            previousDate = equi.getDate();
            previousLm = continuousLm;
            CalculusFieldElement[] toAdd = (CalculusFieldElement[])MathArrays.buildArray(this.field, (int)6);
            toAdd[0] = equi.getA();
            toAdd[1] = equi.getEquinoctialEx();
            toAdd[2] = equi.getEquinoctialEy();
            toAdd[3] = equi.getHx();
            toAdd[4] = equi.getHy();
            toAdd[5] = continuousLm;
            if (useDerivatives) {
                CalculusFieldElement[] toAddDot = (CalculusFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = equi.getADot();
                toAddDot[1] = equi.getEquinoctialExDot();
                toAddDot[2] = equi.getEquinoctialEyDot();
                toAddDot[3] = equi.getHxDot();
                toAddDot[4] = equi.getHyDot();
                toAddDot[5] = equi.getLMDot();
                interpolator.addSamplePoint(equi.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(equi.getDate().durationFrom(interpolationDate), (FieldElement[][])new CalculusFieldElement[][]{toAdd});
        }
        return (CalculusFieldElement[][])interpolator.derivatives(this.zero, 1);
    }
}

