/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.polynomials.SmoothStepFactory;
import org.orekit.frames.Frame;
import org.orekit.orbits.AbstractFieldOrbitInterpolator;
import org.orekit.orbits.FieldCartesianOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.analytical.FieldAbstractAnalyticalPropagator;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldOrbitBlender<KK extends CalculusFieldElement<KK>>
extends AbstractFieldOrbitInterpolator<KK> {
    private final FieldAbstractAnalyticalPropagator<KK> analyticalPropagator;
    private final SmoothStepFactory.FieldSmoothStepFunction<KK> blendingFunction;

    public FieldOrbitBlender(SmoothStepFactory.FieldSmoothStepFunction<KK> blendingFunction, FieldAbstractAnalyticalPropagator<KK> analyticalPropagator, Frame outputInertialFrame) {
        super(2, 0.0, outputInertialFrame);
        this.blendingFunction = blendingFunction;
        this.analyticalPropagator = analyticalPropagator;
    }

    @Override
    public FieldOrbit<KK> interpolate(AbstractFieldTimeInterpolator.InterpolationData interpolationData) {
        FieldAbsoluteDate interpolationDate = interpolationData.getInterpolationDate();
        List neighborList = interpolationData.getNeighborList();
        FieldOrbit previousOrbit = (FieldOrbit)neighborList.get(0);
        FieldOrbit nextOrbit = (FieldOrbit)neighborList.get(1);
        FieldOrbit forwardedOrbit = this.propagateOrbitAnalytically(previousOrbit, interpolationDate);
        FieldOrbit backwardedOrbit = this.propagateOrbitAnalytically(nextOrbit, interpolationDate);
        TimeStampedFieldPVCoordinates forwardedPV = forwardedOrbit.getPVCoordinates(this.getOutputInertialFrame());
        TimeStampedFieldPVCoordinates backwardedPV = backwardedOrbit.getPVCoordinates(this.getOutputInertialFrame());
        Object timeParameter = this.getTimeParameter(interpolationDate, previousOrbit.getDate(), nextOrbit.getDate());
        CalculusFieldElement blendingValue = this.blendingFunction.value(timeParameter);
        FieldPVCoordinates<CalculusFieldElement> blendedPV = forwardedPV.blendArithmeticallyWith(backwardedPV, blendingValue);
        return new FieldCartesianOrbit<CalculusFieldElement>(blendedPV, this.getOutputInertialFrame(), interpolationDate, (CalculusFieldElement)previousOrbit.getMu());
    }

    private FieldOrbit<KK> propagateOrbitAnalytically(FieldOrbit<KK> tabulatedOrbit, FieldAbsoluteDate<KK> propagationDate) {
        this.analyticalPropagator.resetInitialState(new FieldSpacecraftState<KK>(tabulatedOrbit));
        return this.analyticalPropagator.propagate(propagationDate).getOrbit();
    }
}

