/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.Derivative;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldStaticTransform;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class FieldOrbit<T extends CalculusFieldElement<T>>
implements FieldPVCoordinatesProvider<T>,
FieldTimeStamped<T>,
FieldTimeShiftable<FieldOrbit<T>, T> {
    private final Frame frame;
    private final FieldAbsoluteDate<T> date;
    private final T mu;
    private final T one;
    private final T zero;
    private final Field<T> field;
    private transient FieldVector3D<T> position;
    private transient TimeStampedFieldPVCoordinates<T> pvCoordinates;
    private transient T[][] jacobianMeanWrtCartesian;
    private transient T[][] jacobianWrtParametersMean;
    private transient T[][] jacobianEccentricWrtCartesian;
    private transient T[][] jacobianWrtParametersEccentric;
    private transient T[][] jacobianTrueWrtCartesian;
    private transient T[][] jacobianWrtParametersTrue;

    protected FieldOrbit(Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        FieldOrbit.ensurePseudoInertialFrame(frame);
        this.field = mu.getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
        this.date = date;
        this.mu = mu;
        this.pvCoordinates = null;
        this.frame = frame;
        this.jacobianMeanWrtCartesian = null;
        this.jacobianWrtParametersMean = null;
        this.jacobianEccentricWrtCartesian = null;
        this.jacobianWrtParametersEccentric = null;
        this.jacobianTrueWrtCartesian = null;
        this.jacobianWrtParametersTrue = null;
    }

    protected FieldOrbit(TimeStampedFieldPVCoordinates<T> fieldPVCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        FieldOrbit.ensurePseudoInertialFrame(frame);
        this.field = mu.getField();
        this.zero = (CalculusFieldElement)this.field.getZero();
        this.one = (CalculusFieldElement)this.field.getOne();
        this.date = fieldPVCoordinates.getDate();
        this.mu = mu;
        if (fieldPVCoordinates.getAcceleration().getNormSq().getReal() == 0.0) {
            CalculusFieldElement r2 = fieldPVCoordinates.getPosition().getNormSq();
            CalculusFieldElement r3 = (CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)r2.sqrt()));
            this.pvCoordinates = new TimeStampedFieldPVCoordinates<T>(fieldPVCoordinates.getDate(), fieldPVCoordinates.getPosition(), fieldPVCoordinates.getVelocity(), new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)r3.reciprocal()).multiply((FieldElement)((CalculusFieldElement)mu.negate())), fieldPVCoordinates.getPosition()));
        } else {
            this.pvCoordinates = fieldPVCoordinates;
        }
        this.frame = frame;
    }

    protected static <T extends CalculusFieldElement<T>> boolean hasNonKeplerianAcceleration(FieldPVCoordinates<T> pva, T mu) {
        if (mu.getField().getZero() instanceof Derivative) {
            return Orbit.hasNonKeplerianAcceleration(pva.toPVCoordinates(), mu.getReal());
        }
        FieldVector3D<T> a = pva.getAcceleration();
        if (a == null) {
            return false;
        }
        FieldVector3D<T> p = pva.getPosition();
        CalculusFieldElement r2 = p.getNormSq();
        double tolerance = mu.getReal() * 1.0E-9;
        FieldVector3D aTimesR2 = a.scalarMultiply(r2);
        if (aTimesR2.getNorm().getReal() < tolerance) {
            return false;
        }
        return aTimesR2.add(p.normalize().scalarMultiply(mu)).getNorm().getReal() > tolerance;
    }

    public boolean isElliptical() {
        return this.getA().getReal() > 0.0;
    }

    public abstract OrbitType getType();

    private static void ensurePseudoInertialFrame(Frame frame) throws IllegalArgumentException {
        if (!frame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, frame.getName());
        }
    }

    public Frame getFrame() {
        return this.frame;
    }

    public abstract Orbit toOrbit();

    public abstract T getA();

    public abstract T getADot();

    public abstract T getEquinoctialEx();

    public abstract T getEquinoctialExDot();

    public abstract T getEquinoctialEy();

    public abstract T getEquinoctialEyDot();

    public abstract T getHx();

    public abstract T getHxDot();

    public abstract T getHy();

    public abstract T getHyDot();

    public abstract T getLE();

    public abstract T getLEDot();

    public abstract T getLv();

    public abstract T getLvDot();

    public abstract T getLM();

    public abstract T getLMDot();

    public abstract T getE();

    public abstract T getEDot();

    public abstract T getI();

    public abstract T getIDot();

    public abstract boolean hasDerivatives();

    public T getMu() {
        return this.mu;
    }

    public T getKeplerianPeriod() {
        T a = this.getA();
        return (T)(this.isElliptical() ? (CalculusFieldElement)((CalculusFieldElement)a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a.getPi()).multiply(2.0)))).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a.divide(this.mu)).sqrt())) : (CalculusFieldElement)this.zero.add(Double.POSITIVE_INFINITY));
    }

    public T getKeplerianMeanMotion() {
        CalculusFieldElement absA = (CalculusFieldElement)this.getA().abs();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absA.reciprocal()).multiply(this.mu)).sqrt()).divide((FieldElement)absA));
    }

    public T getMeanAnomalyDotWrtA() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().divide(this.getA())).multiply(-1.5));
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.date;
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
        }
        if (outputFrame == this.frame) {
            return this.pvCoordinates;
        }
        FieldTransform<T> t = this.frame.getTransformTo(outputFrame, this.date);
        return t.transformPVCoordinates(this.pvCoordinates);
    }

    @Override
    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(FieldAbsoluteDate<T> otherDate, Frame otherFrame) {
        return ((FieldOrbit)this.shiftedBy((CalculusFieldElement)otherDate.durationFrom(this.getDate()))).getPVCoordinates(otherFrame);
    }

    @Override
    public FieldVector3D<T> getPosition(FieldAbsoluteDate<T> otherDate, Frame otherFrame) {
        return ((FieldOrbit)this.shiftedBy((CalculusFieldElement)otherDate.durationFrom(this.getDate()))).getPosition(otherFrame);
    }

    public FieldVector3D<T> getPosition(Frame outputFrame) {
        if (this.position == null) {
            this.position = this.initPosition();
        }
        if (outputFrame == this.frame) {
            return this.position;
        }
        FieldStaticTransform<T> t = this.frame.getStaticTransformTo(outputFrame, this.date);
        return t.transformPosition(this.position);
    }

    public FieldVector3D<T> getPosition() {
        if (this.position == null) {
            this.position = this.initPosition();
        }
        return this.position;
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        if (this.pvCoordinates == null) {
            this.pvCoordinates = this.initPVCoordinates();
            this.position = this.pvCoordinates.getPosition();
        }
        return this.pvCoordinates;
    }

    protected T getOne() {
        return this.one;
    }

    protected T getZero() {
        return this.zero;
    }

    protected Field<T> getField() {
        return this.field;
    }

    protected abstract FieldVector3D<T> initPosition();

    protected abstract TimeStampedFieldPVCoordinates<T> initPVCoordinates();

    @Override
    public abstract FieldOrbit<T> shiftedBy(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtCartesian(PositionAngleType type, T[][] jacobian) {
        T[][] cachedJacobian;
        FieldOrbit fieldOrbit = this;
        synchronized (fieldOrbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianMeanWrtCartesian == null) {
                        this.jacobianMeanWrtCartesian = this.computeJacobianMeanWrtCartesian();
                    }
                    cachedJacobian = this.jacobianMeanWrtCartesian;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianEccentricWrtCartesian == null) {
                        this.jacobianEccentricWrtCartesian = this.computeJacobianEccentricWrtCartesian();
                    }
                    cachedJacobian = this.jacobianEccentricWrtCartesian;
                    break;
                }
                case TRUE: {
                    if (this.jacobianTrueWrtCartesian == null) {
                        this.jacobianTrueWrtCartesian = this.computeJacobianTrueWrtCartesian();
                    }
                    cachedJacobian = this.jacobianTrueWrtCartesian;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getJacobianWrtParameters(PositionAngleType type, T[][] jacobian) {
        T[][] cachedJacobian;
        FieldOrbit fieldOrbit = this;
        synchronized (fieldOrbit) {
            switch (type) {
                case MEAN: {
                    if (this.jacobianWrtParametersMean == null) {
                        this.jacobianWrtParametersMean = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersMean;
                    break;
                }
                case ECCENTRIC: {
                    if (this.jacobianWrtParametersEccentric == null) {
                        this.jacobianWrtParametersEccentric = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersEccentric;
                    break;
                }
                case TRUE: {
                    if (this.jacobianWrtParametersTrue == null) {
                        this.jacobianWrtParametersTrue = this.createInverseJacobian(type);
                    }
                    cachedJacobian = this.jacobianWrtParametersTrue;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }
        for (int i = 0; i < cachedJacobian.length; ++i) {
            System.arraycopy(cachedJacobian[i], 0, jacobian[i], 0, cachedJacobian[i].length);
        }
    }

    private T[][] createInverseJacobian(PositionAngleType type) {
        CalculusFieldElement[][] directJacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.getJacobianWrtCartesian(type, directJacobian);
        FieldMatrix matrix = MatrixUtils.createFieldMatrix((FieldElement[][])directJacobian);
        FieldDecompositionSolver solver = new FieldLUDecomposition(matrix).getSolver();
        return (CalculusFieldElement[][])solver.getInverse().getData();
    }

    protected abstract T[][] computeJacobianMeanWrtCartesian();

    protected abstract T[][] computeJacobianEccentricWrtCartesian();

    protected abstract T[][] computeJacobianTrueWrtCartesian();

    public abstract void addKeplerContribution(PositionAngleType var1, T var2, T[] var3);

    protected void fillHalfRow(T a, FieldVector3D<T> v, T[] row, int j) {
        row[j] = (CalculusFieldElement)a.multiply((FieldElement)v.getX());
        row[j + 1] = (CalculusFieldElement)a.multiply((FieldElement)v.getY());
        row[j + 2] = (CalculusFieldElement)a.multiply((FieldElement)v.getZ());
    }

    protected void fillHalfRow(T a1, FieldVector3D<T> v1, T a2, FieldVector3D<T> v2, T[] row, int j) {
        row[j] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getX(), a2, (FieldElement)v2.getX());
        row[j + 1] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getY(), a2, (FieldElement)v2.getY());
        row[j + 2] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getZ(), a2, (FieldElement)v2.getZ());
    }

    protected void fillHalfRow(T a1, FieldVector3D<T> v1, T a2, FieldVector3D<T> v2, T a3, FieldVector3D<T> v3, T[] row, int j) {
        row[j] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getX(), a2, (FieldElement)v2.getX(), a3, (FieldElement)v3.getX());
        row[j + 1] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getY(), a2, (FieldElement)v2.getY(), a3, (FieldElement)v3.getY());
        row[j + 2] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getZ(), a2, (FieldElement)v2.getZ(), a3, (FieldElement)v3.getZ());
    }

    protected void fillHalfRow(T a1, FieldVector3D<T> v1, T a2, FieldVector3D<T> v2, T a3, FieldVector3D<T> v3, T a4, FieldVector3D<T> v4, T[] row, int j) {
        row[j] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getX(), a2, (FieldElement)v2.getX(), a3, (FieldElement)v3.getX(), a4, (FieldElement)v4.getX());
        row[j + 1] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getY(), a2, (FieldElement)v2.getY(), a3, (FieldElement)v3.getY(), a4, (FieldElement)v4.getY());
        row[j + 2] = (CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getZ(), a2, (FieldElement)v2.getZ(), a3, (FieldElement)v3.getZ(), a4, (FieldElement)v4.getZ());
    }

    protected void fillHalfRow(T a1, FieldVector3D<T> v1, T a2, FieldVector3D<T> v2, T a3, FieldVector3D<T> v3, T a4, FieldVector3D<T> v4, T a5, FieldVector3D<T> v5, T[] row, int j) {
        row[j] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getX(), a2, (FieldElement)v2.getX(), a3, (FieldElement)v3.getX(), a4, (FieldElement)v4.getX())).add((FieldElement)((CalculusFieldElement)a5.multiply((FieldElement)v5.getX())));
        row[j + 1] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getY(), a2, (FieldElement)v2.getY(), a3, (FieldElement)v3.getY(), a4, (FieldElement)v4.getY())).add((FieldElement)((CalculusFieldElement)a5.multiply((FieldElement)v5.getY())));
        row[j + 2] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getZ(), a2, (FieldElement)v2.getZ(), a3, (FieldElement)v3.getZ(), a4, (FieldElement)v4.getZ())).add((FieldElement)((CalculusFieldElement)a5.multiply((FieldElement)v5.getZ())));
    }

    protected void fillHalfRow(T a1, FieldVector3D<T> v1, T a2, FieldVector3D<T> v2, T a3, FieldVector3D<T> v3, T a4, FieldVector3D<T> v4, T a5, FieldVector3D<T> v5, T a6, FieldVector3D<T> v6, T[] row, int j) {
        row[j] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getX(), a2, (FieldElement)v2.getX(), a3, (FieldElement)v3.getX(), a4, (FieldElement)v4.getX())).add((FieldElement)((CalculusFieldElement)a1.linearCombination(a5, (FieldElement)v5.getX(), a6, (FieldElement)v6.getX())));
        row[j + 1] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getY(), a2, (FieldElement)v2.getY(), a3, (FieldElement)v3.getY(), a4, (FieldElement)v4.getY())).add((FieldElement)((CalculusFieldElement)a1.linearCombination(a5, (FieldElement)v5.getY(), a6, (FieldElement)v6.getY())));
        row[j + 2] = (CalculusFieldElement)((CalculusFieldElement)a1.linearCombination(a1, (FieldElement)v1.getZ(), a2, (FieldElement)v2.getZ(), a3, (FieldElement)v3.getZ(), a4, (FieldElement)v4.getZ())).add((FieldElement)((CalculusFieldElement)a1.linearCombination(a5, (FieldElement)v5.getZ(), a6, (FieldElement)v6.getZ())));
    }
}

