/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.lang.reflect.Array;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldKeplerianAnomalyUtility;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleBased;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldKeplerianOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T>
implements PositionAngleBased {
    private static final String ECCENTRICITY = "eccentricity";
    private final T a;
    private final T e;
    private final T i;
    private final T pa;
    private final T raan;
    private final T cachedAnomaly;
    private final T aDot;
    private final T eDot;
    private final T iDot;
    private final T paDot;
    private final T raanDot;
    private final T cachedAnomalyDot;
    private final PositionAngleType cachedPositionAngleType;
    private FieldPVCoordinates<T> partialPV;
    private final FieldVector3D<T> PLUS_K;

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, null, null, null, null, null, null, type, cachedPositionAngleType, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, type, type, frame, date, mu);
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, T aDot, T eDot, T iDot, T paDot, T raanDot, T anomalyDot, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        T trueAnomaly;
        this.cachedPositionAngleType = cachedPositionAngleType;
        if (((CalculusFieldElement)a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0)))).getReal() < 0.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_A_E_MISMATCH_WITH_CONIC_TYPE, a.getReal(), e.getReal());
        }
        this.checkParameterRangeInclusive(ECCENTRICITY, e.getReal(), 0.0, Double.POSITIVE_INFINITY);
        this.a = a;
        this.aDot = aDot;
        this.e = e;
        this.eDot = eDot;
        this.i = i;
        this.iDot = iDot;
        this.pa = pa;
        this.paDot = paDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.PLUS_K = FieldVector3D.getPlusK((Field)a.getField());
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1<T> cachedAnomalyUD = this.initializeCachedAnomaly(anomaly, anomalyDot, type);
            this.cachedAnomaly = cachedAnomalyUD.getValue();
            this.cachedAnomalyDot = cachedAnomalyUD.getFirstDerivative();
        } else {
            this.cachedAnomaly = this.initializeCachedAnomaly(anomaly, type);
            this.cachedAnomalyDot = null;
        }
        if (!this.isElliptical() && ((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)(trueAnomaly = this.getTrueAnomaly()).cos()))).add(1.0)).getReal() <= 0.0) {
            double vMax = ((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.reciprocal()).negate()).acos()).getReal();
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_ANOMALY_OUT_OF_HYPERBOLIC_RANGE, trueAnomaly.getReal(), e.getReal(), -vMax, vMax);
        }
        this.partialPV = null;
    }

    public FieldKeplerianOrbit(T a, T e, T i, T pa, T raan, T anomaly, T aDot, T eDot, T iDot, T paDot, T raanDot, T anomalyDot, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, e, i, pa, raan, anomaly, aDot, eDot, iDot, paDot, raanDot, anomalyDot, type, type, frame, date, mu);
    }

    public FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        this(pvCoordinates, frame, mu, FieldKeplerianOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu));
    }

    private FieldKeplerianOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu, boolean reliableAcceleration) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.PLUS_K = FieldVector3D.getPlusK((Field)this.getOne().getField());
        FieldVector3D momentum = pvCoordinates.getMomentum();
        CalculusFieldElement m2 = momentum.getNormSq();
        this.i = FieldVector3D.angle(momentum, this.PLUS_K);
        this.raan = FieldVector3D.crossProduct(this.PLUS_K, momentum).getAlpha();
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        this.a = (CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rV2OnMu.negate()).add(2.0)));
        CalculusFieldElement muA = (CalculusFieldElement)this.a.multiply(mu);
        if (this.isElliptical()) {
            CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide((FieldElement)((CalculusFieldElement)muA.sqrt()));
            CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            this.e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eSE.multiply((FieldElement)eSE)).add((FieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)))).sqrt();
            this.cachedPositionAngleType = PositionAngleType.ECCENTRIC;
            this.cachedAnomaly = (CalculusFieldElement)eSE.atan2((FieldElement)eCE);
        } else {
            CalculusFieldElement eSH = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)muA.negate()).sqrt()));
            CalculusFieldElement eCH = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            this.e = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m2.negate()).divide((FieldElement)muA)).add(1.0)).sqrt();
            this.cachedPositionAngleType = PositionAngleType.TRUE;
            this.cachedAnomaly = FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(this.e, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCH.add((FieldElement)eSH)).divide((FieldElement)((CalculusFieldElement)eCH.subtract((FieldElement)eSH)))).log()).divide(2.0));
        }
        this.checkParameterRangeInclusive(ECCENTRICITY, this.e.getReal(), 0.0, Double.POSITIVE_INFINITY);
        FieldVector3D node = new FieldVector3D(this.raan, this.getZero());
        CalculusFieldElement px = FieldVector3D.dotProduct(pvP, (FieldVector3D)node);
        CalculusFieldElement py = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, (FieldVector3D)FieldVector3D.crossProduct(momentum, (FieldVector3D)node)).divide((FieldElement)((CalculusFieldElement)m2.sqrt()));
        this.pa = (CalculusFieldElement)((CalculusFieldElement)py.atan2((FieldElement)px)).subtract(this.getTrueAnomaly());
        this.partialPV = pvCoordinates;
        if (reliableAcceleration) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngleType.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)mu.negate())), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[0][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[0][5].multiply((FieldElement)aZ)));
            this.eDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[1][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[1][5].multiply((FieldElement)aZ)));
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[2][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[2][5].multiply((FieldElement)aZ)));
            this.paDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[3][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[3][5].multiply((FieldElement)aZ)));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[4][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[4][5].multiply((FieldElement)aZ)));
            CalculusFieldElement MDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add((FieldElement)((CalculusFieldElement)jacobian[5][3].multiply((FieldElement)aX)))).add((FieldElement)((CalculusFieldElement)jacobian[5][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[5][5].multiply((FieldElement)aZ)));
            FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
            FieldUnivariateDerivative1 MUD = new FieldUnivariateDerivative1(this.getMeanAnomaly(), MDot);
            if (this.cachedPositionAngleType == PositionAngleType.ECCENTRIC) {
                FieldUnivariateDerivative1 EUD = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(eUD, MUD) : FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(eUD, MUD);
                this.cachedAnomalyDot = EUD.getFirstDerivative();
            } else {
                FieldUnivariateDerivative1 vUD = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToTrue(eUD, MUD) : FieldKeplerianAnomalyUtility.ellipticMeanToTrue(eUD, MUD);
                this.cachedAnomalyDot = vUD.getFirstDerivative();
            }
        } else {
            this.aDot = null;
            this.eDot = null;
            this.iDot = null;
            this.paDot = null;
            this.raanDot = null;
            this.cachedAnomalyDot = null;
        }
    }

    public FieldKeplerianOrbit(FieldPVCoordinates<T> FieldPVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, FieldPVCoordinates2), frame, mu);
    }

    public FieldKeplerianOrbit(FieldOrbit<T> op) {
        this(op.getPVCoordinates(), op.getFrame(), op.getMu(), op.hasDerivatives());
    }

    public FieldKeplerianOrbit(Field<T> field, KeplerianOrbit op) {
        this((CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getA()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getE()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getI()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getPerigeeArgument()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getRightAscensionOfAscendingNode()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getAnomaly(op.getCachedPositionAngleType())), op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getADot()) : null, op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getEDot()) : null, op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getIDot()) : null, op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getPerigeeArgumentDot()) : null, op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getRightAscensionOfAscendingNodeDot()) : null, op.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getAnomalyDot(op.getCachedPositionAngleType())) : null, op.getCachedPositionAngleType(), op.getFrame(), new FieldAbsoluteDate<T>(field, op.getDate()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getMu()));
    }

    public FieldKeplerianOrbit(Field<T> field, Orbit op) {
        this(field, (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(op));
    }

    @Override
    public OrbitType getType() {
        return OrbitType.KEPLERIAN;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getE() {
        return this.e;
    }

    @Override
    public T getEDot() {
        return this.eDot;
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getPerigeeArgument() {
        return this.pa;
    }

    public T getPerigeeArgumentDot() {
        return this.paDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    public T getTrueAnomaly() {
        switch (this.cachedPositionAngleType) {
            case MEAN: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToTrue(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticMeanToTrue(this.e, this.cachedAnomaly);
            }
            case TRUE: {
                return this.cachedAnomaly;
            }
            case ECCENTRIC: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticEccentricToTrue(this.e, this.cachedAnomaly);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getTrueAnomalyDot() {
        if (this.hasDerivatives()) {
            switch (this.cachedPositionAngleType) {
                case MEAN: {
                    FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 MUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 vUD = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToTrue(eUD, MUD) : FieldKeplerianAnomalyUtility.ellipticMeanToTrue(eUD, MUD);
                    return (T)vUD.getFirstDerivative();
                }
                case TRUE: {
                    return this.cachedAnomalyDot;
                }
                case ECCENTRIC: {
                    FieldUnivariateDerivative1 eUD2 = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 EUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 vUD2 = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(eUD2, EUD) : FieldKeplerianAnomalyUtility.ellipticEccentricToTrue(eUD2, EUD);
                    return (T)vUD2.getFirstDerivative();
                }
            }
            throw new OrekitInternalError(null);
        }
        return null;
    }

    public T getEccentricAnomaly() {
        switch (this.cachedPositionAngleType) {
            case MEAN: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(this.e, this.cachedAnomaly);
            }
            case ECCENTRIC: {
                return this.cachedAnomaly;
            }
            case TRUE: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicTrueToEccentric(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticTrueToEccentric(this.e, this.cachedAnomaly);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getEccentricAnomalyDot() {
        if (this.hasDerivatives()) {
            switch (this.cachedPositionAngleType) {
                case ECCENTRIC: {
                    return this.cachedAnomalyDot;
                }
                case TRUE: {
                    FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 vUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 EUD = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicTrueToEccentric(eUD, vUD) : FieldKeplerianAnomalyUtility.ellipticTrueToEccentric(eUD, vUD);
                    return (T)EUD.getFirstDerivative();
                }
                case MEAN: {
                    FieldUnivariateDerivative1 eUD2 = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 MUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 EUD2 = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(eUD2, MUD) : FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(eUD2, MUD);
                    return (T)EUD2.getFirstDerivative();
                }
            }
            throw new OrekitInternalError(null);
        }
        return null;
    }

    public T getMeanAnomaly() {
        switch (this.cachedPositionAngleType) {
            case ECCENTRIC: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicEccentricToMean(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticEccentricToMean(this.e, this.cachedAnomaly);
            }
            case MEAN: {
                return this.cachedAnomaly;
            }
            case TRUE: {
                return this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicTrueToMean(this.e, this.cachedAnomaly) : FieldKeplerianAnomalyUtility.ellipticTrueToMean(this.e, this.cachedAnomaly);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getMeanAnomalyDot() {
        if (this.hasDerivatives()) {
            switch (this.cachedPositionAngleType) {
                case MEAN: {
                    return this.cachedAnomalyDot;
                }
                case ECCENTRIC: {
                    FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 EUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 MUD = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicEccentricToMean(eUD, EUD) : FieldKeplerianAnomalyUtility.ellipticEccentricToMean(eUD, EUD);
                    return (T)MUD.getFirstDerivative();
                }
                case TRUE: {
                    FieldUnivariateDerivative1 eUD2 = new FieldUnivariateDerivative1(this.e, this.eDot);
                    FieldUnivariateDerivative1 vUD = new FieldUnivariateDerivative1(this.cachedAnomaly, this.cachedAnomalyDot);
                    FieldUnivariateDerivative1 MUD2 = this.a.getReal() < 0.0 ? FieldKeplerianAnomalyUtility.hyperbolicTrueToMean(eUD2, vUD) : FieldKeplerianAnomalyUtility.ellipticTrueToMean(eUD2, vUD);
                    return (T)MUD2.getFirstDerivative();
                }
            }
            throw new OrekitInternalError(null);
        }
        return null;
    }

    public T getAnomaly(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getMeanAnomaly() : (type == PositionAngleType.ECCENTRIC ? this.getEccentricAnomaly() : this.getTrueAnomaly());
    }

    public T getAnomalyDot(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getMeanAnomalyDot() : (type == PositionAngleType.ECCENTRIC ? this.getEccentricAnomalyDot() : this.getTrueAnomalyDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((CalculusFieldElement)this.e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).cos())));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 paUD = new FieldUnivariateDerivative1(this.pa, this.paDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)eUD.multiply((FieldUnivariateDerivative1)paUD.add(raanUD).cos()).getFirstDerivative();
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((CalculusFieldElement)this.e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).sin())));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 paUD = new FieldUnivariateDerivative1(this.pa, this.paDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)eUD.multiply((FieldUnivariateDerivative1)paUD.add(raanUD).sin()).getFirstDerivative();
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.cos()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.i.divide(2.0)).tan())));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        FieldUnivariateDerivative1 iUD = new FieldUnivariateDerivative1(this.i, this.iDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)((FieldUnivariateDerivative1)raanUD.cos()).multiply((FieldUnivariateDerivative1)iUD.multiply(0.5).tan()).getFirstDerivative();
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.sin()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.i.divide(2.0)).tan())));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        FieldUnivariateDerivative1 iUD = new FieldUnivariateDerivative1(this.i, this.iDot);
        FieldUnivariateDerivative1 raanUD = new FieldUnivariateDerivative1(this.raan, this.raanDot);
        return (T)((FieldUnivariateDerivative1)raanUD.sin()).multiply((FieldUnivariateDerivative1)iUD.multiply(0.5).tan()).getFirstDerivative();
    }

    @Override
    public T getLv() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.getTrueAnomaly()));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.getTrueAnomalyDot()) : null);
    }

    @Override
    public T getLE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.getEccentricAnomaly()));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.getEccentricAnomalyDot()) : null);
    }

    @Override
    public T getLM() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.pa.add(this.raan)).add(this.getMeanAnomaly()));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)((CalculusFieldElement)this.paDot.add(this.raanDot)).add(this.getMeanAnomalyDot()) : null);
    }

    private FieldUnivariateDerivative1<T> initializeCachedAnomaly(T anomaly, T anomalyDot, PositionAngleType inputType) {
        if (this.cachedPositionAngleType == inputType) {
            return new FieldUnivariateDerivative1(anomaly, anomalyDot);
        }
        FieldUnivariateDerivative1 eUD = new FieldUnivariateDerivative1(this.e, this.eDot);
        FieldUnivariateDerivative1 anomalyUD = new FieldUnivariateDerivative1(anomaly, anomalyDot);
        if (this.a.getReal() < 0.0) {
            switch (this.cachedPositionAngleType) {
                case MEAN: {
                    if (inputType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.hyperbolicEccentricToMean(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicTrueToMean(eUD, anomalyUD);
                }
                case ECCENTRIC: {
                    if (inputType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicTrueToEccentric(eUD, anomalyUD);
                }
                case TRUE: {
                    if (inputType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.hyperbolicMeanToTrue(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(eUD, anomalyUD);
                }
            }
        } else {
            switch (this.cachedPositionAngleType) {
                case MEAN: {
                    if (inputType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.ellipticEccentricToMean(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticTrueToMean(eUD, anomalyUD);
                }
                case ECCENTRIC: {
                    if (inputType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticTrueToEccentric(eUD, anomalyUD);
                }
                case TRUE: {
                    if (inputType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.ellipticMeanToTrue(eUD, anomalyUD);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticEccentricToTrue(eUD, anomalyUD);
                }
            }
        }
        throw new OrekitInternalError(null);
    }

    private T initializeCachedAnomaly(T anomaly, PositionAngleType inputType) {
        return FieldKeplerianAnomalyUtility.convertAnomaly(inputType, anomaly, this.e, this.cachedPositionAngleType);
    }

    private FieldVector3D<T>[] referenceAxes() {
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        FieldSinCos scPa = FastMath.sinCos(this.pa);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement cosRaan = (CalculusFieldElement)scRaan.cos();
        CalculusFieldElement sinRaan = (CalculusFieldElement)scRaan.sin();
        CalculusFieldElement cosPa = (CalculusFieldElement)scPa.cos();
        CalculusFieldElement sinPa = (CalculusFieldElement)scPa.sin();
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement crcp = (CalculusFieldElement)cosRaan.multiply((FieldElement)cosPa);
        CalculusFieldElement crsp = (CalculusFieldElement)cosRaan.multiply((FieldElement)sinPa);
        CalculusFieldElement srcp = (CalculusFieldElement)sinRaan.multiply((FieldElement)cosPa);
        CalculusFieldElement srsp = (CalculusFieldElement)sinRaan.multiply((FieldElement)sinPa);
        FieldVector3D[] axes = (FieldVector3D[])Array.newInstance(FieldVector3D.class, 2);
        axes[0] = new FieldVector3D((CalculusFieldElement)crcp.subtract((FieldElement)((CalculusFieldElement)cosI.multiply((FieldElement)srsp))), (CalculusFieldElement)srcp.add((FieldElement)((CalculusFieldElement)cosI.multiply((FieldElement)crsp))), (CalculusFieldElement)sinI.multiply((FieldElement)sinPa));
        axes[1] = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)crsp.add((FieldElement)((CalculusFieldElement)cosI.multiply((FieldElement)srcp)))).negate(), (CalculusFieldElement)((CalculusFieldElement)cosI.multiply((FieldElement)crcp)).subtract((FieldElement)srsp), (CalculusFieldElement)sinI.multiply((FieldElement)cosPa));
        return axes;
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        FieldVector3D<T>[] axes = this.referenceAxes();
        if (this.isElliptical()) {
            CalculusFieldElement uME2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).add(1.0)).multiply((FieldElement)((CalculusFieldElement)this.e.add(1.0)));
            CalculusFieldElement s1Me2 = (CalculusFieldElement)uME2.sqrt();
            FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
            CalculusFieldElement cosE = (CalculusFieldElement)scE.cos();
            CalculusFieldElement sinE = (CalculusFieldElement)scE.sin();
            CalculusFieldElement x = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)cosE.subtract(this.e)));
            CalculusFieldElement y = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sinE)).multiply((FieldElement)s1Me2);
            CalculusFieldElement factor = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide(this.a))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).multiply((FieldElement)cosE)).add(1.0)));
            CalculusFieldElement xDot = (CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)factor);
            CalculusFieldElement yDot = (CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)s1Me2)).multiply((FieldElement)factor);
            FieldVector3D position = new FieldVector3D(x, axes[0], y, axes[1]);
            FieldVector3D velocity = new FieldVector3D(xDot, axes[0], yDot, axes[1]);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        } else {
            FieldSinCos scV = FastMath.sinCos(this.getTrueAnomaly());
            CalculusFieldElement sinV = (CalculusFieldElement)scV.sin();
            CalculusFieldElement cosV = (CalculusFieldElement)scV.cos();
            CalculusFieldElement f = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.square()).negate()).add(1.0)));
            CalculusFieldElement posFactor = (CalculusFieldElement)f.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)cosV)).add(1.0)));
            CalculusFieldElement velFactor = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide((FieldElement)f)));
            FieldVector3D position = new FieldVector3D((CalculusFieldElement)posFactor.multiply((FieldElement)cosV), axes[0], (CalculusFieldElement)posFactor.multiply((FieldElement)sinV), axes[1]);
            FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)velFactor.multiply((FieldElement)sinV)).negate(), axes[0], (CalculusFieldElement)velFactor.multiply((FieldElement)((CalculusFieldElement)this.e.add((FieldElement)cosV))), axes[1]);
            this.partialPV = new FieldPVCoordinates(position, velocity);
        }
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngleType.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getMeanAnomalyDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[3][1].multiply(this.eDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][2].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][3].multiply(this.paDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[4][1].multiply(this.eDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][2].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][3].multiply(this.paDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[5][1].multiply(this.eDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][2].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][3].multiply(this.paDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected FieldVector3D<T> initPosition() {
        FieldVector3D<T>[] axes = this.referenceAxes();
        if (this.isElliptical()) {
            CalculusFieldElement uME2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).add(1.0)).multiply((FieldElement)((CalculusFieldElement)this.e.add(1.0)));
            CalculusFieldElement s1Me2 = (CalculusFieldElement)uME2.sqrt();
            FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
            CalculusFieldElement cosE = (CalculusFieldElement)scE.cos();
            CalculusFieldElement sinE = (CalculusFieldElement)scE.sin();
            return new FieldVector3D((CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)cosE.subtract(this.e))), axes[0], (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sinE)).multiply((FieldElement)s1Me2), axes[1]);
        }
        FieldSinCos scV = FastMath.sinCos(this.getTrueAnomaly());
        CalculusFieldElement sinV = (CalculusFieldElement)scV.sin();
        CalculusFieldElement cosV = (CalculusFieldElement)scV.cos();
        CalculusFieldElement f = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.square()).negate()).add(1.0)));
        CalculusFieldElement posFactor = (CalculusFieldElement)f.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)cosV)).add(1.0)));
        return new FieldVector3D((CalculusFieldElement)posFactor.multiply((FieldElement)cosV), axes[0], (CalculusFieldElement)posFactor.multiply((FieldElement)sinV), axes[1]);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)FastMath.sqrt((CalculusFieldElement)r2))).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)this.getZero().newInstance(dt));
    }

    @Override
    public FieldKeplerianOrbit<T> shiftedBy(T dt) {
        FieldKeplerianOrbit<CalculusFieldElement> keplerianShifted = new FieldKeplerianOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.e, (CalculusFieldElement)this.i, (CalculusFieldElement)this.pa, (CalculusFieldElement)this.raan, (CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().multiply(dt)).add(this.getMeanAnomaly()), PositionAngleType.MEAN, this.cachedPositionAngleType, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)this.getDate().shiftedBy((CalculusFieldElement)dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.square()).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), keplerianShifted.partialPV.getPosition(), this.getOne(), nonKeplerianAcceleration);
            return new FieldKeplerianOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        if (this.isElliptical()) {
            return this.computeJacobianMeanWrtCartesianElliptical();
        }
        return this.computeJacobianMeanWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianMeanWrtCartesianElliptical() {
        CalculusFieldElement factorI1;
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        CalculusFieldElement v2 = velocity.getNormSq();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        CalculusFieldElement px = position.getX();
        CalculusFieldElement py = position.getY();
        CalculusFieldElement pz = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement mx = momentum.getX();
        CalculusFieldElement my = momentum.getY();
        CalculusFieldElement mz = momentum.getZ();
        Object mu = this.getMu();
        CalculusFieldElement sqrtMuA = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)));
        CalculusFieldElement sqrtAoMu = FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)this.a.divide(mu)));
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.square();
        CalculusFieldElement twoA = (CalculusFieldElement)this.a.multiply(2);
        CalculusFieldElement rOnA = (CalculusFieldElement)r.divide(this.a);
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.square()).negate()).add(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        CalculusFieldElement sqrtRec = (CalculusFieldElement)epsilon.reciprocal();
        FieldSinCos scI = FastMath.sinCos(this.i);
        FieldSinCos scPA = FastMath.sinCos(this.pa);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement cosPA = (CalculusFieldElement)scPA.cos();
        CalculusFieldElement sinPA = (CalculusFieldElement)scPA.sin();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        CalculusFieldElement cosE = (CalculusFieldElement)((CalculusFieldElement)this.a.subtract((FieldElement)r)).divide((FieldElement)((CalculusFieldElement)this.a.multiply(this.e)));
        CalculusFieldElement sinE = (CalculusFieldElement)pv.divide((FieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)sqrtMuA)));
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((CalculusFieldElement)a2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(2.0)).reciprocal())));
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorARDot, jacobian[0], 3);
        CalculusFieldElement factorER3 = (CalculusFieldElement)pv.divide((FieldElement)twoA);
        FieldVector3D vectorER = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)v2)).divide((FieldElement)((CalculusFieldElement)r.multiply(mu))), position, (CalculusFieldElement)sinE.divide((FieldElement)sqrtMuA), velocity, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)sinE)).divide((FieldElement)sqrtMuA), vectorAR);
        FieldVector3D vectorERDot = new FieldVector3D((CalculusFieldElement)sinE.divide((FieldElement)sqrtMuA), position, (CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(2.0)).reciprocal()))).multiply((FieldElement)r), velocity, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)sinE)).divide((FieldElement)sqrtMuA), vectorARDot);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorER, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorERDot, jacobian[1], 3);
        CalculusFieldElement coefE = (CalculusFieldElement)cosE.divide((FieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)sqrtMuA)));
        FieldVector3D vectorEAnR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)v2)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)r)).multiply(mu))), position, coefE, velocity, (CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)coefE), vectorAR);
        FieldVector3D vectorEAnRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.multiply(-2)).multiply((FieldElement)r)).divide((FieldElement)((CalculusFieldElement)this.e.multiply(mu))), velocity, coefE, position, (CalculusFieldElement)((CalculusFieldElement)factorER3.negate()).multiply((FieldElement)coefE), vectorARDot);
        CalculusFieldElement s1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)vz)).multiply((FieldElement)sqrtAoMu)));
        CalculusFieldElement s2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r3);
        CalculusFieldElement s3 = (CalculusFieldElement)((CalculusFieldElement)sinE.multiply((FieldElement)vz)).divide((FieldElement)((CalculusFieldElement)sqrtMuA.multiply(-2)));
        CalculusFieldElement t1 = (CalculusFieldElement)sqrtRec.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosE.multiply((FieldElement)pz)).divide((FieldElement)r)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.multiply((FieldElement)vz)).multiply((FieldElement)sqrtAoMu)))));
        CalculusFieldElement t2 = (CalculusFieldElement)sqrtRec.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)pz)).divide((FieldElement)r3)));
        CalculusFieldElement t3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply((FieldElement)((CalculusFieldElement)cosE.subtract(this.e)))).multiply((FieldElement)vz)).divide((FieldElement)((CalculusFieldElement)sqrtMuA.multiply(2)));
        CalculusFieldElement t4 = (CalculusFieldElement)sqrtRec.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)sinI)).multiply((FieldElement)cosPA)).multiply((FieldElement)sqrtRec)).subtract((FieldElement)((CalculusFieldElement)vz.multiply((FieldElement)sqrtAoMu)))));
        FieldVector3D s = new FieldVector3D((CalculusFieldElement)cosE.divide((FieldElement)r), this.PLUS_K, s1, vectorEAnR, s2, position, s3, vectorAR);
        FieldVector3D sDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sinE.negate()).multiply((FieldElement)sqrtAoMu), this.PLUS_K, s1, vectorEAnRDot, s3, vectorARDot);
        FieldVector3D t = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply((FieldElement)sinE)).divide((FieldElement)r), this.PLUS_K).add(new FieldVector3D(t1, vectorEAnR, t2, position, t3, vectorAR, t4, vectorER));
        FieldVector3D tDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sqrtRec.multiply((FieldElement)((CalculusFieldElement)cosE.subtract(this.e)))).multiply((FieldElement)sqrtAoMu), this.PLUS_K, t1, vectorEAnRDot, t3, vectorARDot, t4, vectorERDot);
        CalculusFieldElement i1 = factorI1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinI.negate()).multiply((FieldElement)sqrtRec)).divide((FieldElement)sqrtMuA);
        CalculusFieldElement i2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorI1.negate()).multiply((FieldElement)mz)).divide((FieldElement)twoA);
        CalculusFieldElement i3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorI1.multiply((FieldElement)mz)).multiply(this.e)).divide((FieldElement)oMe2);
        CalculusFieldElement i4 = (CalculusFieldElement)cosI.multiply((FieldElement)sinPA);
        CalculusFieldElement i5 = (CalculusFieldElement)cosI.multiply((FieldElement)cosPA);
        this.fillHalfRow(i1, new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.getZero()), i2, vectorAR, i3, vectorER, i4, s, i5, t, jacobian[2], 0);
        this.fillHalfRow(i1, new FieldVector3D((CalculusFieldElement)py.negate(), px, this.getZero()), i2, vectorARDot, i3, vectorERDot, i4, sDot, i5, tDot, jacobian[2], 3);
        this.fillHalfRow((CalculusFieldElement)cosPA.divide((FieldElement)sinI), s, (CalculusFieldElement)((CalculusFieldElement)sinPA.negate()).divide((FieldElement)sinI), t, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)cosPA.divide((FieldElement)sinI), sDot, (CalculusFieldElement)((CalculusFieldElement)sinPA.negate()).divide((FieldElement)sinI), tDot, jacobian[3], 3);
        CalculusFieldElement factorRaanR = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).multiply((FieldElement)oMe2)).multiply((FieldElement)sinI)).multiply((FieldElement)sinI)).reciprocal();
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)factorRaanR.negate()).multiply((FieldElement)my), new FieldVector3D(this.getZero(), vz, (CalculusFieldElement)vy.negate()), (CalculusFieldElement)factorRaanR.multiply((FieldElement)mx), new FieldVector3D((CalculusFieldElement)vz.negate(), this.getZero(), vx), jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)factorRaanR.negate()).multiply((FieldElement)my), new FieldVector3D(this.getZero(), (CalculusFieldElement)pz.negate(), py), (CalculusFieldElement)factorRaanR.multiply((FieldElement)mx), new FieldVector3D(pz, this.getZero(), (CalculusFieldElement)px.negate()), jacobian[4], 3);
        this.fillHalfRow(rOnA, vectorEAnR, (CalculusFieldElement)sinE.negate(), vectorER, jacobian[5], 0);
        this.fillHalfRow(rOnA, vectorEAnRDot, (CalculusFieldElement)sinE.negate(), vectorERDot, jacobian[5], 3);
        return jacobian;
    }

    private T[][] computeJacobianMeanWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getA().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        FieldVector3D<T> momentum = this.partialPV.getMomentum();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        CalculusFieldElement x = position.getX();
        CalculusFieldElement y = position.getY();
        CalculusFieldElement z = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement mx = momentum.getX();
        CalculusFieldElement my = momentum.getY();
        CalculusFieldElement mz = momentum.getZ();
        Object mu = this.getMu();
        CalculusFieldElement absA = (CalculusFieldElement)this.a.negate();
        CalculusFieldElement sqrtMuA = (CalculusFieldElement)((CalculusFieldElement)absA.multiply(mu)).sqrt();
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.square();
        CalculusFieldElement rOa = (CalculusFieldElement)r.divide((FieldElement)absA);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(-2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = velocity.scalarMultiply((CalculusFieldElement)((CalculusFieldElement)a2.multiply(-2)).divide(mu));
        this.fillHalfRow((CalculusFieldElement)this.getOne().negate(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne().negate(), vectorARDot, jacobian[0], 3);
        CalculusFieldElement m = momentum.getNorm();
        CalculusFieldElement oOm = (CalculusFieldElement)m.reciprocal();
        FieldVector3D dcXP = new FieldVector3D(this.getZero(), vz, (CalculusFieldElement)vy.negate());
        FieldVector3D dcYP = new FieldVector3D((CalculusFieldElement)vz.negate(), this.getZero(), vx);
        FieldVector3D dcZP = new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.getZero());
        FieldVector3D dcXV = new FieldVector3D(this.getZero(), (CalculusFieldElement)z.negate(), y);
        FieldVector3D dcYV = new FieldVector3D(z, this.getZero(), (CalculusFieldElement)x.negate());
        FieldVector3D dcZV = new FieldVector3D((CalculusFieldElement)y.negate(), x, this.getZero());
        FieldVector3D dCP = new FieldVector3D((CalculusFieldElement)mx.multiply((FieldElement)oOm), dcXP, (CalculusFieldElement)my.multiply((FieldElement)oOm), dcYP, (CalculusFieldElement)mz.multiply((FieldElement)oOm), dcZP);
        FieldVector3D dCV = new FieldVector3D((CalculusFieldElement)mx.multiply((FieldElement)oOm), dcXV, (CalculusFieldElement)my.multiply((FieldElement)oOm), dcYV, (CalculusFieldElement)mz.multiply((FieldElement)oOm), dcZV);
        CalculusFieldElement mOMu = (CalculusFieldElement)m.divide(mu);
        FieldVector3D dpP = new FieldVector3D((CalculusFieldElement)mOMu.multiply(2), dCP);
        FieldVector3D dpV = new FieldVector3D((CalculusFieldElement)mOMu.multiply(2), dCV);
        CalculusFieldElement p = (CalculusFieldElement)m.multiply((FieldElement)mOMu);
        CalculusFieldElement moO2ae = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absA.multiply(2)).multiply(this.e)).reciprocal();
        CalculusFieldElement m2OaMu = (CalculusFieldElement)((CalculusFieldElement)p.negate()).divide((FieldElement)absA);
        this.fillHalfRow(moO2ae, dpP, (CalculusFieldElement)m2OaMu.multiply((FieldElement)moO2ae), vectorAR, jacobian[1], 0);
        this.fillHalfRow(moO2ae, dpV, (CalculusFieldElement)m2OaMu.multiply((FieldElement)moO2ae), vectorARDot, jacobian[1], 3);
        CalculusFieldElement cI1 = (CalculusFieldElement)((CalculusFieldElement)m.multiply((FieldElement)sinI)).reciprocal();
        CalculusFieldElement cI2 = (CalculusFieldElement)cosI.multiply((FieldElement)cI1);
        this.fillHalfRow(cI2, dCP, (CalculusFieldElement)cI1.negate(), dcZP, jacobian[2], 0);
        this.fillHalfRow(cI2, dCV, (CalculusFieldElement)cI1.negate(), dcZV, jacobian[2], 3);
        CalculusFieldElement cP1 = (CalculusFieldElement)y.multiply((FieldElement)oOm);
        CalculusFieldElement cP2 = (CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)oOm);
        CalculusFieldElement cP3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mx.multiply((FieldElement)cP1)).add((FieldElement)((CalculusFieldElement)my.multiply((FieldElement)cP2)))).negate();
        CalculusFieldElement cP4 = (CalculusFieldElement)cP3.multiply((FieldElement)oOm);
        CalculusFieldElement cP5 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)sinI)).multiply((FieldElement)sinI)).negate()).reciprocal();
        CalculusFieldElement cP6 = (CalculusFieldElement)z.multiply((FieldElement)cP5);
        CalculusFieldElement cP7 = (CalculusFieldElement)cP3.multiply((FieldElement)cP5);
        FieldVector3D dacP = new FieldVector3D(cP1, dcXP, cP2, dcYP, cP4, dCP, oOm, new FieldVector3D((CalculusFieldElement)my.negate(), mx, this.getZero()));
        FieldVector3D dacV = new FieldVector3D(cP1, dcXV, cP2, dcYV, cP4, dCV);
        FieldVector3D dpoP = new FieldVector3D(cP6, dacP, cP7, this.PLUS_K);
        FieldVector3D dpoV = new FieldVector3D(cP6, dacV);
        CalculusFieldElement re2 = (CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)this.e.square()));
        CalculusFieldElement recOre2 = (CalculusFieldElement)((CalculusFieldElement)p.subtract((FieldElement)r)).divide((FieldElement)re2);
        CalculusFieldElement resOre2 = (CalculusFieldElement)((CalculusFieldElement)pv.multiply((FieldElement)mOMu)).divide((FieldElement)re2);
        FieldVector3D dreP = new FieldVector3D(mOMu, velocity, (CalculusFieldElement)pv.divide(mu), dCP);
        FieldVector3D dreV = new FieldVector3D(mOMu, position, (CalculusFieldElement)pv.divide(mu), dCV);
        FieldVector3D davP = new FieldVector3D((CalculusFieldElement)resOre2.negate(), dpP, recOre2, dreP, (CalculusFieldElement)resOre2.divide((FieldElement)r), position);
        FieldVector3D davV = new FieldVector3D((CalculusFieldElement)resOre2.negate(), dpV, recOre2, dreV);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dpoP, (CalculusFieldElement)this.getOne().negate(), davP, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dpoV, (CalculusFieldElement)this.getOne().negate(), davV, jacobian[3], 3);
        CalculusFieldElement cO0 = (CalculusFieldElement)cI1.square();
        CalculusFieldElement cO1 = (CalculusFieldElement)mx.multiply((FieldElement)cO0);
        CalculusFieldElement cO2 = (CalculusFieldElement)((CalculusFieldElement)my.negate()).multiply((FieldElement)cO0);
        this.fillHalfRow(cO1, dcYP, cO2, dcXP, jacobian[4], 0);
        this.fillHalfRow(cO1, dcYV, cO2, dcXV, jacobian[4], 3);
        CalculusFieldElement s2a = (CalculusFieldElement)pv.divide((FieldElement)((CalculusFieldElement)absA.multiply(2)));
        CalculusFieldElement oObux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m.square()).add((FieldElement)((CalculusFieldElement)absA.multiply(mu)))).sqrt()).reciprocal();
        CalculusFieldElement scasbu = (CalculusFieldElement)pv.multiply((FieldElement)oObux);
        FieldVector3D dauP = new FieldVector3D((CalculusFieldElement)sqrtMuA.reciprocal(), velocity, (CalculusFieldElement)((CalculusFieldElement)s2a.negate()).divide((FieldElement)sqrtMuA), vectorAR);
        FieldVector3D dauV = new FieldVector3D((CalculusFieldElement)sqrtMuA.reciprocal(), position, (CalculusFieldElement)((CalculusFieldElement)s2a.negate()).divide((FieldElement)sqrtMuA), vectorARDot);
        FieldVector3D dbuP = new FieldVector3D((CalculusFieldElement)oObux.multiply((FieldElement)((CalculusFieldElement)mu.divide(2.0))), vectorAR, (CalculusFieldElement)m.multiply((FieldElement)oObux), dCP);
        FieldVector3D dbuV = new FieldVector3D((CalculusFieldElement)oObux.multiply((FieldElement)((CalculusFieldElement)mu.divide(2.0))), vectorARDot, (CalculusFieldElement)m.multiply((FieldElement)oObux), dCV);
        FieldVector3D dcuP = new FieldVector3D(oObux, velocity, (CalculusFieldElement)((CalculusFieldElement)scasbu.negate()).multiply((FieldElement)oObux), dbuP);
        FieldVector3D dcuV = new FieldVector3D(oObux, position, (CalculusFieldElement)((CalculusFieldElement)scasbu.negate()).multiply((FieldElement)oObux), dbuV);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dauP, (CalculusFieldElement)((CalculusFieldElement)this.e.negate()).divide((FieldElement)((CalculusFieldElement)rOa.add(1.0))), dcuP, jacobian[5], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dauV, (CalculusFieldElement)((CalculusFieldElement)this.e.negate()).divide((FieldElement)((CalculusFieldElement)rOa.add(1.0))), dcuV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        if (this.isElliptical()) {
            return this.computeJacobianEccentricWrtCartesianElliptical();
        }
        return this.computeJacobianEccentricWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianEccentricWrtCartesianElliptical() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianElliptical();
        FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.negate()).multiply((FieldElement)((CalculusFieldElement)scE.cos()))).add(1.0)).reciprocal();
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)aOr.multiply((FieldElement)((CalculusFieldElement)anomalyRow[j].add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)scE.sin()).multiply((FieldElement)eRow[j])))));
        }
        return jacobian;
    }

    private T[][] computeJacobianEccentricWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesianHyperbolic();
        T H = this.getEccentricAnomaly();
        CalculusFieldElement coshH = (CalculusFieldElement)H.cosh();
        CalculusFieldElement sinhH = (CalculusFieldElement)H.sinh();
        CalculusFieldElement absaOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)coshH)).subtract(1.0)).reciprocal();
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)absaOr.multiply((FieldElement)((CalculusFieldElement)anomalyRow[j].subtract((FieldElement)((CalculusFieldElement)sinhH.multiply((FieldElement)eRow[j])))));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        if (this.isElliptical()) {
            return this.computeJacobianTrueWrtCartesianElliptical();
        }
        return this.computeJacobianTrueWrtCartesianHyperbolic();
    }

    private T[][] computeJacobianTrueWrtCartesianElliptical() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianElliptical();
        CalculusFieldElement e2 = (CalculusFieldElement)this.e.square();
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        FieldSinCos scE = FastMath.sinCos(this.getEccentricAnomaly());
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)((CalculusFieldElement)scE.cos()))).negate()).add(1.0)).reciprocal();
        CalculusFieldElement aFactor = (CalculusFieldElement)epsilon.multiply((FieldElement)aOr);
        CalculusFieldElement eFactor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scE.sin()).multiply((FieldElement)aOr)).divide((FieldElement)epsilon);
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)((CalculusFieldElement)aFactor.multiply((FieldElement)anomalyRow[j])).add((FieldElement)((CalculusFieldElement)eFactor.multiply((FieldElement)eRow[j])));
        }
        return jacobian;
    }

    private T[][] computeJacobianTrueWrtCartesianHyperbolic() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesianHyperbolic();
        CalculusFieldElement e2 = (CalculusFieldElement)this.e.square();
        CalculusFieldElement e2Mo = (CalculusFieldElement)e2.subtract(1.0);
        CalculusFieldElement epsilon = (CalculusFieldElement)e2Mo.sqrt();
        T H = this.getEccentricAnomaly();
        CalculusFieldElement coshH = (CalculusFieldElement)H.cosh();
        CalculusFieldElement sinhH = (CalculusFieldElement)H.sinh();
        CalculusFieldElement aOr = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.e.multiply((FieldElement)coshH)).subtract(1.0)).reciprocal();
        CalculusFieldElement aFactor = (CalculusFieldElement)epsilon.multiply((FieldElement)aOr);
        CalculusFieldElement eFactor = (CalculusFieldElement)((CalculusFieldElement)sinhH.multiply((FieldElement)aOr)).divide((FieldElement)epsilon);
        CalculusFieldElement[] eRow = jacobian[1];
        CalculusFieldElement[] anomalyRow = jacobian[5];
        for (int j = 0; j < anomalyRow.length; ++j) {
            anomalyRow[j] = (CalculusFieldElement)((CalculusFieldElement)aFactor.multiply((FieldElement)anomalyRow[j])).subtract((FieldElement)((CalculusFieldElement)eFactor.multiply((FieldElement)eRow[j])));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngleType type, T gm, T[] pDot) {
        pDot[5] = (CalculusFieldElement)pDot[5].add(FieldKeplerianOrbit.computeKeplerianAnomalyDot(type, this.a, this.e, gm, this.cachedAnomaly, this.cachedPositionAngleType));
    }

    private static <T extends CalculusFieldElement<T>> T computeKeplerianAnomalyDot(PositionAngleType type, T a, T e, T mu, T anomaly, PositionAngleType cachedType) {
        CalculusFieldElement absA = (CalculusFieldElement)a.abs();
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)absA.reciprocal()).multiply(mu)).sqrt()).divide((FieldElement)absA);
        if (type == PositionAngleType.MEAN) {
            return (T)n;
        }
        T trueAnomaly = FieldKeplerianAnomalyUtility.convertAnomaly(cachedType, anomaly, e, PositionAngleType.TRUE);
        if (type == PositionAngleType.ECCENTRIC) {
            CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.square()).negate()).add(1.0)).abs();
            CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)trueAnomaly.cos()))).add(1.0);
            return (T)((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).divide((FieldElement)oMe2));
        }
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.square()).negate()).add(1.0)).abs();
        CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)trueAnomaly.cos()))).add(1.0);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).multiply((FieldElement)ksi)).divide((FieldElement)((CalculusFieldElement)oMe2.multiply((FieldElement)((CalculusFieldElement)oMe2.sqrt())))));
    }

    public String toString() {
        return "Keplerian parameters: " + '{' + "a: " + this.a.getReal() + "; e: " + this.e.getReal() + "; i: " + FastMath.toDegrees((double)this.i.getReal()) + "; pa: " + FastMath.toDegrees((double)this.pa.getReal()) + "; raan: " + FastMath.toDegrees((double)this.raan.getReal()) + "; v: " + FastMath.toDegrees((double)this.getTrueAnomaly().getReal()) + ";}";
    }

    @Override
    public PositionAngleType getCachedPositionAngleType() {
        return this.cachedPositionAngleType;
    }

    @Override
    public boolean hasRates() {
        return this.hasDerivatives();
    }

    @Override
    public FieldKeplerianOrbit<T> removeRates() {
        return new FieldKeplerianOrbit<T>(this.getA(), this.getE(), this.getI(), this.getPerigeeArgument(), this.getRightAscensionOfAscendingNode(), this.cachedAnomaly, this.cachedPositionAngleType, this.getFrame(), this.getDate(), this.getMu());
    }

    private void checkParameterRangeInclusive(String parameterName, double parameter, double lowerBound, double upperBound) {
        if (parameter < lowerBound || parameter > upperBound) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_PARAMETER_RANGE, parameterName, parameter, lowerBound, upperBound);
        }
    }

    @Override
    public KeplerianOrbit toOrbit() {
        double cachedPositionAngle = this.cachedAnomaly.getReal();
        if (this.hasDerivatives()) {
            return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), cachedPositionAngle, this.aDot.getReal(), this.eDot.getReal(), this.iDot.getReal(), this.paDot.getReal(), this.raanDot.getReal(), this.cachedAnomalyDot.getReal(), this.cachedPositionAngleType, this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new KeplerianOrbit(this.a.getReal(), this.e.getReal(), this.i.getReal(), this.pa.getReal(), this.raan.getReal(), cachedPositionAngle, this.cachedPositionAngleType, this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

