/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public class FieldKeplerianAnomalyUtility {
    private static final double A;
    private static final double B;

    private FieldKeplerianAnomalyUtility() {
    }

    public static <T extends CalculusFieldElement<T>> T ellipticMeanToTrue(T e, T M) {
        T E = FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(e, M);
        T v = FieldKeplerianAnomalyUtility.ellipticEccentricToTrue(e, E);
        return v;
    }

    public static <T extends CalculusFieldElement<T>> T ellipticTrueToMean(T e, T v) {
        T E = FieldKeplerianAnomalyUtility.ellipticTrueToEccentric(e, v);
        return FieldKeplerianAnomalyUtility.ellipticEccentricToMean(e, E);
    }

    public static <T extends CalculusFieldElement<T>> T ellipticEccentricToTrue(T e, T E) {
        CalculusFieldElement beta = (CalculusFieldElement)e.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.square()).negate()).add(1.0)).sqrt()).add(1.0)));
        FieldSinCos scE = FastMath.sinCos(E);
        return (T)((CalculusFieldElement)E.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)((CalculusFieldElement)scE.sin()))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)((CalculusFieldElement)scE.cos()))).subtract(1.0)).negate()))).atan()).multiply(2))));
    }

    public static <T extends CalculusFieldElement<T>> T ellipticTrueToEccentric(T e, T v) {
        CalculusFieldElement beta = (CalculusFieldElement)e.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.square()).negate()).add(1.0)).sqrt()).add(1.0)));
        FieldSinCos scv = FastMath.sinCos(v);
        return (T)((CalculusFieldElement)v.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)((CalculusFieldElement)scv.sin()))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)((CalculusFieldElement)scv.cos()))).add(1.0)))).atan()).multiply(2))));
    }

    public static <T extends CalculusFieldElement<T>> T ellipticMeanToEccentric(T e, T M) {
        CalculusFieldElement E;
        CalculusFieldElement reducedM = MathUtils.normalizeAngle(M, (CalculusFieldElement)((CalculusFieldElement)M.getField().getZero()));
        if (((CalculusFieldElement)reducedM.abs()).getReal() < 0.16666666666666666) {
            E = FastMath.abs((double)reducedM.getReal()) < Precision.SAFE_MIN ? reducedM : (CalculusFieldElement)reducedM.add((FieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)reducedM.multiply(6)).cbrt()).subtract((FieldElement)reducedM)))));
        } else {
            CalculusFieldElement w;
            CalculusFieldElement pi = (CalculusFieldElement)e.getPi();
            if (reducedM.getReal() < 0.0) {
                w = (CalculusFieldElement)reducedM.add((FieldElement)pi);
                E = (CalculusFieldElement)reducedM.add((FieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply(A)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)w.negate()).add(B)))).subtract((FieldElement)pi)).subtract((FieldElement)reducedM)))));
            } else {
                w = (CalculusFieldElement)((CalculusFieldElement)reducedM.negate()).add((FieldElement)pi);
                E = (CalculusFieldElement)reducedM.add((FieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply(A)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)w.negate()).add(B)))).negate()).subtract((FieldElement)reducedM)).add((FieldElement)pi)))));
            }
        }
        CalculusFieldElement e1 = (CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0);
        boolean noCancellationRisk = e1.getReal() + E.getReal() * E.getReal() / 6.0 >= 0.1;
        for (int j = 0; j < 2; ++j) {
            CalculusFieldElement fd;
            CalculusFieldElement f;
            FieldSinCos scE = FastMath.sinCos((CalculusFieldElement)E);
            CalculusFieldElement fdd = (CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)scE.sin()));
            CalculusFieldElement fddd = (CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)scE.cos()));
            if (noCancellationRisk) {
                f = (CalculusFieldElement)((CalculusFieldElement)E.subtract((FieldElement)fdd)).subtract((FieldElement)reducedM);
                fd = (CalculusFieldElement)((CalculusFieldElement)fddd.negate()).add(1.0);
            } else {
                f = (CalculusFieldElement)FieldKeplerianAnomalyUtility.eMeSinE(e, E).subtract((FieldElement)reducedM);
                CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)E.multiply(0.5)).sin();
                fd = (CalculusFieldElement)e1.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)s.square()))).multiply(2)));
            }
            CalculusFieldElement dee = (CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)fd)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)fdd)).multiply(0.5)).subtract((FieldElement)((CalculusFieldElement)fd.square()))));
            CalculusFieldElement w = (CalculusFieldElement)fd.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dee.multiply((FieldElement)((CalculusFieldElement)fdd.add((FieldElement)((CalculusFieldElement)dee.multiply((FieldElement)((CalculusFieldElement)fddd.divide(3.0)))))))).multiply(0.5)));
            fd = (CalculusFieldElement)fd.add((FieldElement)((CalculusFieldElement)dee.multiply((FieldElement)((CalculusFieldElement)fdd.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dee.multiply((FieldElement)fddd)).multiply(0.5)))))));
            E = (CalculusFieldElement)E.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f.subtract((FieldElement)((CalculusFieldElement)dee.multiply((FieldElement)((CalculusFieldElement)fd.subtract((FieldElement)w)))))).divide((FieldElement)fd)));
        }
        E = (CalculusFieldElement)((CalculusFieldElement)E.add(M)).subtract((FieldElement)reducedM);
        return (T)E;
    }

    private static <T extends CalculusFieldElement<T>> T eMeSinE(T e, T E) {
        CalculusFieldElement x = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.negate()).add(1.0)).multiply((FieldElement)((CalculusFieldElement)E.sin()));
        CalculusFieldElement mE2 = (CalculusFieldElement)((CalculusFieldElement)E.square()).negate();
        Object term = E;
        double d = 0.0;
        CalculusFieldElement x0 = (CalculusFieldElement)((CalculusFieldElement)E.getField().getZero()).add(Double.NaN);
        while (!Double.valueOf(x.getReal()).equals(x0.getReal())) {
            term = (CalculusFieldElement)term.multiply((FieldElement)((CalculusFieldElement)mE2.divide((d += 2.0) * (d + 1.0))));
            x0 = x;
            x = (CalculusFieldElement)x.subtract(term);
        }
        return (T)x;
    }

    public static <T extends CalculusFieldElement<T>> T ellipticEccentricToMean(T e, T E) {
        return (T)((CalculusFieldElement)E.subtract((FieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)E.sin())))));
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicMeanToTrue(T e, T M) {
        T H = FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, M);
        T v = FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(e, H);
        return v;
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicTrueToMean(T e, T v) {
        T H = FieldKeplerianAnomalyUtility.hyperbolicTrueToEccentric(e, v);
        return FieldKeplerianAnomalyUtility.hyperbolicEccentricToMean(e, H);
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicEccentricToTrue(T e, T H) {
        CalculusFieldElement s = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.add(1.0)).divide((FieldElement)((CalculusFieldElement)e.subtract(1.0)))).sqrt();
        CalculusFieldElement tanH = (CalculusFieldElement)((CalculusFieldElement)H.multiply(0.5)).tanh();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s.multiply((FieldElement)tanH)).atan()).multiply(2));
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicTrueToEccentric(T e, T v) {
        FieldSinCos scv = FastMath.sinCos(v);
        CalculusFieldElement sinhH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e.square()).subtract(1.0)).sqrt()).multiply((FieldElement)((CalculusFieldElement)scv.sin()))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)scv.cos()))).add(1.0)));
        return (T)((CalculusFieldElement)sinhH.asinh());
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicMeanToEccentric(T e, T M) {
        Field field = e.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement one = (CalculusFieldElement)field.getOne();
        CalculusFieldElement two = (CalculusFieldElement)zero.newInstance(2.0);
        CalculusFieldElement three = (CalculusFieldElement)zero.newInstance(3.0);
        CalculusFieldElement half = (CalculusFieldElement)zero.newInstance(0.5);
        CalculusFieldElement onePointFive = (CalculusFieldElement)zero.newInstance(1.5);
        CalculusFieldElement fourThirds = (CalculusFieldElement)((CalculusFieldElement)zero.newInstance(4.0)).divide(3.0);
        CalculusFieldElement L = (CalculusFieldElement)M.divide(e);
        CalculusFieldElement g = (CalculusFieldElement)e.reciprocal();
        CalculusFieldElement g1 = (CalculusFieldElement)one.subtract((FieldElement)g);
        CalculusFieldElement S = L;
        if (L.isZero()) {
            return (T)((CalculusFieldElement)M.getField().getZero());
        }
        CalculusFieldElement cl = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)L.square()).add((FieldElement)one)).sqrt();
        CalculusFieldElement al = (CalculusFieldElement)L.asinh();
        CalculusFieldElement w = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)g.square()).multiply((FieldElement)al)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cl.multiply((FieldElement)cl)).multiply((FieldElement)cl)));
        S = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)g.divide((FieldElement)cl)));
        S = (CalculusFieldElement)L.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)g.multiply((FieldElement)al)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)S.square()).multiply((FieldElement)S)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)w.multiply((FieldElement)L)).multiply((FieldElement)((CalculusFieldElement)onePointFive.subtract((FieldElement)((CalculusFieldElement)fourThirds.multiply((FieldElement)g)))))))).cbrt()))));
        for (int i = 0; i < 2; ++i) {
            CalculusFieldElement fd;
            CalculusFieldElement f;
            CalculusFieldElement s0 = (CalculusFieldElement)S.square();
            CalculusFieldElement s1 = (CalculusFieldElement)s0.add((FieldElement)one);
            CalculusFieldElement s2 = (CalculusFieldElement)s1.sqrt();
            CalculusFieldElement s3 = (CalculusFieldElement)s1.multiply((FieldElement)s2);
            CalculusFieldElement fdd = (CalculusFieldElement)((CalculusFieldElement)g.multiply((FieldElement)S)).divide((FieldElement)s3);
            CalculusFieldElement fddd = (CalculusFieldElement)((CalculusFieldElement)g.multiply((FieldElement)((CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)two.multiply((FieldElement)s0)))))).divide((FieldElement)((CalculusFieldElement)s1.multiply((FieldElement)s3)));
            if (((CalculusFieldElement)((CalculusFieldElement)s0.divide(6.0)).add((FieldElement)g1)).getReal() >= 0.5) {
                f = (CalculusFieldElement)((CalculusFieldElement)S.subtract((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)((CalculusFieldElement)S.asinh()))))).subtract((FieldElement)L);
                fd = (CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)g.divide((FieldElement)s2)));
            } else {
                CalculusFieldElement x0;
                CalculusFieldElement t = (CalculusFieldElement)S.divide((FieldElement)((CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)S.multiply((FieldElement)S)))).sqrt()))));
                CalculusFieldElement tsq = (CalculusFieldElement)t.square();
                CalculusFieldElement x = (CalculusFieldElement)S.multiply((FieldElement)((CalculusFieldElement)g1.add((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)tsq)))));
                CalculusFieldElement term = (CalculusFieldElement)((CalculusFieldElement)two.multiply((FieldElement)g)).multiply((FieldElement)t);
                CalculusFieldElement twoI1 = one;
                int j = 0;
                do {
                    if (++j == 1000000) {
                        throw new MathIllegalStateException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{j});
                    }
                    twoI1 = (CalculusFieldElement)twoI1.add(2.0);
                    term = (CalculusFieldElement)term.multiply((FieldElement)tsq);
                    x0 = x;
                } while ((x = (CalculusFieldElement)x.subtract((FieldElement)((CalculusFieldElement)term.divide((FieldElement)twoI1)))).getReal() != x0.getReal());
                f = (CalculusFieldElement)x.subtract((FieldElement)L);
                fd = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)s0.divide((FieldElement)((CalculusFieldElement)s2.add((FieldElement)one)))).add((FieldElement)g1)).divide((FieldElement)s2);
            }
            CalculusFieldElement ds = (CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)fd)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)half.multiply((FieldElement)f)).multiply((FieldElement)fdd)).subtract((FieldElement)((CalculusFieldElement)fd.multiply((FieldElement)fd)))));
            CalculusFieldElement stemp = (CalculusFieldElement)S.add((FieldElement)ds);
            if (S.getReal() == stemp.getReal()) break;
            f = (CalculusFieldElement)f.add((FieldElement)((CalculusFieldElement)ds.multiply((FieldElement)((CalculusFieldElement)fd.add((FieldElement)((CalculusFieldElement)half.multiply((FieldElement)((CalculusFieldElement)ds.multiply((FieldElement)((CalculusFieldElement)fdd.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ds.divide((FieldElement)three)).multiply((FieldElement)fddd)))))))))))));
            fd = (CalculusFieldElement)fd.add((FieldElement)((CalculusFieldElement)ds.multiply((FieldElement)((CalculusFieldElement)fdd.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)half.multiply((FieldElement)ds)).multiply((FieldElement)fddd)))))));
            S = (CalculusFieldElement)stemp.subtract((FieldElement)((CalculusFieldElement)f.divide((FieldElement)fd)));
        }
        CalculusFieldElement H = (CalculusFieldElement)S.asinh();
        return (T)H;
    }

    public static <T extends CalculusFieldElement<T>> T hyperbolicEccentricToMean(T e, T H) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)e.multiply((FieldElement)((CalculusFieldElement)H.sinh()))).subtract(H));
    }

    public static <T extends CalculusFieldElement<T>> T convertAnomaly(PositionAngleType oldType, T anomaly, T e, PositionAngleType newType) {
        if (oldType == newType) {
            return anomaly;
        }
        if (e.getReal() > 1.0) {
            switch (newType) {
                case MEAN: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.hyperbolicEccentricToMean(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicTrueToMean(e, anomaly);
                }
                case ECCENTRIC: {
                    if (oldType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.hyperbolicMeanToEccentric(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicTrueToEccentric(e, anomaly);
                }
                case TRUE: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.hyperbolicEccentricToTrue(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.hyperbolicMeanToTrue(e, anomaly);
                }
            }
        } else {
            switch (newType) {
                case MEAN: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.ellipticEccentricToMean(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticTrueToMean(e, anomaly);
                }
                case ECCENTRIC: {
                    if (oldType == PositionAngleType.MEAN) {
                        return FieldKeplerianAnomalyUtility.ellipticMeanToEccentric(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticTrueToEccentric(e, anomaly);
                }
                case TRUE: {
                    if (oldType == PositionAngleType.ECCENTRIC) {
                        return FieldKeplerianAnomalyUtility.ellipticEccentricToTrue(e, anomaly);
                    }
                    return FieldKeplerianAnomalyUtility.ellipticMeanToTrue(e, anomaly);
                }
            }
        }
        throw new OrekitInternalError(null);
    }

    static {
        double k1 = 11.42477796076938;
        double k2 = 2.141592653589793;
        double k3 = 17.84955592153876;
        A = 1.2043347651023166;
        B = 4.64788969626918;
    }
}

