/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldEquinoctialLongitudeArgumentUtility;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleBased;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldEquinoctialOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T>
implements PositionAngleBased {
    private final T a;
    private final T ex;
    private final T ey;
    private final T hx;
    private final T hy;
    private final T cachedL;
    private final PositionAngleType cachedPositionAngleType;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T hxDot;
    private final T hyDot;
    private final T cachedLDot;
    private FieldPVCoordinates<T> partialPV;

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, null, null, null, null, null, null, type, cachedPositionAngleType, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, null, null, null, null, null, null, type, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, T aDot, T exDot, T eyDot, T hxDot, T hyDot, T lDot, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.cachedPositionAngleType = cachedPositionAngleType;
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.hx = hx;
        this.hxDot = hxDot;
        this.hy = hy;
        this.hyDot = hyDot;
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1<T> lUD = this.initializeCachedL(l, lDot, type);
            this.cachedL = lUD.getValue();
            this.cachedLDot = lUD.getFirstDerivative();
        } else {
            this.cachedL = this.initializeCachedL(l, type);
            this.cachedLDot = null;
        }
        this.partialPV = null;
    }

    public FieldEquinoctialOrbit(T a, T ex, T ey, T hx, T hy, T l, T aDot, T exDot, T eyDot, T hxDot, T hyDot, T lDot, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, hx, hy, l, aDot, exDot, eyDot, hxDot, hyDot, lDot, type, type, frame, date, mu);
    }

    public FieldEquinoctialOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        this.a = (CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rV2OnMu.negate()).add(2.0)));
        if (!this.isElliptical()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        FieldVector3D w = pvCoordinates.getMomentum().normalize();
        CalculusFieldElement d = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)this.getOne().add((FieldElement)w.getZ())));
        this.hx = (CalculusFieldElement)((CalculusFieldElement)d.negate()).multiply((FieldElement)w.getY());
        this.hy = (CalculusFieldElement)d.multiply((FieldElement)w.getX());
        this.cachedPositionAngleType = PositionAngleType.TRUE;
        CalculusFieldElement cLv = (CalculusFieldElement)((CalculusFieldElement)pvP.getX().subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)pvP.getZ())).multiply((FieldElement)w.getX())))).divide((FieldElement)r);
        CalculusFieldElement sLv = (CalculusFieldElement)((CalculusFieldElement)pvP.getY().subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)pvP.getZ())).multiply((FieldElement)w.getY())))).divide((FieldElement)r);
        this.cachedL = (CalculusFieldElement)sLv.atan2((FieldElement)cLv);
        CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).sqrt()));
        CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)eCE.square()).add((FieldElement)((CalculusFieldElement)eSE.square()));
        CalculusFieldElement f = (CalculusFieldElement)eCE.subtract((FieldElement)e2);
        CalculusFieldElement g = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()).multiply((FieldElement)eSE);
        this.ex = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)cLv)).add((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)sLv)))))).divide((FieldElement)r);
        this.ey = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)sLv)).subtract((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)cLv)))))).divide((FieldElement)r);
        this.partialPV = pvCoordinates;
        if (FieldEquinoctialOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngleType.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)mu.negate())), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[0][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[0][5].multiply((FieldElement)aZ)));
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[1][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[1][5].multiply((FieldElement)aZ)));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[2][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[2][5].multiply((FieldElement)aZ)));
            this.hxDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[3][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[3][5].multiply((FieldElement)aZ)));
            this.hyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[4][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[4][5].multiply((FieldElement)aZ)));
            CalculusFieldElement lMDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add((FieldElement)((CalculusFieldElement)jacobian[5][3].multiply((FieldElement)aX)))).add((FieldElement)((CalculusFieldElement)jacobian[5][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[5][5].multiply((FieldElement)aZ)));
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
            FieldUnivariateDerivative1 lMUD = new FieldUnivariateDerivative1(this.getLM(), lMDot);
            FieldUnivariateDerivative1 lvUD = FieldEquinoctialLongitudeArgumentUtility.meanToTrue(exUD, eyUD, lMUD);
            this.cachedLDot = lvUD.getFirstDerivative();
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.hxDot = null;
            this.hyDot = null;
            this.cachedLDot = null;
        }
    }

    public FieldEquinoctialOrbit(FieldPVCoordinates<T> pvCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvCoordinates), frame, mu);
    }

    public FieldEquinoctialOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.ex = op.getEquinoctialEx();
        this.ey = op.getEquinoctialEy();
        this.hx = op.getHx();
        this.hy = op.getHy();
        this.cachedPositionAngleType = PositionAngleType.TRUE;
        this.cachedL = op.getLv();
        this.aDot = op.getADot();
        this.exDot = op.getEquinoctialExDot();
        this.eyDot = op.getEquinoctialEyDot();
        this.hxDot = op.getHxDot();
        this.hyDot = op.getHyDot();
        this.cachedLDot = op.getLvDot();
    }

    public FieldEquinoctialOrbit(Field<T> field, EquinoctialOrbit op) {
        super(op.getFrame(), new FieldAbsoluteDate<T>(field, op.getDate()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getMu()));
        this.a = (CalculusFieldElement)this.getZero().newInstance(op.getA());
        this.ex = (CalculusFieldElement)this.getZero().newInstance(op.getEquinoctialEx());
        this.ey = (CalculusFieldElement)this.getZero().newInstance(op.getEquinoctialEy());
        this.hx = (CalculusFieldElement)this.getZero().newInstance(op.getHx());
        this.hy = (CalculusFieldElement)this.getZero().newInstance(op.getHy());
        this.cachedPositionAngleType = op.getCachedPositionAngleType();
        this.cachedL = (CalculusFieldElement)this.getZero().newInstance(op.getL(this.cachedPositionAngleType));
        if (op.hasDerivatives()) {
            this.aDot = (CalculusFieldElement)this.getZero().newInstance(op.getADot());
            this.exDot = (CalculusFieldElement)this.getZero().newInstance(op.getEquinoctialExDot());
            this.eyDot = (CalculusFieldElement)this.getZero().newInstance(op.getEquinoctialEyDot());
            this.hxDot = (CalculusFieldElement)this.getZero().newInstance(op.getHxDot());
            this.hyDot = (CalculusFieldElement)this.getZero().newInstance(op.getHyDot());
            this.cachedLDot = (CalculusFieldElement)this.getZero().newInstance(op.getLDot(this.cachedPositionAngleType));
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.hxDot = null;
            this.hyDot = null;
            this.cachedLDot = null;
        }
    }

    public FieldEquinoctialOrbit(Field<T> field, Orbit op) {
        this(field, (EquinoctialOrbit)OrbitType.EQUINOCTIAL.convertType(op));
    }

    @Override
    public OrbitType getType() {
        return OrbitType.EQUINOCTIAL;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return this.ex;
    }

    @Override
    public T getEquinoctialExDot() {
        return this.exDot;
    }

    @Override
    public T getEquinoctialEy() {
        return this.ey;
    }

    @Override
    public T getEquinoctialEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        return this.hx;
    }

    @Override
    public T getHxDot() {
        return this.hxDot;
    }

    @Override
    public T getHy() {
        return this.hy;
    }

    @Override
    public T getHyDot() {
        return this.hyDot;
    }

    @Override
    public T getLv() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return this.cachedL;
            }
            case ECCENTRIC: {
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(this.ex, this.ey, this.cachedL);
            }
            case MEAN: {
                return FieldEquinoctialLongitudeArgumentUtility.meanToTrue(this.ex, this.ey, this.cachedL);
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public T getLvDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case ECCENTRIC: {
                FieldUnivariateDerivative1 lEUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lvUD = FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(exUD, eyUD, lEUD);
                return (T)lvUD.getFirstDerivative();
            }
            case TRUE: {
                return this.cachedLDot;
            }
            case MEAN: {
                FieldUnivariateDerivative1 lMUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lvUD2 = FieldEquinoctialLongitudeArgumentUtility.meanToTrue(exUD2, eyUD2, lMUD);
                return (T)lvUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public T getLE() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(this.ex, this.ey, this.cachedL);
            }
            case ECCENTRIC: {
                return this.cachedL;
            }
            case MEAN: {
                return FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(this.ex, this.ey, this.cachedL);
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public T getLEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                FieldUnivariateDerivative1 lvUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lEUD = FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(exUD, eyUD, lvUD);
                return (T)lEUD.getFirstDerivative();
            }
            case ECCENTRIC: {
                return this.cachedLDot;
            }
            case MEAN: {
                FieldUnivariateDerivative1 lMUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lEUD2 = FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(exUD2, eyUD2, lMUD);
                return (T)lEUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public T getLM() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return FieldEquinoctialLongitudeArgumentUtility.trueToMean(this.ex, this.ey, this.cachedL);
            }
            case MEAN: {
                return this.cachedL;
            }
            case ECCENTRIC: {
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(this.ex, this.ey, this.cachedL);
            }
        }
        throw new OrekitInternalError(null);
    }

    @Override
    public T getLMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                FieldUnivariateDerivative1 lvUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lMUD = FieldEquinoctialLongitudeArgumentUtility.trueToMean(exUD, eyUD, lvUD);
                return (T)lMUD.getFirstDerivative();
            }
            case MEAN: {
                return this.cachedLDot;
            }
            case ECCENTRIC: {
                FieldUnivariateDerivative1 lEUD = new FieldUnivariateDerivative1(this.cachedL, this.cachedLDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 lMUD2 = FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(exUD2, eyUD2, lEUD);
                return (T)lMUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getL(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getLM() : (type == PositionAngleType.ECCENTRIC ? this.getLE() : this.getLv());
    }

    public T getLDot(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getLMDot() : (type == PositionAngleType.ECCENTRIC ? this.getLEDot() : this.getLvDot());
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T lE, T ex, T ey) {
        return FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(ex, ey, lE);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T lv, T ex, T ey) {
        return FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(ex, ey, lv);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T lM, T ex, T ey) {
        return FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(ex, ey, lM);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T lE, T ex, T ey) {
        return FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(ex, ey, lE);
    }

    @Override
    public T getE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.square()).add((FieldElement)((CalculusFieldElement)this.ey.square()))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.exDot)).add((FieldElement)((CalculusFieldElement)this.ey.multiply(this.eyDot)))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.square()).add((FieldElement)((CalculusFieldElement)this.ey.square()))).sqrt())));
    }

    @Override
    public T getI() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.square()).add((FieldElement)((CalculusFieldElement)this.hy.square()))).sqrt()).atan()).multiply(2));
    }

    @Override
    public T getIDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        CalculusFieldElement h2 = (CalculusFieldElement)((CalculusFieldElement)this.hx.square()).add((FieldElement)((CalculusFieldElement)this.hy.square()));
        CalculusFieldElement h = (CalculusFieldElement)h2.sqrt();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hxDot)).add((FieldElement)((CalculusFieldElement)this.hy.multiply(this.hyDot)))).multiply(2)).divide((FieldElement)((CalculusFieldElement)h.multiply((FieldElement)((CalculusFieldElement)h2.add(1.0))))));
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)this.hx.square();
        CalculusFieldElement hy2 = (CalculusFieldElement)this.hy.square();
        CalculusFieldElement factH = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)));
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hy)).multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)this.hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement ex2 = (CalculusFieldElement)this.ex.square();
        CalculusFieldElement exey = (CalculusFieldElement)this.ex.multiply(this.ey);
        CalculusFieldElement ey2 = (CalculusFieldElement)this.ey.square();
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)e2)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)this.getOne().divide((FieldElement)eta);
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement exCeyS = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sLe)));
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ey2)))).multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe)))).subtract(this.ex)));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ex2)))).multiply((FieldElement)sLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe)))).subtract(this.ey)));
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getMu().divide(this.a)).sqrt()).divide((FieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)exCeyS)));
        CalculusFieldElement xdot = (CalculusFieldElement)factor.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sLe.negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply(this.ey)).multiply((FieldElement)exCeyS)))));
        CalculusFieldElement ydot = (CalculusFieldElement)factor.multiply((FieldElement)((CalculusFieldElement)cLe.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply(this.ex)).multiply((FieldElement)exCeyS)))));
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vz))));
        FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vz))));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldUnivariateDerivative1<T> initializeCachedL(T l, T lDot, PositionAngleType inputType) {
        if (this.cachedPositionAngleType == inputType) {
            return new FieldUnivariateDerivative1(l, lDot);
        }
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 lUD = new FieldUnivariateDerivative1(l, lDot);
        switch (this.cachedPositionAngleType) {
            case ECCENTRIC: {
                if (inputType == PositionAngleType.MEAN) {
                    return FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(exUD, eyUD, lUD);
                }
                return FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(exUD, eyUD, lUD);
            }
            case TRUE: {
                if (inputType == PositionAngleType.MEAN) {
                    return FieldEquinoctialLongitudeArgumentUtility.meanToTrue(exUD, eyUD, lUD);
                }
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(exUD, eyUD, lUD);
            }
            case MEAN: {
                if (inputType == PositionAngleType.TRUE) {
                    return FieldEquinoctialLongitudeArgumentUtility.trueToMean(exUD, eyUD, lUD);
                }
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(exUD, eyUD, lUD);
            }
        }
        throw new OrekitInternalError(null);
    }

    private T initializeCachedL(T l, PositionAngleType positionAngleType) {
        return FieldEquinoctialLongitudeArgumentUtility.convertL(positionAngleType, l, this.ex, this.ey, this.cachedPositionAngleType);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngleType.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getLMDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[3][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][3].multiply(this.hxDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][4].multiply(this.hyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[4][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][3].multiply(this.hxDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][4].multiply(this.hyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[5][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][3].multiply(this.hxDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][4].multiply(this.hyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected FieldVector3D<T> initPosition() {
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)this.hx.square();
        CalculusFieldElement hy2 = (CalculusFieldElement)this.hy.square();
        CalculusFieldElement factH = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)));
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply(this.hy)).multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)this.hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement ex2 = (CalculusFieldElement)this.ex.square();
        CalculusFieldElement exey = (CalculusFieldElement)this.ex.multiply(this.ey);
        CalculusFieldElement ey2 = (CalculusFieldElement)this.ey.square();
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)e2)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)this.getOne().divide((FieldElement)eta);
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ey2)))).multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe)))).subtract(this.ex)));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)beta.multiply((FieldElement)ex2)))).multiply((FieldElement)sLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe)))).subtract(this.ey)));
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vz))));
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)r2.sqrt()))).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)this.getZero().newInstance(dt));
    }

    @Override
    public FieldEquinoctialOrbit<T> shiftedBy(T dt) {
        FieldEquinoctialOrbit<CalculusFieldElement> keplerianShifted = new FieldEquinoctialOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.ex, (CalculusFieldElement)this.ey, (CalculusFieldElement)this.hx, (CalculusFieldElement)this.hy, (CalculusFieldElement)this.getLM().add((FieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().multiply(dt))), PositionAngleType.MEAN, this.cachedPositionAngleType, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)this.getDate().shiftedBy((CalculusFieldElement)dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.square()).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), keplerianShifted.partialPV.getPosition(), this.getOne(), nonKeplerianAcceleration);
            return new FieldEquinoctialOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement r3 = (CalculusFieldElement)r.multiply((FieldElement)r2);
        Object mu = this.getMu();
        CalculusFieldElement sqrtMuA = (CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).sqrt();
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.square();
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.square()).add((FieldElement)((CalculusFieldElement)this.ey.square()));
        CalculusFieldElement oMe2 = (CalculusFieldElement)this.getOne().subtract((FieldElement)e2);
        CalculusFieldElement epsilon = (CalculusFieldElement)oMe2.sqrt();
        CalculusFieldElement beta = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)epsilon.add(1.0)));
        CalculusFieldElement ratio = (CalculusFieldElement)epsilon.multiply((FieldElement)beta);
        CalculusFieldElement hx2 = (CalculusFieldElement)this.hx.square();
        CalculusFieldElement hy2 = (CalculusFieldElement)this.hy.square();
        CalculusFieldElement hxhy = (CalculusFieldElement)this.hx.multiply(this.hy);
        FieldVector3D f = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)hx2.subtract((FieldElement)hy2)).add(1.0), (CalculusFieldElement)hxhy.multiply(2), (CalculusFieldElement)this.hy.multiply(-2)).normalize();
        FieldVector3D g = new FieldVector3D((CalculusFieldElement)hxhy.multiply(2), (CalculusFieldElement)((CalculusFieldElement)hy2.add(1.0)).subtract((FieldElement)hx2), (CalculusFieldElement)this.hx.multiply(2)).normalize();
        FieldVector3D w = FieldVector3D.crossProduct(position, velocity).normalize();
        CalculusFieldElement x = FieldVector3D.dotProduct(position, (FieldVector3D)f);
        CalculusFieldElement y = FieldVector3D.dotProduct(position, (FieldVector3D)g);
        CalculusFieldElement xDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)f);
        CalculusFieldElement yDot = FieldVector3D.dotProduct(velocity, (FieldVector3D)g);
        CalculusFieldElement c1 = (CalculusFieldElement)this.a.divide((FieldElement)((CalculusFieldElement)sqrtMuA.multiply((FieldElement)epsilon)));
        CalculusFieldElement c1N = (CalculusFieldElement)c1.negate();
        CalculusFieldElement c2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply((FieldElement)sqrtMuA)).multiply((FieldElement)beta)).divide((FieldElement)r3);
        CalculusFieldElement c3 = (CalculusFieldElement)sqrtMuA.divide((FieldElement)((CalculusFieldElement)r3.multiply((FieldElement)epsilon)));
        FieldVector3D drDotSdEx = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1.multiply((FieldElement)xDot)).multiply((FieldElement)yDot)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c2.multiply(this.ey)).multiply((FieldElement)x)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)y))), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1N.multiply((FieldElement)xDot)).multiply((FieldElement)xDot)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c2.multiply(this.ey)).multiply((FieldElement)y)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)x))), g);
        FieldVector3D drDotSdEy = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1.multiply((FieldElement)yDot)).multiply((FieldElement)yDot)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c2.multiply(this.ex)).multiply((FieldElement)x)))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c3.multiply((FieldElement)y)).multiply((FieldElement)y))), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c1N.multiply((FieldElement)xDot)).multiply((FieldElement)yDot)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c2.multiply(this.ex)).multiply((FieldElement)y)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)c3.multiply((FieldElement)x)).multiply((FieldElement)y))), g);
        FieldVector3D vectorAR = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide((FieldElement)r3), position);
        FieldVector3D vectorARDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)a2.multiply(2)).divide(mu), velocity);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorAR, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorARDot, jacobian[0], 3);
        CalculusFieldElement d1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.negate()).multiply((FieldElement)ratio)).divide((FieldElement)r3);
        CalculusFieldElement d2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hy.multiply((FieldElement)xDot)).subtract((FieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)yDot)))).divide((FieldElement)((CalculusFieldElement)sqrtMuA.multiply((FieldElement)epsilon)));
        CalculusFieldElement d3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.hx.multiply((FieldElement)y)).subtract((FieldElement)((CalculusFieldElement)this.hy.multiply((FieldElement)x)))).divide((FieldElement)sqrtMuA);
        FieldVector3D vectorExRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.multiply(2)).multiply((FieldElement)yDot)).subtract((FieldElement)((CalculusFieldElement)xDot.multiply((FieldElement)y)))).divide(mu), g, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y.negate()).multiply((FieldElement)yDot)).divide(mu), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)d3)).divide((FieldElement)epsilon), w);
        this.fillHalfRow((CalculusFieldElement)this.ex.multiply((FieldElement)d1), position, (CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)d2), w, (CalculusFieldElement)epsilon.divide((FieldElement)sqrtMuA), drDotSdEy, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorExRDot, jacobian[1], 3);
        FieldVector3D vectorEyRDot = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xDot.multiply(2)).multiply((FieldElement)y)).subtract((FieldElement)((CalculusFieldElement)x.multiply((FieldElement)yDot)))).divide(mu), f, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)xDot)).divide(mu), g, (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)d3)).divide((FieldElement)epsilon), w);
        this.fillHalfRow((CalculusFieldElement)this.ey.multiply((FieldElement)d1), position, (CalculusFieldElement)this.ex.multiply((FieldElement)d2), w, (CalculusFieldElement)((CalculusFieldElement)epsilon.negate()).divide((FieldElement)sqrtMuA), drDotSdEx, jacobian[2], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), vectorEyRDot, jacobian[2], 3);
        CalculusFieldElement h = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sqrtMuA.multiply(2)).multiply((FieldElement)epsilon)));
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)h.negate()).multiply((FieldElement)xDot), w, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)h.multiply((FieldElement)x), w, jacobian[3], 3);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)h.negate()).multiply((FieldElement)yDot), w, jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)h.multiply((FieldElement)y), w, jacobian[4], 3);
        CalculusFieldElement l = (CalculusFieldElement)((CalculusFieldElement)ratio.negate()).divide((FieldElement)sqrtMuA);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)this.getOne().negate()).divide((FieldElement)sqrtMuA), velocity, d2, w, (CalculusFieldElement)l.multiply(this.ex), drDotSdEx, (CalculusFieldElement)l.multiply(this.ey), drDotSdEy, jacobian[5], 0);
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)this.getZero().newInstance(-2.0)).divide((FieldElement)sqrtMuA), position, (CalculusFieldElement)this.ex.multiply((FieldElement)beta), vectorEyRDot, (CalculusFieldElement)((CalculusFieldElement)this.ey.negate()).multiply((FieldElement)beta), vectorExRDot, d3, w, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        FieldSinCos scLe = FastMath.sinCos(this.getLE());
        CalculusFieldElement cosLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sinLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement aOr = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosLe)))).subtract((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sinLe)))));
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)aOr.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rowL[j].add((FieldElement)((CalculusFieldElement)sinLe.multiply((FieldElement)rowEx[j])))).subtract((FieldElement)((CalculusFieldElement)cosLe.multiply((FieldElement)rowEy[j])))));
        }
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        FieldSinCos scLe = FastMath.sinCos(this.getLE());
        CalculusFieldElement cosLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sinLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement eSinE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sinLe)).subtract((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)cosLe)));
        CalculusFieldElement ecosE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosLe)).add((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sinLe)));
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.square()).add((FieldElement)((CalculusFieldElement)this.ey.square()));
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)e2)).sqrt();
        CalculusFieldElement onePeps = (CalculusFieldElement)epsilon.add(1.0);
        CalculusFieldElement d = (CalculusFieldElement)onePeps.subtract((FieldElement)ecosE);
        CalculusFieldElement cT = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).add((FieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)))).divide(2.0);
        CalculusFieldElement cE = (CalculusFieldElement)((CalculusFieldElement)ecosE.multiply((FieldElement)onePeps)).subtract((FieldElement)e2);
        CalculusFieldElement cX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).subtract(this.ey)).add((FieldElement)((CalculusFieldElement)sinLe.multiply((FieldElement)onePeps)));
        CalculusFieldElement cY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).add(this.ex)).subtract((FieldElement)((CalculusFieldElement)cosLe.multiply((FieldElement)onePeps)));
        CalculusFieldElement factorLe = (CalculusFieldElement)((CalculusFieldElement)cT.add((FieldElement)cE)).divide((FieldElement)cT);
        CalculusFieldElement factorEx = (CalculusFieldElement)cX.divide((FieldElement)cT);
        CalculusFieldElement factorEy = (CalculusFieldElement)cY.divide((FieldElement)cT);
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorLe.multiply((FieldElement)rowL[j])).add((FieldElement)((CalculusFieldElement)factorEx.multiply((FieldElement)rowEx[j])))).add((FieldElement)((CalculusFieldElement)factorEy.multiply((FieldElement)rowEy[j])));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngleType type, T gm, T[] pDot) {
        pDot[5] = (CalculusFieldElement)pDot[5].add(FieldEquinoctialOrbit.computeKeplerianLDot(type, this.a, this.ex, this.ey, gm, this.cachedL, this.cachedPositionAngleType));
    }

    private static <T extends CalculusFieldElement<T>> T computeKeplerianLDot(PositionAngleType type, T a, T ex, T ey, T mu, T l, PositionAngleType cachedType) {
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(a)).sqrt()).divide(a);
        if (type == PositionAngleType.MEAN) {
            return (T)n;
        }
        if (type == PositionAngleType.ECCENTRIC) {
            FieldSinCos sc = FastMath.sinCos(FieldEquinoctialLongitudeArgumentUtility.convertL(cachedType, l, ex, ey, type));
            CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)sc.sin()))))).negate()).add(1.0)).reciprocal();
            return (T)((CalculusFieldElement)n.multiply((FieldElement)ksi));
        }
        FieldSinCos sc = FastMath.sinCos(FieldEquinoctialLongitudeArgumentUtility.convertL(cachedType, l, ex, ey, type));
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.getField().getOne()).subtract((FieldElement)((CalculusFieldElement)ex.square()))).subtract((FieldElement)((CalculusFieldElement)ey.square()));
        CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add(1.0)).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)sc.sin()))));
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)ksi)).multiply((FieldElement)ksi)).divide((FieldElement)((CalculusFieldElement)oMe2.multiply((FieldElement)((CalculusFieldElement)oMe2.sqrt())))));
    }

    public String toString() {
        return "equinoctial parameters: " + '{' + "a: " + this.a.getReal() + "; ex: " + this.ex.getReal() + "; ey: " + this.ey.getReal() + "; hx: " + this.hx.getReal() + "; hy: " + this.hy.getReal() + "; lv: " + FastMath.toDegrees((double)this.getLv().getReal()) + ";}";
    }

    @Override
    public PositionAngleType getCachedPositionAngleType() {
        return this.cachedPositionAngleType;
    }

    @Override
    public boolean hasRates() {
        return this.hasDerivatives();
    }

    @Override
    public FieldEquinoctialOrbit<T> removeRates() {
        return new FieldEquinoctialOrbit<T>(this.getA(), this.getEquinoctialEx(), this.getEquinoctialEy(), this.getHx(), this.getHy(), this.cachedL, this.cachedPositionAngleType, this.getFrame(), this.getDate(), this.getMu());
    }

    @Override
    public EquinoctialOrbit toOrbit() {
        double cachedPositionAngle = this.cachedL.getReal();
        if (this.hasDerivatives()) {
            return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), cachedPositionAngle, this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.hxDot.getReal(), this.hyDot.getReal(), this.cachedLDot.getReal(), this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new EquinoctialOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.hx.getReal(), this.hy.getReal(), cachedPositionAngle, this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

