/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public class FieldEquinoctialLongitudeArgumentUtility {
    private static final double TOLERANCE_CONVERGENCE = 1.0E-11;
    private static final int MAXIMUM_ITERATION = 50;

    private FieldEquinoctialLongitudeArgumentUtility() {
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T ex, T ey, T lE) {
        T epsilon = FieldEquinoctialLongitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        FieldSinCos scLE = FastMath.sinCos(lE);
        CalculusFieldElement cosLE = (CalculusFieldElement)scLE.cos();
        CalculusFieldElement sinLE = (CalculusFieldElement)scLE.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)sinLE)).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)cosLE)));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).subtract((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)cosLE)))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)sinLE)));
        return (T)((CalculusFieldElement)lE.add((FieldElement)FieldEquinoctialLongitudeArgumentUtility.eccentricAndTrueAtan(num, den)));
    }

    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T ex, T ey, T lV) {
        T epsilon = FieldEquinoctialLongitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        FieldSinCos scLv = FastMath.sinCos(lV);
        CalculusFieldElement cosLv = (CalculusFieldElement)scLv.cos();
        CalculusFieldElement sinLv = (CalculusFieldElement)scLv.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ey.multiply((FieldElement)cosLv)).subtract((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)sinLv)));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).add((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)cosLv)))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)sinLv)));
        return (T)((CalculusFieldElement)lV.add((FieldElement)FieldEquinoctialLongitudeArgumentUtility.eccentricAndTrueAtan(num, den)));
    }

    private static <T extends CalculusFieldElement<T>> T eccentricAndTrueEpsilon(T ex, T ey) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.square()).negate()).subtract((FieldElement)((CalculusFieldElement)ey.square()))).add(1.0)).sqrt());
    }

    private static <T extends CalculusFieldElement<T>> T eccentricAndTrueAtan(T num, T den) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)num.divide(den)).atan()).multiply(2));
    }

    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T ex, T ey, T lM) {
        boolean hasConverged;
        Object lE = lM;
        CalculusFieldElement lEmlM = (CalculusFieldElement)lM.getField().getZero();
        int iter = 0;
        do {
            FieldSinCos scLE = FastMath.sinCos(lE);
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)scLE.sin()))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scLE.cos()))));
            CalculusFieldElement f1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)scLE.cos()))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scLE.sin()))))).negate()).add(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)lEmlM.subtract((FieldElement)f2);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2.0);
            CalculusFieldElement shift = (CalculusFieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f12)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f1.multiply((FieldElement)f12)).subtract((FieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f2)))));
            lEmlM = (CalculusFieldElement)lEmlM.subtract((FieldElement)shift);
            lE = (CalculusFieldElement)lM.add((FieldElement)lEmlM);
            boolean bl = hasConverged = FastMath.abs((double)shift.getReal()) <= 1.0E-11;
        } while (++iter < 50 && !hasConverged);
        if (!hasConverged) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECCENTRIC_LONGITUDE_ARGUMENT, iter);
        }
        return lE;
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T ex, T ey, T lE) {
        FieldSinCos scLE = FastMath.sinCos(lE);
        return (T)((CalculusFieldElement)((CalculusFieldElement)lE.subtract((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)scLE.sin()))))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scLE.cos())))));
    }

    public static <T extends CalculusFieldElement<T>> T trueToMean(T ex, T ey, T lV) {
        T alphaE = FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(ex, ey, lV);
        return FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(ex, ey, alphaE);
    }

    public static <T extends CalculusFieldElement<T>> T meanToTrue(T ex, T ey, T lM) {
        T alphaE = FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(ex, ey, lM);
        return FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(ex, ey, alphaE);
    }

    public static <T extends CalculusFieldElement<T>> T convertL(PositionAngleType oldType, T l, T ex, T ey, PositionAngleType newType) {
        if (oldType == newType) {
            return l;
        }
        switch (newType) {
            case ECCENTRIC: {
                if (oldType == PositionAngleType.MEAN) {
                    return FieldEquinoctialLongitudeArgumentUtility.meanToEccentric(ex, ey, l);
                }
                return FieldEquinoctialLongitudeArgumentUtility.trueToEccentric(ex, ey, l);
            }
            case MEAN: {
                if (oldType == PositionAngleType.TRUE) {
                    return FieldEquinoctialLongitudeArgumentUtility.trueToMean(ex, ey, l);
                }
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToMean(ex, ey, l);
            }
            case TRUE: {
                if (oldType == PositionAngleType.MEAN) {
                    return FieldEquinoctialLongitudeArgumentUtility.meanToTrue(ex, ey, l);
                }
                return FieldEquinoctialLongitudeArgumentUtility.eccentricToTrue(ex, ey, l);
            }
        }
        throw new OrekitInternalError(null);
    }
}

