/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative1;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.FieldCircularLatitudeArgumentUtility;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleBased;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCircularOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T>
implements PositionAngleBased {
    private final T a;
    private final T ex;
    private final T ey;
    private final T i;
    private final T raan;
    private final T cachedAlpha;
    private final PositionAngleType cachedPositionAngleType;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T iDot;
    private final T raanDot;
    private final T cachedAlphaDot;
    private FieldPVCoordinates<T> partialPV;

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, null, null, null, null, null, null, type, cachedPositionAngleType, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, type, type, frame, date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, T aDot, T exDot, T eyDot, T iDot, T raanDot, T alphaDot, PositionAngleType type, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, aDot, exDot, eyDot, iDot, raanDot, alphaDot, type, type, frame, date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, T aDot, T exDot, T eyDot, T iDot, T raanDot, T alphaDot, PositionAngleType type, PositionAngleType cachedPositionAngleType, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.i = i;
        this.iDot = iDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.cachedPositionAngleType = cachedPositionAngleType;
        if (this.hasDerivatives()) {
            FieldUnivariateDerivative1<T> alphaUD = this.initializeCachedAlpha(alpha, alphaDot, type);
            this.cachedAlpha = alphaUD.getValue();
            this.cachedAlphaDot = alphaUD.getFirstDerivative();
        } else {
            this.cachedAlpha = this.initializeCachedAlpha(alpha, type);
            this.cachedAlphaDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        this.cachedPositionAngleType = PositionAngleType.TRUE;
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        CalculusFieldElement r2 = pvP.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement V2 = pvV.getNormSq();
        CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)V2)).divide(mu);
        this.a = (CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rV2OnMu.negate()).add(2.0)));
        if (!this.isElliptical()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        FieldVector3D momentum = pvCoordinates.getMomentum();
        FieldVector3D plusK = FieldVector3D.getPlusK((Field)r.getField());
        this.i = FieldVector3D.angle(momentum, (FieldVector3D)plusK);
        FieldVector3D node = FieldVector3D.crossProduct((FieldVector3D)plusK, momentum);
        this.raan = (CalculusFieldElement)node.getY().atan2((FieldElement)node.getX());
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        FieldSinCos scI = FastMath.sinCos(this.i);
        CalculusFieldElement xP = pvP.getX();
        CalculusFieldElement yP = pvP.getY();
        CalculusFieldElement zP = pvP.getZ();
        CalculusFieldElement x2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)xP.multiply((FieldElement)((CalculusFieldElement)scRaan.cos()))).add((FieldElement)((CalculusFieldElement)yP.multiply((FieldElement)((CalculusFieldElement)scRaan.sin()))))).divide(this.a);
        CalculusFieldElement y2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)yP.multiply((FieldElement)((CalculusFieldElement)scRaan.cos()))).subtract((FieldElement)((CalculusFieldElement)xP.multiply((FieldElement)((CalculusFieldElement)scRaan.sin()))))).multiply((FieldElement)((CalculusFieldElement)scI.cos()))).add((FieldElement)((CalculusFieldElement)zP.multiply((FieldElement)((CalculusFieldElement)scI.sin()))))).divide(this.a);
        CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).sqrt()));
        CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)eCE.multiply((FieldElement)eCE)).add((FieldElement)((CalculusFieldElement)eSE.multiply((FieldElement)eSE)));
        CalculusFieldElement f = (CalculusFieldElement)eCE.subtract((FieldElement)e2);
        CalculusFieldElement g = (CalculusFieldElement)eSE.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()));
        CalculusFieldElement aOnR = (CalculusFieldElement)this.a.divide((FieldElement)r);
        CalculusFieldElement a2OnR2 = (CalculusFieldElement)aOnR.square();
        this.ex = (CalculusFieldElement)a2OnR2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)x2)).add((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)y2)))));
        this.ey = (CalculusFieldElement)a2OnR2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f.multiply((FieldElement)y2)).subtract((FieldElement)((CalculusFieldElement)g.multiply((FieldElement)x2)))));
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add((FieldElement)((CalculusFieldElement)this.ey.multiply(this.ey)))).negate()).add(1.0)).sqrt()).add(1.0)).reciprocal();
        this.cachedAlpha = FieldCircularLatitudeArgumentUtility.eccentricToTrue(this.ex, this.ey, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)y2.add(this.ey)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply(this.ex)))).atan2((FieldElement)((CalculusFieldElement)((CalculusFieldElement)x2.add(this.ex)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSE.multiply((FieldElement)beta)).multiply(this.ey))))));
        this.partialPV = pvCoordinates;
        if (FieldCircularOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngleType.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)mu.negate())), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            CalculusFieldElement aX = nonKeplerianAcceleration.getX();
            CalculusFieldElement aY = nonKeplerianAcceleration.getY();
            CalculusFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[0][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[0][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[0][5].multiply((FieldElement)aZ)));
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[1][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[1][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[1][5].multiply((FieldElement)aZ)));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[2][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[2][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[2][5].multiply((FieldElement)aZ)));
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[3][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[3][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[3][5].multiply((FieldElement)aZ)));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)jacobian[4][3].multiply((FieldElement)aX)).add((FieldElement)((CalculusFieldElement)jacobian[4][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[4][5].multiply((FieldElement)aZ)));
            CalculusFieldElement alphaMDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().add((FieldElement)((CalculusFieldElement)jacobian[5][3].multiply((FieldElement)aX)))).add((FieldElement)((CalculusFieldElement)jacobian[5][4].multiply((FieldElement)aY)))).add((FieldElement)((CalculusFieldElement)jacobian[5][5].multiply((FieldElement)aZ)));
            FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
            FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
            FieldUnivariateDerivative1 alphaMUD = new FieldUnivariateDerivative1(this.getAlphaM(), alphaMDot);
            FieldUnivariateDerivative1 alphavUD = FieldCircularLatitudeArgumentUtility.meanToTrue(exUD, eyUD, alphaMUD);
            this.cachedAlphaDot = alphavUD.getFirstDerivative();
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.cachedAlphaDot = null;
        }
    }

    public FieldCircularOrbit(FieldPVCoordinates<T> PVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, PVCoordinates2), frame, mu);
    }

    public FieldCircularOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.i = op.getI();
        T hx = op.getHx();
        T hy = op.getHy();
        CalculusFieldElement h2 = (CalculusFieldElement)((CalculusFieldElement)hx.square()).add((FieldElement)((CalculusFieldElement)hy.square()));
        CalculusFieldElement h = (CalculusFieldElement)h2.sqrt();
        this.raan = (CalculusFieldElement)hy.atan2(hx);
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        CalculusFieldElement cosRaan = h.getReal() == 0.0 ? (CalculusFieldElement)scRaan.cos() : (CalculusFieldElement)hx.divide((FieldElement)h);
        CalculusFieldElement sinRaan = h.getReal() == 0.0 ? (CalculusFieldElement)scRaan.sin() : (CalculusFieldElement)hy.divide((FieldElement)h);
        T equiEx = op.getEquinoctialEx();
        T equiEy = op.getEquinoctialEy();
        this.ex = (CalculusFieldElement)((CalculusFieldElement)equiEx.multiply((FieldElement)cosRaan)).add((FieldElement)((CalculusFieldElement)equiEy.multiply((FieldElement)sinRaan)));
        this.ey = (CalculusFieldElement)((CalculusFieldElement)equiEy.multiply((FieldElement)cosRaan)).subtract((FieldElement)((CalculusFieldElement)equiEx.multiply((FieldElement)sinRaan)));
        this.cachedPositionAngleType = PositionAngleType.TRUE;
        this.cachedAlpha = (CalculusFieldElement)op.getLv().subtract(this.raan);
        if (op.hasDerivatives()) {
            this.aDot = op.getADot();
            T hxDot = op.getHxDot();
            T hyDot = op.getHyDot();
            this.iDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)cosRaan.multiply(hxDot)).add((FieldElement)((CalculusFieldElement)sinRaan.multiply(hyDot)))).multiply(2)).divide((FieldElement)((CalculusFieldElement)h2.add(1.0)));
            this.raanDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx.multiply(hyDot)).subtract((FieldElement)((CalculusFieldElement)hy.multiply(hxDot)))).divide((FieldElement)h2);
            T equiExDot = op.getEquinoctialExDot();
            T equiEyDot = op.getEquinoctialEyDot();
            this.exDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)equiExDot.add((FieldElement)((CalculusFieldElement)equiEy.multiply(this.raanDot)))).multiply((FieldElement)cosRaan)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)equiEyDot.subtract((FieldElement)((CalculusFieldElement)equiEx.multiply(this.raanDot)))).multiply((FieldElement)sinRaan)));
            this.eyDot = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)equiEyDot.subtract((FieldElement)((CalculusFieldElement)equiEx.multiply(this.raanDot)))).multiply((FieldElement)cosRaan)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)equiExDot.add((FieldElement)((CalculusFieldElement)equiEy.multiply(this.raanDot)))).multiply((FieldElement)sinRaan)));
            this.cachedAlphaDot = (CalculusFieldElement)op.getLvDot().subtract(this.raanDot);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.cachedAlphaDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(Field<T> field, CircularOrbit op) {
        super(op.getFrame(), new FieldAbsoluteDate<T>(field, op.getDate()), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getMu()));
        this.a = (CalculusFieldElement)this.getZero().newInstance(op.getA());
        this.i = (CalculusFieldElement)this.getZero().newInstance(op.getI());
        this.raan = (CalculusFieldElement)this.getZero().newInstance(op.getRightAscensionOfAscendingNode());
        this.ex = (CalculusFieldElement)this.getZero().newInstance(op.getCircularEx());
        this.ey = (CalculusFieldElement)this.getZero().newInstance(op.getCircularEy());
        this.cachedPositionAngleType = op.getCachedPositionAngleType();
        this.cachedAlpha = (CalculusFieldElement)this.getZero().newInstance(op.getAlpha(this.cachedPositionAngleType));
        if (op.hasDerivatives()) {
            this.aDot = (CalculusFieldElement)this.getZero().newInstance(op.getADot());
            this.iDot = (CalculusFieldElement)this.getZero().newInstance(op.getIDot());
            this.raanDot = (CalculusFieldElement)this.getZero().newInstance(op.getRightAscensionOfAscendingNodeDot());
            this.exDot = (CalculusFieldElement)this.getZero().newInstance(op.getCircularExDot());
            this.eyDot = (CalculusFieldElement)this.getZero().newInstance(op.getCircularEyDot());
            this.cachedAlphaDot = (CalculusFieldElement)this.getZero().newInstance(op.getAlphaDot(this.cachedPositionAngleType));
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.cachedAlphaDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(Field<T> field, Orbit op) {
        this(field, (CircularOrbit)OrbitType.CIRCULAR.convertType(op));
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CIRCULAR;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)((CalculusFieldElement)sc.cos()))).subtract((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)((CalculusFieldElement)sc.sin())))));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.exDot.subtract((FieldElement)((CalculusFieldElement)this.ey.multiply(this.raanDot)))).multiply((FieldElement)((CalculusFieldElement)sc.cos()))).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.eyDot.add((FieldElement)((CalculusFieldElement)this.ex.multiply(this.raanDot)))).multiply((FieldElement)((CalculusFieldElement)sc.sin())))));
    }

    @Override
    public T getEquinoctialEy() {
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)((CalculusFieldElement)sc.sin())))));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.eyDot.add((FieldElement)((CalculusFieldElement)this.ex.multiply(this.raanDot)))).multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.exDot.subtract((FieldElement)((CalculusFieldElement)this.ey.multiply(this.raanDot)))).multiply((FieldElement)((CalculusFieldElement)sc.sin())))));
    }

    public T getCircularEx() {
        return this.ex;
    }

    public T getCircularExDot() {
        return this.exDot;
    }

    public T getCircularEy() {
        return this.ey;
    }

    public T getCircularEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.cos()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.i.divide(2.0)).tan())));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        CalculusFieldElement tan = (CalculusFieldElement)((CalculusFieldElement)this.i.multiply(0.5)).tan();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply(0.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)tan.multiply((FieldElement)tan)).add(1.0)))).multiply(this.iDot)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply((FieldElement)tan)).multiply(this.raanDot))));
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)this.raan.sin()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.i.divide(2.0)).tan())));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)((CalculusFieldElement)this.i.subtract((FieldElement)((CalculusFieldElement)this.i.getPi()))).getReal()) < 1.0E-10) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        FieldSinCos sc = FastMath.sinCos(this.raan);
        CalculusFieldElement tan = (CalculusFieldElement)((CalculusFieldElement)this.i.multiply(0.5)).tan();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.sin()).multiply(0.5)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)tan.multiply((FieldElement)tan)).add(1.0)))).multiply(this.iDot)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sc.cos()).multiply((FieldElement)tan)).multiply(this.raanDot))));
    }

    public T getAlphaV() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return this.cachedAlpha;
            }
            case ECCENTRIC: {
                return FieldCircularLatitudeArgumentUtility.eccentricToTrue(this.ex, this.ey, this.cachedAlpha);
            }
            case MEAN: {
                return FieldCircularLatitudeArgumentUtility.meanToTrue(this.ex, this.ey, this.cachedAlpha);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlphaVDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case ECCENTRIC: {
                FieldUnivariateDerivative1 alphaEUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaVUD = FieldCircularLatitudeArgumentUtility.eccentricToTrue(exUD, eyUD, alphaEUD);
                return (T)alphaVUD.getFirstDerivative();
            }
            case TRUE: {
                return this.cachedAlphaDot;
            }
            case MEAN: {
                FieldUnivariateDerivative1 alphaMUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaVUD2 = FieldCircularLatitudeArgumentUtility.meanToTrue(exUD2, eyUD2, alphaMUD);
                return (T)alphaVUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlphaE() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return FieldCircularLatitudeArgumentUtility.trueToEccentric(this.ex, this.ey, this.cachedAlpha);
            }
            case ECCENTRIC: {
                return this.cachedAlpha;
            }
            case MEAN: {
                return FieldCircularLatitudeArgumentUtility.meanToEccentric(this.ex, this.ey, this.cachedAlpha);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlphaEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                FieldUnivariateDerivative1 alphaVUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaEUD = FieldCircularLatitudeArgumentUtility.trueToEccentric(exUD, eyUD, alphaVUD);
                return (T)alphaEUD.getFirstDerivative();
            }
            case ECCENTRIC: {
                return this.cachedAlphaDot;
            }
            case MEAN: {
                FieldUnivariateDerivative1 alphaMUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaVUD2 = FieldCircularLatitudeArgumentUtility.meanToEccentric(exUD2, eyUD2, alphaMUD);
                return (T)alphaVUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlphaM() {
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                return FieldCircularLatitudeArgumentUtility.trueToMean(this.ex, this.ey, this.cachedAlpha);
            }
            case MEAN: {
                return this.cachedAlpha;
            }
            case ECCENTRIC: {
                return FieldCircularLatitudeArgumentUtility.eccentricToMean(this.ex, this.ey, this.cachedAlpha);
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlphaMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        switch (this.cachedPositionAngleType) {
            case TRUE: {
                FieldUnivariateDerivative1 alphaVUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaMUD = FieldCircularLatitudeArgumentUtility.trueToMean(exUD, eyUD, alphaVUD);
                return (T)alphaMUD.getFirstDerivative();
            }
            case MEAN: {
                return this.cachedAlphaDot;
            }
            case ECCENTRIC: {
                FieldUnivariateDerivative1 alphaEUD = new FieldUnivariateDerivative1(this.cachedAlpha, this.cachedAlphaDot);
                FieldUnivariateDerivative1 exUD2 = new FieldUnivariateDerivative1(this.ex, this.exDot);
                FieldUnivariateDerivative1 eyUD2 = new FieldUnivariateDerivative1(this.ey, this.eyDot);
                FieldUnivariateDerivative1 alphaMUD2 = FieldCircularLatitudeArgumentUtility.eccentricToMean(exUD2, eyUD2, alphaEUD);
                return (T)alphaMUD2.getFirstDerivative();
            }
        }
        throw new OrekitInternalError(null);
    }

    public T getAlpha(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getAlphaM() : (type == PositionAngleType.ECCENTRIC ? this.getAlphaE() : this.getAlphaV());
    }

    public T getAlphaDot(PositionAngleType type) {
        return type == PositionAngleType.MEAN ? this.getAlphaMDot() : (type == PositionAngleType.ECCENTRIC ? this.getAlphaEDot() : this.getAlphaVDot());
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T alphaE, T ex, T ey) {
        return FieldCircularLatitudeArgumentUtility.eccentricToTrue(ex, ey, alphaE);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T alphaV, T ex, T ey) {
        return FieldCircularLatitudeArgumentUtility.trueToEccentric(ex, ey, alphaV);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T alphaM, T ex, T ey) {
        return FieldCircularLatitudeArgumentUtility.meanToEccentric(ex, ey, alphaM);
    }

    @Deprecated
    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T alphaE, T ex, T ey) {
        return FieldCircularLatitudeArgumentUtility.eccentricToMean(ex, ey, alphaE);
    }

    @Override
    public T getE() {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add((FieldElement)((CalculusFieldElement)this.ey.multiply(this.ey)))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.exDot)).add((FieldElement)((CalculusFieldElement)this.ey.multiply(this.eyDot)))).divide(this.getE()));
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    @Override
    public T getLv() {
        return (T)((CalculusFieldElement)this.getAlphaV().add(this.raan));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.getAlphaVDot().add(this.raanDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((CalculusFieldElement)this.getAlphaE().add(this.raan));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.getAlphaEDot().add(this.raanDot) : null);
    }

    @Override
    public T getLM() {
        return (T)((CalculusFieldElement)this.getAlphaM().add(this.raan));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (CalculusFieldElement)this.getAlphaMDot().add(this.raanDot) : null);
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T equEx = this.getEquinoctialEx();
        T equEy = this.getEquinoctialEy();
        T hx = this.getHx();
        T hy = this.getHy();
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)hx.multiply(hx);
        CalculusFieldElement hy2 = (CalculusFieldElement)hy.multiply(hy);
        CalculusFieldElement factH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)).reciprocal();
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx.multiply(2)).multiply(hy)).multiply((FieldElement)factH);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement exey = (CalculusFieldElement)equEx.multiply(equEy);
        CalculusFieldElement ex2 = (CalculusFieldElement)equEx.square();
        CalculusFieldElement ey2 = (CalculusFieldElement)equEy.square();
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)eta.reciprocal();
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement exCeyS = (CalculusFieldElement)((CalculusFieldElement)equEx.multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)equEy.multiply((FieldElement)sLe)));
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ey2)).add(1.0)).multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe)))).subtract(equEx)));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ex2)).add(1.0)).multiply((FieldElement)sLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe)))).subtract(equEy)));
        CalculusFieldElement factor = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().add(this.getMu())).divide(this.a)).sqrt()).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)exCeyS.negate()).add(1.0)));
        CalculusFieldElement xdot = (CalculusFieldElement)factor.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply(equEy)).multiply((FieldElement)exCeyS)).subtract((FieldElement)sLe)));
        CalculusFieldElement ydot = (CalculusFieldElement)factor.multiply((FieldElement)((CalculusFieldElement)cLe.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply(equEx)).multiply((FieldElement)exCeyS)))));
        FieldVector3D position = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vz))));
        FieldVector3D velocity = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)xdot.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)ydot.multiply((FieldElement)vz))));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldUnivariateDerivative1<T> initializeCachedAlpha(T alpha, T alphaDot, PositionAngleType inputType) {
        if (this.cachedPositionAngleType == inputType) {
            return new FieldUnivariateDerivative1(alpha, alphaDot);
        }
        FieldUnivariateDerivative1 exUD = new FieldUnivariateDerivative1(this.ex, this.exDot);
        FieldUnivariateDerivative1 eyUD = new FieldUnivariateDerivative1(this.ey, this.eyDot);
        FieldUnivariateDerivative1 alphaUD = new FieldUnivariateDerivative1(alpha, alphaDot);
        switch (this.cachedPositionAngleType) {
            case ECCENTRIC: {
                if (inputType == PositionAngleType.MEAN) {
                    return FieldCircularLatitudeArgumentUtility.meanToEccentric(exUD, eyUD, alphaUD);
                }
                return FieldCircularLatitudeArgumentUtility.trueToEccentric(exUD, eyUD, alphaUD);
            }
            case TRUE: {
                if (inputType == PositionAngleType.MEAN) {
                    return FieldCircularLatitudeArgumentUtility.meanToTrue(exUD, eyUD, alphaUD);
                }
                return FieldCircularLatitudeArgumentUtility.eccentricToTrue(exUD, eyUD, alphaUD);
            }
            case MEAN: {
                if (inputType == PositionAngleType.TRUE) {
                    return FieldCircularLatitudeArgumentUtility.trueToMean(exUD, eyUD, alphaUD);
                }
                return FieldCircularLatitudeArgumentUtility.eccentricToMean(exUD, eyUD, alphaUD);
            }
        }
        throw new OrekitInternalError(null);
    }

    private T initializeCachedAlpha(T alpha, PositionAngleType positionAngleType) {
        return FieldCircularLatitudeArgumentUtility.convertAlpha(positionAngleType, alpha, this.ex, this.ey, this.cachedPositionAngleType);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        CalculusFieldElement[][] dCdP = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngleType.MEAN, dCdP);
        CalculusFieldElement nonKeplerianMeanMotion = (CalculusFieldElement)this.getAlphaMDot().subtract(this.getKeplerianMeanMotion());
        CalculusFieldElement nonKeplerianAx = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[3][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[3][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][3].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[3][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[4][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[4][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][3].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[4][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        CalculusFieldElement nonKeplerianAz = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dCdP[5][0].multiply(this.aDot)).add((FieldElement)((CalculusFieldElement)dCdP[5][1].multiply(this.exDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][2].multiply(this.eyDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][3].multiply(this.iDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][4].multiply(this.raanDot)))).add((FieldElement)((CalculusFieldElement)dCdP[5][5].multiply((FieldElement)nonKeplerianMeanMotion)));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected FieldVector3D<T> initPosition() {
        T equEx = this.getEquinoctialEx();
        T equEy = this.getEquinoctialEy();
        T hx = this.getHx();
        T hy = this.getHy();
        T lE = this.getLE();
        CalculusFieldElement hx2 = (CalculusFieldElement)hx.multiply(hx);
        CalculusFieldElement hy2 = (CalculusFieldElement)hy.multiply(hy);
        CalculusFieldElement factH = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).add((FieldElement)hy2)).reciprocal();
        CalculusFieldElement ux = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx2.add(1.0)).subtract((FieldElement)hy2)).multiply((FieldElement)factH);
        CalculusFieldElement uy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hx.multiply(2)).multiply(hy)).multiply((FieldElement)factH);
        CalculusFieldElement uz = (CalculusFieldElement)((CalculusFieldElement)hy.multiply(-2)).multiply((FieldElement)factH);
        CalculusFieldElement vx = uy;
        CalculusFieldElement vy = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)hy2.subtract((FieldElement)hx2)).add(1.0)).multiply((FieldElement)factH);
        CalculusFieldElement vz = (CalculusFieldElement)((CalculusFieldElement)hx.multiply((FieldElement)factH)).multiply(2);
        CalculusFieldElement exey = (CalculusFieldElement)equEx.multiply(equEy);
        CalculusFieldElement ex2 = (CalculusFieldElement)equEx.square();
        CalculusFieldElement ey2 = (CalculusFieldElement)equEy.square();
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement eta = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        CalculusFieldElement beta = (CalculusFieldElement)eta.reciprocal();
        FieldSinCos scLe = FastMath.sinCos(lE);
        CalculusFieldElement cLe = (CalculusFieldElement)scLe.cos();
        CalculusFieldElement sLe = (CalculusFieldElement)scLe.sin();
        CalculusFieldElement x = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ey2)).add(1.0)).multiply((FieldElement)cLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)sLe)))).subtract(equEx)));
        CalculusFieldElement y = (CalculusFieldElement)this.a.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.negate()).multiply((FieldElement)ex2)).add(1.0)).multiply((FieldElement)sLe)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)beta.multiply((FieldElement)exey)).multiply((FieldElement)cLe)))).subtract(equEy)));
        return new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)ux)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vx))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uy)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vy))), (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)uz)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)vz))));
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        CalculusFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)r2.sqrt()))).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)this.getZero().newInstance(dt));
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(T dt) {
        FieldCircularOrbit<CalculusFieldElement> keplerianShifted = new FieldCircularOrbit<CalculusFieldElement>((CalculusFieldElement)this.a, (CalculusFieldElement)this.ex, (CalculusFieldElement)this.ey, (CalculusFieldElement)this.i, (CalculusFieldElement)this.raan, (CalculusFieldElement)this.getAlphaM().add((FieldElement)((CalculusFieldElement)this.getKeplerianMeanMotion().multiply(dt))), PositionAngleType.MEAN, this.cachedPositionAngleType, this.getFrame(), (FieldAbsoluteDate<CalculusFieldElement>)this.getDate().shiftedBy((CalculusFieldElement)dt), (CalculusFieldElement)this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getPosition(), (CalculusFieldElement)((CalculusFieldElement)dt.square()).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.getOne(), keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR2.multiply((FieldElement)fixedR)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), keplerianShifted.partialPV.getPosition(), this.getOne(), nonKeplerianAcceleration);
            return new FieldCircularOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        CalculusFieldElement[][] jacobian = (CalculusFieldElement[][])MathArrays.buildArray((Field)this.getOne().getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        CalculusFieldElement x = position.getX();
        CalculusFieldElement y = position.getY();
        CalculusFieldElement z = position.getZ();
        CalculusFieldElement vx = velocity.getX();
        CalculusFieldElement vy = velocity.getY();
        CalculusFieldElement vz = velocity.getZ();
        CalculusFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
        CalculusFieldElement v2 = velocity.getNormSq();
        Object mu = this.getMu();
        CalculusFieldElement oOsqrtMuA = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.a.multiply(mu)).sqrt()));
        CalculusFieldElement rOa = (CalculusFieldElement)r.divide(this.a);
        CalculusFieldElement aOr = (CalculusFieldElement)this.a.divide((FieldElement)r);
        CalculusFieldElement aOr2 = (CalculusFieldElement)this.a.divide((FieldElement)r2);
        CalculusFieldElement a2 = (CalculusFieldElement)this.a.square();
        CalculusFieldElement ex2 = (CalculusFieldElement)this.ex.square();
        CalculusFieldElement ey2 = (CalculusFieldElement)this.ey.square();
        CalculusFieldElement e2 = (CalculusFieldElement)ex2.add((FieldElement)ey2);
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).sqrt();
        CalculusFieldElement beta = (CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).reciprocal();
        CalculusFieldElement eCosE = (CalculusFieldElement)((CalculusFieldElement)rOa.negate()).add(1.0);
        CalculusFieldElement eSinE = (CalculusFieldElement)pv.multiply((FieldElement)oOsqrtMuA);
        FieldSinCos scI = FastMath.sinCos(this.i);
        FieldSinCos scRaan = FastMath.sinCos(this.raan);
        CalculusFieldElement cosI = (CalculusFieldElement)scI.cos();
        CalculusFieldElement sinI = (CalculusFieldElement)scI.sin();
        CalculusFieldElement cosRaan = (CalculusFieldElement)scRaan.cos();
        CalculusFieldElement sinRaan = (CalculusFieldElement)scRaan.sin();
        this.fillHalfRow((CalculusFieldElement)((CalculusFieldElement)aOr.multiply(2.0)).multiply((FieldElement)aOr2), position, jacobian[0], 0);
        this.fillHalfRow((CalculusFieldElement)a2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)mu.divide(2.0)).reciprocal())), velocity, jacobian[0], 3);
        FieldVector3D danP = new FieldVector3D(v2, position, (CalculusFieldElement)pv.negate(), velocity);
        FieldVector3D danV = new FieldVector3D(r2, velocity, (CalculusFieldElement)pv.negate(), position);
        CalculusFieldElement recip = (CalculusFieldElement)this.partialPV.getMomentum().getNorm().reciprocal();
        CalculusFieldElement recip2 = (CalculusFieldElement)recip.multiply((FieldElement)recip);
        CalculusFieldElement recip2N = (CalculusFieldElement)recip2.negate();
        FieldVector3D dwXP = new FieldVector3D(recip, new FieldVector3D(this.getZero(), vz, (CalculusFieldElement)vy.negate()), (CalculusFieldElement)((CalculusFieldElement)recip2N.multiply((FieldElement)sinRaan)).multiply((FieldElement)sinI), danP);
        FieldVector3D dwYP = new FieldVector3D(recip, new FieldVector3D((CalculusFieldElement)vz.negate(), this.getZero(), vx), (CalculusFieldElement)((CalculusFieldElement)recip2.multiply((FieldElement)cosRaan)).multiply((FieldElement)sinI), danP);
        FieldVector3D dwZP = new FieldVector3D(recip, new FieldVector3D(vy, (CalculusFieldElement)vx.negate(), this.getZero()), (CalculusFieldElement)recip2N.multiply((FieldElement)cosI), danP);
        FieldVector3D dwXV = new FieldVector3D(recip, new FieldVector3D(this.getZero(), (CalculusFieldElement)z.negate(), y), (CalculusFieldElement)((CalculusFieldElement)recip2N.multiply((FieldElement)sinRaan)).multiply((FieldElement)sinI), danV);
        FieldVector3D dwYV = new FieldVector3D(recip, new FieldVector3D(z, this.getZero(), (CalculusFieldElement)x.negate()), (CalculusFieldElement)((CalculusFieldElement)recip2.multiply((FieldElement)cosRaan)).multiply((FieldElement)sinI), danV);
        FieldVector3D dwZV = new FieldVector3D(recip, new FieldVector3D((CalculusFieldElement)y.negate(), x, this.getZero()), (CalculusFieldElement)recip2N.multiply((FieldElement)cosI), danV);
        this.fillHalfRow((CalculusFieldElement)sinRaan.multiply((FieldElement)cosI), dwXP, (CalculusFieldElement)((CalculusFieldElement)cosRaan.negate()).multiply((FieldElement)cosI), dwYP, (CalculusFieldElement)sinI.negate(), dwZP, jacobian[3], 0);
        this.fillHalfRow((CalculusFieldElement)sinRaan.multiply((FieldElement)cosI), dwXV, (CalculusFieldElement)((CalculusFieldElement)cosRaan.negate()).multiply((FieldElement)cosI), dwYV, (CalculusFieldElement)sinI.negate(), dwZV, jacobian[3], 3);
        this.fillHalfRow((CalculusFieldElement)sinRaan.divide((FieldElement)sinI), dwYP, (CalculusFieldElement)cosRaan.divide((FieldElement)sinI), dwXP, jacobian[4], 0);
        this.fillHalfRow((CalculusFieldElement)sinRaan.divide((FieldElement)sinI), dwYV, (CalculusFieldElement)cosRaan.divide((FieldElement)sinI), dwXV, jacobian[4], 3);
        CalculusFieldElement u = (CalculusFieldElement)((CalculusFieldElement)x.multiply((FieldElement)cosRaan)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)sinRaan)));
        CalculusFieldElement cv = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)x.negate()).multiply((FieldElement)sinRaan)).add((FieldElement)((CalculusFieldElement)y.multiply((FieldElement)cosRaan)));
        CalculusFieldElement v = (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosI)).add((FieldElement)((CalculusFieldElement)z.multiply((FieldElement)sinI)));
        FieldVector3D duP = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosRaan)).divide((FieldElement)sinI), dwXP, (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)sinRaan)).divide((FieldElement)sinI), dwYP, this.getOne(), new FieldVector3D(cosRaan, sinRaan, this.getZero()));
        FieldVector3D duV = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)cosRaan)).divide((FieldElement)sinI), dwXV, (CalculusFieldElement)((CalculusFieldElement)cv.multiply((FieldElement)sinRaan)).divide((FieldElement)sinI), dwYV);
        FieldVector3D dvP = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)cosRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).add((FieldElement)((CalculusFieldElement)sinRaan.multiply((FieldElement)z))), dwXP, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)sinRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).subtract((FieldElement)((CalculusFieldElement)cosRaan.multiply((FieldElement)z))), dwYP, cv, dwZP, this.getOne(), new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)sinRaan.negate()).multiply((FieldElement)cosI), (CalculusFieldElement)cosRaan.multiply((FieldElement)cosI), sinI));
        FieldVector3D dvV = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)cosRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).add((FieldElement)((CalculusFieldElement)sinRaan.multiply((FieldElement)z))), dwXV, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.negate()).multiply((FieldElement)sinRaan)).multiply((FieldElement)cosI)).divide((FieldElement)sinI)).subtract((FieldElement)((CalculusFieldElement)cosRaan.multiply((FieldElement)z))), dwYV, cv, dwZV);
        FieldVector3D dc1P = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)).multiply(2)).add(1.0)).subtract((FieldElement)eCosE)))).divide((FieldElement)r2), position, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(-2)).multiply((FieldElement)eSinE)).multiply((FieldElement)oOsqrtMuA), velocity);
        FieldVector3D dc1V = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply(-2)).multiply((FieldElement)eSinE)).multiply((FieldElement)oOsqrtMuA), position, (CalculusFieldElement)((CalculusFieldElement)this.getZero().newInstance(2.0)).divide(mu), velocity);
        FieldVector3D dc2P = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)eSinE)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)))))).divide((FieldElement)((CalculusFieldElement)r2.multiply((FieldElement)epsilon))), position, (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).subtract((FieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)))))).multiply((FieldElement)oOsqrtMuA)).divide((FieldElement)epsilon), velocity);
        FieldVector3D dc2V = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)e2.negate()).add(1.0)).subtract((FieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)))))).multiply((FieldElement)oOsqrtMuA)).divide((FieldElement)epsilon), position, (CalculusFieldElement)eSinE.divide((FieldElement)((CalculusFieldElement)epsilon.multiply(mu))), velocity);
        CalculusFieldElement cof1 = (CalculusFieldElement)aOr2.multiply((FieldElement)((CalculusFieldElement)eCosE.subtract((FieldElement)e2)));
        CalculusFieldElement cof2 = (CalculusFieldElement)((CalculusFieldElement)aOr2.multiply((FieldElement)epsilon)).multiply((FieldElement)eSinE);
        FieldVector3D dexP = new FieldVector3D(u, dc1P, v, dc2P, cof1, duP, cof2, dvP);
        FieldVector3D dexV = new FieldVector3D(u, dc1V, v, dc2V, cof1, duV, cof2, dvV);
        FieldVector3D deyP = new FieldVector3D(v, dc1P, (CalculusFieldElement)u.negate(), dc2P, cof1, dvP, (CalculusFieldElement)cof2.negate(), duP);
        FieldVector3D deyV = new FieldVector3D(v, dc1V, (CalculusFieldElement)u.negate(), dc2V, cof1, dvV, (CalculusFieldElement)cof2.negate(), duV);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dexP, jacobian[1], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), dexV, jacobian[1], 3);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), deyP, jacobian[2], 0);
        this.fillHalfRow((CalculusFieldElement)this.getOne(), deyV, jacobian[2], 3);
        CalculusFieldElement cle = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.divide(this.a)).add(this.ex)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply(this.ey)));
        CalculusFieldElement sle = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)v.divide(this.a)).add(this.ey)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply(this.ex)));
        CalculusFieldElement m1 = (CalculusFieldElement)beta.multiply((FieldElement)eCosE);
        CalculusFieldElement m2 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eCosE)).negate()).add(1.0);
        CalculusFieldElement m3 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply(this.ey)).subtract((FieldElement)((CalculusFieldElement)v.multiply(this.ex)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)beta)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)u.multiply(this.ex)).add((FieldElement)((CalculusFieldElement)v.multiply(this.ey)))))));
        CalculusFieldElement m4 = (CalculusFieldElement)((CalculusFieldElement)sle.negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)cle.multiply((FieldElement)eSinE)).multiply((FieldElement)beta)));
        CalculusFieldElement m5 = (CalculusFieldElement)cle.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)sle.multiply((FieldElement)eSinE)).multiply((FieldElement)beta)));
        CalculusFieldElement kk = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m3.multiply(2)).divide((FieldElement)r)).add((FieldElement)((CalculusFieldElement)aOr.multiply((FieldElement)eSinE)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eSinE)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.add(1.0)).subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)aOr.add(1.0)).multiply((FieldElement)m2)))))).divide((FieldElement)epsilon)))).divide((FieldElement)r2);
        CalculusFieldElement jj = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)m2)).divide((FieldElement)epsilon)).subtract(1.0)).multiply((FieldElement)oOsqrtMuA);
        this.fillHalfRow(kk, position, jj, velocity, m4, dexP, m5, deyP, (CalculusFieldElement)((CalculusFieldElement)sle.negate()).divide(this.a), duP, (CalculusFieldElement)cle.divide(this.a), dvP, jacobian[5], 0);
        CalculusFieldElement ll = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)m2)).divide((FieldElement)epsilon)).subtract(1.0)).multiply((FieldElement)oOsqrtMuA);
        CalculusFieldElement mm = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m3.multiply(2)).add((FieldElement)((CalculusFieldElement)eSinE.multiply(this.a)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)m1.multiply((FieldElement)eSinE)).multiply((FieldElement)r)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCosE.multiply((FieldElement)beta)).multiply(2)).subtract((FieldElement)((CalculusFieldElement)aOr.multiply((FieldElement)m2)))))).divide((FieldElement)epsilon)))).divide(mu);
        this.fillHalfRow(ll, position, mm, velocity, m4, dexV, m5, deyV, (CalculusFieldElement)((CalculusFieldElement)sle.negate()).divide(this.a), duV, (CalculusFieldElement)cle.divide(this.a), dvV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T alphaE = this.getAlphaE();
        FieldSinCos scAe = FastMath.sinCos(alphaE);
        CalculusFieldElement cosAe = (CalculusFieldElement)scAe.cos();
        CalculusFieldElement sinAe = (CalculusFieldElement)scAe.sin();
        CalculusFieldElement aOr = (CalculusFieldElement)this.getOne().divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosAe)))).subtract((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sinAe)))));
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (CalculusFieldElement)aOr.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)rowL[j].add((FieldElement)((CalculusFieldElement)sinAe.multiply((FieldElement)rowEx[j])))).subtract((FieldElement)((CalculusFieldElement)cosAe.multiply((FieldElement)rowEy[j])))));
        }
        jacobian[5] = rowL;
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        CalculusFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T alphaE = this.getAlphaE();
        FieldSinCos scAe = FastMath.sinCos(alphaE);
        CalculusFieldElement cosAe = (CalculusFieldElement)scAe.cos();
        CalculusFieldElement sinAe = (CalculusFieldElement)scAe.sin();
        CalculusFieldElement eSinE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)sinAe)).subtract((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)cosAe)));
        CalculusFieldElement ecosE = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)cosAe)).add((FieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)sinAe)));
        CalculusFieldElement e2 = (CalculusFieldElement)((CalculusFieldElement)this.ex.multiply(this.ex)).add((FieldElement)((CalculusFieldElement)this.ey.multiply(this.ey)));
        CalculusFieldElement epsilon = (CalculusFieldElement)((CalculusFieldElement)this.getOne().subtract((FieldElement)e2)).sqrt();
        CalculusFieldElement onePeps = (CalculusFieldElement)this.getOne().add((FieldElement)epsilon);
        CalculusFieldElement d = (CalculusFieldElement)onePeps.subtract((FieldElement)ecosE);
        CalculusFieldElement cT = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)d.multiply((FieldElement)d)).add((FieldElement)((CalculusFieldElement)eSinE.multiply((FieldElement)eSinE)))).divide(2.0);
        CalculusFieldElement cE = (CalculusFieldElement)((CalculusFieldElement)ecosE.multiply((FieldElement)onePeps)).subtract((FieldElement)e2);
        CalculusFieldElement cX = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ex.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).subtract(this.ey)).add((FieldElement)((CalculusFieldElement)sinAe.multiply((FieldElement)onePeps)));
        CalculusFieldElement cY = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.ey.multiply((FieldElement)eSinE)).divide((FieldElement)epsilon)).add(this.ex)).subtract((FieldElement)((CalculusFieldElement)cosAe.multiply((FieldElement)onePeps)));
        CalculusFieldElement factorLe = (CalculusFieldElement)((CalculusFieldElement)cT.add((FieldElement)cE)).divide((FieldElement)cT);
        CalculusFieldElement factorEx = (CalculusFieldElement)cX.divide((FieldElement)cT);
        CalculusFieldElement factorEy = (CalculusFieldElement)cY.divide((FieldElement)cT);
        CalculusFieldElement[] rowEx = jacobian[1];
        CalculusFieldElement[] rowEy = jacobian[2];
        CalculusFieldElement[] rowA = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowA[j] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)factorLe.multiply((FieldElement)rowA[j])).add((FieldElement)((CalculusFieldElement)factorEx.multiply((FieldElement)rowEx[j])))).add((FieldElement)((CalculusFieldElement)factorEy.multiply((FieldElement)rowEy[j])));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngleType type, T gm, T[] pDot) {
        pDot[5] = (CalculusFieldElement)pDot[5].add(FieldCircularOrbit.computeKeplerianAlphaDot(type, this.a, this.ex, this.ey, gm, this.cachedAlpha, this.cachedPositionAngleType));
    }

    private static <T extends CalculusFieldElement<T>> T computeKeplerianAlphaDot(PositionAngleType type, T a, T ex, T ey, T mu, T alpha, PositionAngleType cachedType) {
        CalculusFieldElement n = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)a.reciprocal()).multiply(mu)).sqrt()).divide(a);
        if (type == PositionAngleType.MEAN) {
            return (T)n;
        }
        if (type == PositionAngleType.ECCENTRIC) {
            FieldSinCos sc = FastMath.sinCos(FieldCircularLatitudeArgumentUtility.convertAlpha(cachedType, alpha, ex, ey, type));
            CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)sc.cos()))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)sc.sin()))))).negate()).add(1.0)).reciprocal();
            return (T)((CalculusFieldElement)n.multiply((FieldElement)ksi));
        }
        FieldSinCos sc = FastMath.sinCos(FieldCircularLatitudeArgumentUtility.convertAlpha(cachedType, alpha, ex, ey, type));
        CalculusFieldElement one = (CalculusFieldElement)n.getField().getOne();
        CalculusFieldElement oMe2 = (CalculusFieldElement)((CalculusFieldElement)one.subtract((FieldElement)((CalculusFieldElement)ex.square()))).subtract((FieldElement)((CalculusFieldElement)ey.square()));
        CalculusFieldElement ksi = (CalculusFieldElement)((CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)sc.cos()))))).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)sc.sin()))));
        return (T)((CalculusFieldElement)((CalculusFieldElement)n.multiply((FieldElement)((CalculusFieldElement)ksi.square()))).divide((FieldElement)((CalculusFieldElement)oMe2.multiply((FieldElement)((CalculusFieldElement)oMe2.sqrt())))));
    }

    public String toString() {
        return "circular parameters: " + '{' + "a: " + this.a.getReal() + ", ex: " + this.ex.getReal() + ", ey: " + this.ey.getReal() + ", i: " + FastMath.toDegrees((double)this.i.getReal()) + ", raan: " + FastMath.toDegrees((double)this.raan.getReal()) + ", alphaV: " + FastMath.toDegrees((double)this.getAlphaV().getReal()) + ";}";
    }

    @Override
    public PositionAngleType getCachedPositionAngleType() {
        return this.cachedPositionAngleType;
    }

    @Override
    public boolean hasRates() {
        return this.hasDerivatives();
    }

    @Override
    public FieldCircularOrbit<T> removeRates() {
        return new FieldCircularOrbit<T>(this.getA(), this.getCircularEx(), this.getCircularEy(), this.getI(), this.getRightAscensionOfAscendingNode(), this.cachedAlpha, this.cachedPositionAngleType, this.getFrame(), this.getDate(), this.getMu());
    }

    @Override
    public CircularOrbit toOrbit() {
        double cachedPositionAngle = this.cachedAlpha.getReal();
        if (this.hasDerivatives()) {
            return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), cachedPositionAngle, this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.iDot.getReal(), this.raanDot.getReal(), this.cachedAlphaDot.getReal(), this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
        }
        return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), cachedPositionAngle, this.cachedPositionAngleType, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu().getReal());
    }
}

