/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public class FieldCircularLatitudeArgumentUtility {
    private static final double TOLERANCE_CONVERGENCE = 1.0E-11;
    private static final int MAXIMUM_ITERATION = 50;

    private FieldCircularLatitudeArgumentUtility() {
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToTrue(T ex, T ey, T alphaE) {
        T epsilon = FieldCircularLatitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
        CalculusFieldElement cosAlphaE = (CalculusFieldElement)scAlphaE.cos();
        CalculusFieldElement sinAlphaE = (CalculusFieldElement)scAlphaE.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)sinAlphaE)).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)cosAlphaE)));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).subtract((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)cosAlphaE)))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)sinAlphaE)));
        return (T)((CalculusFieldElement)alphaE.add((FieldElement)FieldCircularLatitudeArgumentUtility.eccentricAndTrueAtan(num, den)));
    }

    public static <T extends CalculusFieldElement<T>> T trueToEccentric(T ex, T ey, T alphaV) {
        T epsilon = FieldCircularLatitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        FieldSinCos scAlphaV = FastMath.sinCos(alphaV);
        CalculusFieldElement cosAlphaV = (CalculusFieldElement)scAlphaV.cos();
        CalculusFieldElement sinAlphaV = (CalculusFieldElement)scAlphaV.sin();
        CalculusFieldElement num = (CalculusFieldElement)((CalculusFieldElement)ey.multiply((FieldElement)cosAlphaV)).subtract((FieldElement)((CalculusFieldElement)ex.multiply((FieldElement)sinAlphaV)));
        CalculusFieldElement den = (CalculusFieldElement)((CalculusFieldElement)epsilon.add(1.0)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)cosAlphaV)).add((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)sinAlphaV)))));
        return (T)((CalculusFieldElement)alphaV.add((FieldElement)FieldCircularLatitudeArgumentUtility.eccentricAndTrueAtan(num, den)));
    }

    private static <T extends CalculusFieldElement<T>> T eccentricAndTrueEpsilon(T ex, T ey) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.square()).negate()).subtract((FieldElement)((CalculusFieldElement)ey.square()))).add(1.0)).sqrt());
    }

    private static <T extends CalculusFieldElement<T>> T eccentricAndTrueAtan(T num, T den) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)num.divide(den)).atan()).multiply(2));
    }

    public static <T extends CalculusFieldElement<T>> T meanToEccentric(T ex, T ey, T alphaM) {
        boolean hasConverged;
        Object alphaE = alphaM;
        CalculusFieldElement alphaEMalphaM = (CalculusFieldElement)alphaM.getField().getZero();
        int iter = 0;
        do {
            FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
            CalculusFieldElement f2 = (CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)scAlphaE.sin()))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scAlphaE.cos()))));
            CalculusFieldElement f1 = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.negate()).multiply((FieldElement)((CalculusFieldElement)scAlphaE.cos()))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scAlphaE.sin()))))).add(1.0);
            CalculusFieldElement f0 = (CalculusFieldElement)alphaEMalphaM.subtract((FieldElement)f2);
            CalculusFieldElement f12 = (CalculusFieldElement)f1.multiply(2);
            CalculusFieldElement shift = (CalculusFieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f12)).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f1.multiply((FieldElement)f12)).subtract((FieldElement)((CalculusFieldElement)f0.multiply((FieldElement)f2)))));
            alphaEMalphaM = (CalculusFieldElement)alphaEMalphaM.subtract((FieldElement)shift);
            alphaE = (CalculusFieldElement)alphaM.add((FieldElement)alphaEMalphaM);
            boolean bl = hasConverged = FastMath.abs((double)shift.getReal()) <= 1.0E-11;
        } while (++iter < 50 && !hasConverged);
        if (!hasConverged) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECCENTRIC_LATITUDE_ARGUMENT, iter);
        }
        return alphaE;
    }

    public static <T extends CalculusFieldElement<T>> T eccentricToMean(T ex, T ey, T alphaE) {
        FieldSinCos scAlphaE = FastMath.sinCos(alphaE);
        return (T)((CalculusFieldElement)alphaE.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ex.multiply((FieldElement)((CalculusFieldElement)scAlphaE.sin()))).subtract((FieldElement)((CalculusFieldElement)ey.multiply((FieldElement)((CalculusFieldElement)scAlphaE.cos())))))));
    }

    public static <T extends CalculusFieldElement<T>> T trueToMean(T ex, T ey, T alphaV) {
        T alphaE = FieldCircularLatitudeArgumentUtility.trueToEccentric(ex, ey, alphaV);
        return FieldCircularLatitudeArgumentUtility.eccentricToMean(ex, ey, alphaE);
    }

    public static <T extends CalculusFieldElement<T>> T meanToTrue(T ex, T ey, T alphaM) {
        T alphaE = FieldCircularLatitudeArgumentUtility.meanToEccentric(ex, ey, alphaM);
        return FieldCircularLatitudeArgumentUtility.eccentricToTrue(ex, ey, alphaE);
    }

    public static <T extends CalculusFieldElement<T>> T convertAlpha(PositionAngleType oldType, T alpha, T ex, T ey, PositionAngleType newType) {
        if (oldType == newType) {
            return alpha;
        }
        switch (newType) {
            case ECCENTRIC: {
                if (oldType == PositionAngleType.MEAN) {
                    return FieldCircularLatitudeArgumentUtility.meanToEccentric(ex, ey, alpha);
                }
                return FieldCircularLatitudeArgumentUtility.trueToEccentric(ex, ey, alpha);
            }
            case MEAN: {
                if (oldType == PositionAngleType.TRUE) {
                    return FieldCircularLatitudeArgumentUtility.trueToMean(ex, ey, alpha);
                }
                return FieldCircularLatitudeArgumentUtility.eccentricToMean(ex, ey, alpha);
            }
            case TRUE: {
                if (oldType == PositionAngleType.MEAN) {
                    return FieldCircularLatitudeArgumentUtility.meanToTrue(ex, ey, alpha);
                }
                return FieldCircularLatitudeArgumentUtility.eccentricToTrue(ex, ey, alpha);
            }
        }
        throw new OrekitInternalError(null);
    }
}

