/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.differentiation.FieldUnivariateDerivative2;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathArrays;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.KeplerianMotionCartesianUtility;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCartesianOrbit<T extends CalculusFieldElement<T>>
extends FieldOrbit<T> {
    private final transient boolean hasNonKeplerianAcceleration;
    private transient FieldEquinoctialOrbit<T> equinoctial;

    public FieldCartesianOrbit(TimeStampedFieldPVCoordinates<T> pvaCoordinates, Frame frame, T mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = FieldCartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
    }

    public FieldCartesianOrbit(FieldPVCoordinates<T> pvaCoordinates, Frame frame, FieldAbsoluteDate<T> date, T mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, pvaCoordinates), frame, mu);
    }

    public FieldCartesianOrbit(FieldOrbit<T> op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof FieldEquinoctialOrbit ? (FieldEquinoctialOrbit)op : (op instanceof FieldCartesianOrbit ? ((FieldCartesianOrbit)op).equinoctial : null);
    }

    public FieldCartesianOrbit(Field<T> field, CartesianOrbit op) {
        super(new TimeStampedFieldPVCoordinates<T>(field, op.getPVCoordinates()), op.getFrame(), (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(op.getMu()));
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op.isElliptical() ? new FieldEquinoctialOrbit<T>(field, new EquinoctialOrbit(op)) : null;
    }

    public FieldCartesianOrbit(Field<T> field, Orbit op) {
        this(field, new CartesianOrbit(op));
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            if (this.hasDerivatives()) {
                this.equinoctial = new FieldEquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu());
            } else {
                TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
                this.equinoctial = new FieldEquinoctialOrbit(new FieldPVCoordinates(pva.getPosition(), pva.getVelocity()), this.getFrame(), this.getDate(), this.getMu());
            }
        }
    }

    private FieldPVCoordinates<FieldUnivariateDerivative2<T>> getPVDerivatives() {
        TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
        FieldVector3D p = pva.getPosition();
        FieldVector3D v = pva.getVelocity();
        FieldVector3D a = pva.getAcceleration();
        FieldVector3D pG = new FieldVector3D((CalculusFieldElement)new FieldUnivariateDerivative2(p.getX(), v.getX(), a.getX()), (CalculusFieldElement)new FieldUnivariateDerivative2(p.getY(), v.getY(), a.getY()), (CalculusFieldElement)new FieldUnivariateDerivative2(p.getZ(), v.getZ(), a.getZ()));
        FieldVector3D vG = new FieldVector3D((CalculusFieldElement)new FieldUnivariateDerivative2(v.getX(), a.getX(), this.getZero()), (CalculusFieldElement)new FieldUnivariateDerivative2(v.getY(), a.getY(), this.getZero()), (CalculusFieldElement)new FieldUnivariateDerivative2(v.getZ(), a.getZ(), this.getZero()));
        return new FieldPVCoordinates<FieldUnivariateDerivative2<T>>(pG, vG);
    }

    @Override
    public T getA() {
        TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
        CalculusFieldElement r = pva.getPosition().getNorm();
        CalculusFieldElement V2 = pva.getVelocity().getNormSq();
        return (T)((CalculusFieldElement)r.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.negate()).multiply((FieldElement)V2)).divide(this.getMu())).add(2.0))));
    }

    @Override
    public T getADot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 a = r.divide(r.multiply(V2).divide(this.getMu()).subtract(2.0).negate());
            return (T)a.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getE() {
        CalculusFieldElement muA = (CalculusFieldElement)this.getA().multiply(this.getMu());
        if (this.isElliptical()) {
            TimeStampedFieldPVCoordinates pva = this.getPVCoordinates();
            FieldVector3D pvP = pva.getPosition();
            FieldVector3D pvV = pva.getVelocity();
            CalculusFieldElement rV2OnMu = (CalculusFieldElement)((CalculusFieldElement)pvP.getNorm().multiply((FieldElement)pvV.getNormSq())).divide(this.getMu());
            CalculusFieldElement eSE = (CalculusFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide((FieldElement)((CalculusFieldElement)muA.sqrt()));
            CalculusFieldElement eCE = (CalculusFieldElement)rV2OnMu.subtract(1.0);
            return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)eCE.square()).add((FieldElement)((CalculusFieldElement)eSE.square()))).sqrt());
        }
        FieldVector3D pvM = this.getPVCoordinates().getMomentum();
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pvM.getNormSq().divide((FieldElement)muA)).negate()).add(1.0)).sqrt());
    }

    @Override
    public T getEDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldUnivariateDerivative2 r = (FieldUnivariateDerivative2)pv.getPosition().getNorm();
            FieldUnivariateDerivative2 V2 = (FieldUnivariateDerivative2)pv.getVelocity().getNormSq();
            FieldUnivariateDerivative2 rV2OnMu = r.multiply(V2).divide(this.getMu());
            FieldUnivariateDerivative2 a = r.divide(rV2OnMu.negate().add(2.0));
            FieldUnivariateDerivative2 eSE = ((FieldUnivariateDerivative2)FieldVector3D.dotProduct(pv.getPosition(), pv.getVelocity())).divide(a.multiply(this.getMu()).sqrt());
            FieldUnivariateDerivative2 eCE = rV2OnMu.subtract(1.0);
            FieldUnivariateDerivative2 e = eCE.square().add(eSE.square()).sqrt();
            return (T)e.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getI() {
        return (T)FieldVector3D.angle((FieldVector3D)new FieldVector3D(this.getZero(), this.getZero(), this.getOne()), this.getPVCoordinates().getMomentum());
    }

    @Override
    public T getIDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D momentum = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity());
            FieldUnivariateDerivative2 i = (FieldUnivariateDerivative2)FieldVector3D.angle((Vector3D)Vector3D.PLUS_K, (FieldVector3D)momentum);
            return (T)i.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public T getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public T getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public T getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public T getHx() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)((CalculusFieldElement)w.getY().negate()).divide((FieldElement)((CalculusFieldElement)w.getZ().add(1.0))));
    }

    @Override
    public T getHxDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
            }
            FieldUnivariateDerivative2 hx = ((FieldUnivariateDerivative2)w.getY()).negate().divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hx.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getHy() {
        FieldVector3D w = this.getPVCoordinates().getMomentum().normalize();
        double x = w.getX().getReal();
        double y = w.getY().getReal();
        double z = w.getZ().getReal();
        if (x * x + y * y == 0.0 && z < 0.0) {
            return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
        }
        return (T)((CalculusFieldElement)w.getX().divide((FieldElement)((CalculusFieldElement)w.getZ().add(1.0))));
    }

    @Override
    public T getHyDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<FieldUnivariateDerivative2<T>> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((FieldUnivariateDerivative2)w.getX()).getValue().getReal();
            double y = ((FieldUnivariateDerivative2)w.getY()).getValue().getReal();
            double z = ((FieldUnivariateDerivative2)w.getZ()).getValue().getReal();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return (T)((CalculusFieldElement)this.getZero().add(Double.NaN));
            }
            FieldUnivariateDerivative2 hy = ((FieldUnivariateDerivative2)w.getX()).divide(((FieldUnivariateDerivative2)w.getZ()).add(1.0));
            return (T)hy.getDerivative(1);
        }
        return null;
    }

    @Override
    public T getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public T getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public T getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public T getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public T getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public T getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected FieldVector3D<T> initPosition() {
        return this.getPVCoordinates().getPosition();
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((CalculusFieldElement)this.getZero().newInstance(dt));
    }

    @Override
    public FieldCartesianOrbit<T> shiftedBy(T dt) {
        FieldPVCoordinates<T> shiftedPV = this.shiftPV(dt);
        return new FieldCartesianOrbit<T>(shiftedPV, this.getFrame(), this.getDate().shiftedBy((CalculusFieldElement)dt), this.getMu());
    }

    private FieldPVCoordinates<T> shiftPV(T dt) {
        TimeStampedFieldPVCoordinates pvCoordinates = this.getPVCoordinates();
        FieldPVCoordinates<T> shiftedPV = KeplerianMotionCartesianUtility.predictPositionVelocity(dt, pvCoordinates.getPosition(), pvCoordinates.getVelocity(), this.getMu());
        if (this.hasNonKeplerianAcceleration) {
            FieldVector3D pvP = this.getPosition();
            CalculusFieldElement r2 = pvP.getNormSq();
            CalculusFieldElement r = (CalculusFieldElement)r2.sqrt();
            FieldVector3D nonKeplerianAcceleration = new FieldVector3D(this.getOne(), this.getPVCoordinates().getAcceleration(), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r.multiply((FieldElement)r2)).reciprocal()).multiply(this.getMu()), pvP);
            FieldVector3D<T> shiftedP = shiftedPV.getPosition();
            FieldVector3D<T> shiftedV = shiftedPV.getVelocity();
            FieldVector3D fixedP = new FieldVector3D(this.getOne(), shiftedP, (CalculusFieldElement)((CalculusFieldElement)dt.square()).multiply(0.5), nonKeplerianAcceleration);
            CalculusFieldElement fixedR2 = fixedP.getNormSq();
            CalculusFieldElement fixedR = (CalculusFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.getOne(), shiftedV, dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fixedR.multiply((FieldElement)fixedR2)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)this.getMu().negate())), shiftedP, this.getOne(), nonKeplerianAcceleration);
            return new FieldPVCoordinates(fixedP, fixedV, fixedA);
        }
        return shiftedPV;
    }

    private T[][] create6x6Identity() {
        CalculusFieldElement[][] identity = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)6);
        for (int i = 0; i < 6; ++i) {
            Arrays.fill(identity[i], this.getZero());
            identity[i][i] = this.getOne();
        }
        return identity;
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        return this.create6x6Identity();
    }

    @Override
    public void addKeplerContribution(PositionAngleType type, T gm, T[] pDot) {
        TimeStampedFieldPVCoordinates pv = this.getPVCoordinates();
        FieldVector3D velocity = pv.getVelocity();
        pDot[0] = (CalculusFieldElement)pDot[0].add((FieldElement)velocity.getX());
        pDot[1] = (CalculusFieldElement)pDot[1].add((FieldElement)velocity.getY());
        pDot[2] = (CalculusFieldElement)pDot[2].add((FieldElement)velocity.getZ());
        FieldVector3D position = pv.getPosition();
        CalculusFieldElement r2 = position.getNormSq();
        CalculusFieldElement coeff = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)r2.multiply((FieldElement)((CalculusFieldElement)r2.sqrt()))).reciprocal()).negate()).multiply(gm);
        pDot[3] = (CalculusFieldElement)pDot[3].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getX())));
        pDot[4] = (CalculusFieldElement)pDot[4].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getY())));
        pDot[5] = (CalculusFieldElement)pDot[5].add((FieldElement)((CalculusFieldElement)coeff.multiply((FieldElement)position.getZ())));
    }

    public String toString() {
        String comma = ", ";
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        return "Cartesian parameters: {P(" + p.getX() + ", " + p.getY() + ", " + p.getZ() + "), V(" + v.getX() + ", " + v.getY() + ", " + v.getZ() + ")}";
    }

    @Override
    public CartesianOrbit toOrbit() {
        PVCoordinates pv = this.getPVCoordinates().toPVCoordinates();
        AbsoluteDate date = this.getPVCoordinates().getDate().toAbsoluteDate();
        if (this.hasDerivatives()) {
            return new CartesianOrbit(pv, this.getFrame(), date, this.getMu().getReal());
        }
        return new CartesianOrbit(new PVCoordinates(pv.getPosition(), pv.getVelocity()), this.getFrame(), date, this.getMu().getReal());
    }
}

