/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public class EquinoctialLongitudeArgumentUtility {
    private static final double TOLERANCE_CONVERGENCE = 1.0E-11;
    private static final int MAXIMUM_ITERATION = 50;

    private EquinoctialLongitudeArgumentUtility() {
    }

    public static double eccentricToTrue(double ex, double ey, double lE) {
        double epsilon = EquinoctialLongitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        SinCos scLE = FastMath.sinCos((double)lE);
        double num = ex * scLE.sin() - ey * scLE.cos();
        double den = epsilon + 1.0 - ex * scLE.cos() - ey * scLE.sin();
        return lE + EquinoctialLongitudeArgumentUtility.eccentricAndTrueAtan(num, den);
    }

    public static double trueToEccentric(double ex, double ey, double lV) {
        double epsilon = EquinoctialLongitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        SinCos scLv = FastMath.sinCos((double)lV);
        double num = ey * scLv.cos() - ex * scLv.sin();
        double den = epsilon + 1.0 + ex * scLv.cos() + ey * scLv.sin();
        return lV + EquinoctialLongitudeArgumentUtility.eccentricAndTrueAtan(num, den);
    }

    private static double eccentricAndTrueEpsilon(double ex, double ey) {
        return FastMath.sqrt((double)(1.0 - ex * ex - ey * ey));
    }

    private static double eccentricAndTrueAtan(double num, double den) {
        return 2.0 * FastMath.atan((double)(num / den));
    }

    public static double meanToEccentric(double ex, double ey, double lM) {
        boolean hasConverged;
        double lE = lM;
        double lEmlM = 0.0;
        int iter = 0;
        do {
            SinCos scLE = FastMath.sinCos((double)lE);
            double f2 = ex * scLE.sin() - ey * scLE.cos();
            double f1 = 1.0 - ex * scLE.cos() - ey * scLE.sin();
            double f0 = lEmlM - f2;
            double f12 = 2.0 * f1;
            double shift = f0 * f12 / (f1 * f12 - f0 * f2);
            lE = lM + (lEmlM -= shift);
            boolean bl = hasConverged = FastMath.abs((double)shift) <= 1.0E-11;
        } while (++iter < 50 && !hasConverged);
        if (!hasConverged) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECCENTRIC_LONGITUDE_ARGUMENT, iter);
        }
        return lE;
    }

    public static double eccentricToMean(double ex, double ey, double lE) {
        SinCos scLE = FastMath.sinCos((double)lE);
        return lE - ex * scLE.sin() + ey * scLE.cos();
    }

    public static double trueToMean(double ex, double ey, double lV) {
        double alphaE = EquinoctialLongitudeArgumentUtility.trueToEccentric(ex, ey, lV);
        return EquinoctialLongitudeArgumentUtility.eccentricToMean(ex, ey, alphaE);
    }

    public static double meanToTrue(double ex, double ey, double lM) {
        double alphaE = EquinoctialLongitudeArgumentUtility.meanToEccentric(ex, ey, lM);
        return EquinoctialLongitudeArgumentUtility.eccentricToTrue(ex, ey, alphaE);
    }

    public static double convertL(PositionAngleType oldType, double l, double ex, double ey, PositionAngleType newType) {
        if (oldType == newType) {
            return l;
        }
        switch (newType) {
            case ECCENTRIC: {
                if (oldType == PositionAngleType.MEAN) {
                    return EquinoctialLongitudeArgumentUtility.meanToEccentric(ex, ey, l);
                }
                return EquinoctialLongitudeArgumentUtility.trueToEccentric(ex, ey, l);
            }
            case MEAN: {
                if (oldType == PositionAngleType.TRUE) {
                    return EquinoctialLongitudeArgumentUtility.trueToMean(ex, ey, l);
                }
                return EquinoctialLongitudeArgumentUtility.eccentricToMean(ex, ey, l);
            }
            case TRUE: {
                if (oldType == PositionAngleType.MEAN) {
                    return EquinoctialLongitudeArgumentUtility.meanToTrue(ex, ey, l);
                }
                return EquinoctialLongitudeArgumentUtility.eccentricToTrue(ex, ey, l);
            }
        }
        throw new OrekitInternalError(null);
    }
}

