/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.PositionAngleType;

public class CircularLatitudeArgumentUtility {
    private static final double TOLERANCE_CONVERGENCE = 1.0E-11;
    private static final int MAXIMUM_ITERATION = 50;

    private CircularLatitudeArgumentUtility() {
    }

    public static double eccentricToTrue(double ex, double ey, double alphaE) {
        double epsilon = CircularLatitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        SinCos scAlphaE = FastMath.sinCos((double)alphaE);
        double num = ex * scAlphaE.sin() - ey * scAlphaE.cos();
        double den = epsilon + 1.0 - ex * scAlphaE.cos() - ey * scAlphaE.sin();
        return alphaE + CircularLatitudeArgumentUtility.eccentricAndTrueAtan(num, den);
    }

    public static double trueToEccentric(double ex, double ey, double alphaV) {
        double epsilon = CircularLatitudeArgumentUtility.eccentricAndTrueEpsilon(ex, ey);
        SinCos scAlphaV = FastMath.sinCos((double)alphaV);
        double num = ey * scAlphaV.cos() - ex * scAlphaV.sin();
        double den = epsilon + 1.0 + ex * scAlphaV.cos() + ey * scAlphaV.sin();
        return alphaV + CircularLatitudeArgumentUtility.eccentricAndTrueAtan(num, den);
    }

    private static double eccentricAndTrueEpsilon(double ex, double ey) {
        return FastMath.sqrt((double)(1.0 - ex * ex - ey * ey));
    }

    private static double eccentricAndTrueAtan(double num, double den) {
        return 2.0 * FastMath.atan((double)(num / den));
    }

    public static double meanToEccentric(double ex, double ey, double alphaM) {
        boolean hasConverged;
        double alphaE = alphaM;
        double alphaEMalphaM = 0.0;
        int iter = 0;
        do {
            SinCos scAlphaE = FastMath.sinCos((double)alphaE);
            double f2 = ex * scAlphaE.sin() - ey * scAlphaE.cos();
            double f1 = 1.0 - ex * scAlphaE.cos() - ey * scAlphaE.sin();
            double f0 = alphaEMalphaM - f2;
            double f12 = 2.0 * f1;
            double shift = f0 * f12 / (f1 * f12 - f0 * f2);
            alphaE = alphaM + (alphaEMalphaM -= shift);
            boolean bl = hasConverged = FastMath.abs((double)shift) <= 1.0E-11;
        } while (++iter < 50 && !hasConverged);
        if (!hasConverged) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_ECCENTRIC_LATITUDE_ARGUMENT, iter);
        }
        return alphaE;
    }

    public static double eccentricToMean(double ex, double ey, double alphaE) {
        SinCos scAlphaE = FastMath.sinCos((double)alphaE);
        return alphaE + (ey * scAlphaE.cos() - ex * scAlphaE.sin());
    }

    public static double trueToMean(double ex, double ey, double alphaV) {
        double alphaE = CircularLatitudeArgumentUtility.trueToEccentric(ex, ey, alphaV);
        return CircularLatitudeArgumentUtility.eccentricToMean(ex, ey, alphaE);
    }

    public static double meanToTrue(double ex, double ey, double alphaM) {
        double alphaE = CircularLatitudeArgumentUtility.meanToEccentric(ex, ey, alphaM);
        return CircularLatitudeArgumentUtility.eccentricToTrue(ex, ey, alphaE);
    }

    public static double convertAlpha(PositionAngleType oldType, double alpha, double ex, double ey, PositionAngleType newType) {
        if (oldType == newType) {
            return alpha;
        }
        switch (newType) {
            case ECCENTRIC: {
                if (oldType == PositionAngleType.MEAN) {
                    return CircularLatitudeArgumentUtility.meanToEccentric(ex, ey, alpha);
                }
                return CircularLatitudeArgumentUtility.trueToEccentric(ex, ey, alpha);
            }
            case MEAN: {
                if (oldType == PositionAngleType.TRUE) {
                    return CircularLatitudeArgumentUtility.trueToMean(ex, ey, alpha);
                }
                return CircularLatitudeArgumentUtility.eccentricToMean(ex, ey, alpha);
            }
            case TRUE: {
                if (oldType == PositionAngleType.MEAN) {
                    return CircularLatitudeArgumentUtility.meanToTrue(ex, ey, alpha);
                }
                return CircularLatitudeArgumentUtility.eccentricToTrue(ex, ey, alpha);
            }
        }
        throw new OrekitInternalError(null);
    }
}

