/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.UnivariateDerivative2;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianMotionCartesianUtility;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngleType;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CartesianOrbit
extends Orbit {
    private static final long serialVersionUID = 20170414L;
    private static final double[][] SIX_BY_SIX_IDENTITY = MatrixUtils.createRealIdentityMatrix((int)6).getData();
    private final transient boolean hasNonKeplerianAcceleration;
    private transient EquinoctialOrbit equinoctial;

    public CartesianOrbit(TimeStampedPVCoordinates pvaCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.hasNonKeplerianAcceleration = CartesianOrbit.hasNonKeplerianAcceleration(pvaCoordinates, mu);
        this.equinoctial = null;
    }

    public CartesianOrbit(PVCoordinates pvaCoordinates, Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        this(new TimeStampedPVCoordinates(date, pvaCoordinates), frame, mu);
    }

    public CartesianOrbit(Orbit op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.hasNonKeplerianAcceleration = op.hasDerivatives();
        this.equinoctial = op instanceof EquinoctialOrbit ? (EquinoctialOrbit)op : (op instanceof CartesianOrbit ? ((CartesianOrbit)op).equinoctial : null);
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = this.hasDerivatives() ? new EquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu()) : new EquinoctialOrbit(new PVCoordinates(this.getPosition(), this.getPVCoordinates().getVelocity()), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    private FieldPVCoordinates<UnivariateDerivative2> getPVDerivatives() {
        TimeStampedPVCoordinates pva = this.getPVCoordinates();
        Vector3D p = pva.getPosition();
        Vector3D v = pva.getVelocity();
        Vector3D a = pva.getAcceleration();
        FieldVector3D pG = new FieldVector3D((CalculusFieldElement)new UnivariateDerivative2(p.getX(), v.getX(), a.getX()), (CalculusFieldElement)new UnivariateDerivative2(p.getY(), v.getY(), a.getY()), (CalculusFieldElement)new UnivariateDerivative2(p.getZ(), v.getZ(), a.getZ()));
        FieldVector3D vG = new FieldVector3D((CalculusFieldElement)new UnivariateDerivative2(v.getX(), a.getX(), 0.0), (CalculusFieldElement)new UnivariateDerivative2(v.getY(), a.getY(), 0.0), (CalculusFieldElement)new UnivariateDerivative2(v.getZ(), a.getZ(), 0.0));
        return new FieldPVCoordinates<UnivariateDerivative2>(pG, vG);
    }

    @Override
    public double getA() {
        double r = this.getPosition().getNorm();
        double V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return r / (2.0 - r * V2 / this.getMu());
    }

    @Override
    public double getADot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<UnivariateDerivative2> pv = this.getPVDerivatives();
            UnivariateDerivative2 r = (UnivariateDerivative2)pv.getPosition().getNorm();
            UnivariateDerivative2 V2 = (UnivariateDerivative2)pv.getVelocity().getNormSq();
            UnivariateDerivative2 a = r.divide(((UnivariateDerivative2)r.multiply(V2).divide(this.getMu()).subtract(2.0)).negate());
            return a.getDerivative(1);
        }
        return Double.NaN;
    }

    @Override
    public double getE() {
        double muA = this.getMu() * this.getA();
        if (this.isElliptical()) {
            Vector3D pvP = this.getPosition();
            Vector3D pvV = this.getPVCoordinates().getVelocity();
            double rV2OnMu = pvP.getNorm() * pvV.getNormSq() / this.getMu();
            double eSE = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)muA);
            double eCE = rV2OnMu - 1.0;
            return FastMath.sqrt((double)(eCE * eCE + eSE * eSE));
        }
        Vector3D pvM = this.getPVCoordinates().getMomentum();
        return FastMath.sqrt((double)(1.0 - pvM.getNormSq() / muA));
    }

    @Override
    public double getEDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<UnivariateDerivative2> pv = this.getPVDerivatives();
            FieldVector3D<UnivariateDerivative2> pvP = pv.getPosition();
            FieldVector3D<UnivariateDerivative2> pvV = pv.getVelocity();
            UnivariateDerivative2 r = (UnivariateDerivative2)pvP.getNorm();
            UnivariateDerivative2 V2 = (UnivariateDerivative2)pvV.getNormSq();
            UnivariateDerivative2 rV2OnMu = r.multiply(V2).divide(this.getMu());
            UnivariateDerivative2 a = r.divide((UnivariateDerivative2)rV2OnMu.negate().add(2.0));
            UnivariateDerivative2 eSE = ((UnivariateDerivative2)FieldVector3D.dotProduct(pvP, pvV)).divide(a.multiply(this.getMu()).sqrt());
            UnivariateDerivative2 eCE = (UnivariateDerivative2)rV2OnMu.subtract(1.0);
            UnivariateDerivative2 e = eCE.multiply(eCE).add(eSE.multiply(eSE)).sqrt();
            return e.getDerivative(1);
        }
        return Double.NaN;
    }

    @Override
    public double getI() {
        return Vector3D.angle((Vector3D)Vector3D.PLUS_K, (Vector3D)this.getPVCoordinates().getMomentum());
    }

    @Override
    public double getIDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<UnivariateDerivative2> pv = this.getPVDerivatives();
            FieldVector3D momentum = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity());
            UnivariateDerivative2 i = (UnivariateDerivative2)FieldVector3D.angle((Vector3D)Vector3D.PLUS_K, (FieldVector3D)momentum);
            return i.getDerivative(1);
        }
        return Double.NaN;
    }

    @Override
    public double getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public double getEquinoctialExDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialExDot();
    }

    @Override
    public double getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public double getEquinoctialEyDot() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEyDot();
    }

    @Override
    public double getHx() {
        Vector3D w = (Vector3D)this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return -w.getY() / (1.0 + w.getZ());
    }

    @Override
    public double getHxDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<UnivariateDerivative2> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((UnivariateDerivative2)w.getX()).getValue();
            double y = ((UnivariateDerivative2)w.getY()).getValue();
            double z = ((UnivariateDerivative2)w.getZ()).getValue();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return Double.NaN;
            }
            UnivariateDerivative2 hx = ((UnivariateDerivative2)w.getY()).negate().divide((UnivariateDerivative2)((UnivariateDerivative2)w.getZ()).add(1.0));
            return hx.getDerivative(1);
        }
        return Double.NaN;
    }

    @Override
    public double getHy() {
        Vector3D w = (Vector3D)this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return w.getX() / (1.0 + w.getZ());
    }

    @Override
    public double getHyDot() {
        if (this.hasDerivatives()) {
            FieldPVCoordinates<UnivariateDerivative2> pv = this.getPVDerivatives();
            FieldVector3D w = FieldVector3D.crossProduct(pv.getPosition(), pv.getVelocity()).normalize();
            double x = ((UnivariateDerivative2)w.getX()).getValue();
            double y = ((UnivariateDerivative2)w.getY()).getValue();
            double z = ((UnivariateDerivative2)w.getZ()).getValue();
            if (x * x + y * y == 0.0 && z < 0.0) {
                return Double.NaN;
            }
            UnivariateDerivative2 hy = ((UnivariateDerivative2)w.getX()).divide((UnivariateDerivative2)((UnivariateDerivative2)w.getZ()).add(1.0));
            return hy.getDerivative(1);
        }
        return Double.NaN;
    }

    @Override
    public double getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public double getLvDot() {
        this.initEquinoctial();
        return this.equinoctial.getLvDot();
    }

    @Override
    public double getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public double getLEDot() {
        this.initEquinoctial();
        return this.equinoctial.getLEDot();
    }

    @Override
    public double getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    public double getLMDot() {
        this.initEquinoctial();
        return this.equinoctial.getLMDot();
    }

    @Override
    public boolean hasDerivatives() {
        return this.hasNonKeplerianAcceleration;
    }

    @Override
    protected Vector3D initPosition() {
        return this.getPVCoordinates().getPosition();
    }

    @Override
    protected TimeStampedPVCoordinates initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public CartesianOrbit shiftedBy(double dt) {
        PVCoordinates shiftedPV = this.shiftPV(dt);
        return new CartesianOrbit(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    private PVCoordinates shiftPV(double dt) {
        Vector3D pvP = this.getPosition();
        PVCoordinates shiftedPV = KeplerianMotionCartesianUtility.predictPositionVelocity(dt, pvP, this.getPVCoordinates().getVelocity(), this.getMu());
        if (this.hasNonKeplerianAcceleration) {
            double r2 = pvP.getNormSq();
            double r = FastMath.sqrt((double)r2);
            Vector3D nonKeplerianAcceleration = new Vector3D(1.0, this.getPVCoordinates().getAcceleration(), this.getMu() / (r2 * r), pvP);
            Vector3D shiftedP = shiftedPV.getPosition();
            Vector3D shiftedV = shiftedPV.getVelocity();
            Vector3D fixedP = new Vector3D(1.0, shiftedP, 0.5 * dt * dt, nonKeplerianAcceleration);
            double fixedR2 = fixedP.getNormSq();
            double fixedR = FastMath.sqrt((double)fixedR2);
            Vector3D fixedV = new Vector3D(1.0, shiftedV, dt, nonKeplerianAcceleration);
            Vector3D fixedA = new Vector3D(-this.getMu() / (fixedR2 * fixedR), shiftedP, 1.0, nonKeplerianAcceleration);
            return new PVCoordinates(fixedP, fixedV, fixedA);
        }
        return shiftedPV;
    }

    @Override
    protected double[][] computeJacobianMeanWrtCartesian() {
        return SIX_BY_SIX_IDENTITY;
    }

    @Override
    protected double[][] computeJacobianEccentricWrtCartesian() {
        return SIX_BY_SIX_IDENTITY;
    }

    @Override
    protected double[][] computeJacobianTrueWrtCartesian() {
        return SIX_BY_SIX_IDENTITY;
    }

    @Override
    public void addKeplerContribution(PositionAngleType type, double gm, double[] pDot) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D velocity = pv.getVelocity();
        pDot[0] = pDot[0] + velocity.getX();
        pDot[1] = pDot[1] + velocity.getY();
        pDot[2] = pDot[2] + velocity.getZ();
        Vector3D position = pv.getPosition();
        double r2 = position.getNormSq();
        double coeff = -gm / (r2 * FastMath.sqrt((double)r2));
        pDot[3] = pDot[3] + coeff * position.getX();
        pDot[4] = pDot[4] + coeff * position.getY();
        pDot[5] = pDot[5] + coeff * position.getZ();
    }

    public String toString() {
        String comma = ", ";
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D p = pv.getPosition();
        Vector3D v = pv.getVelocity();
        return "Cartesian parameters: {P(" + p.getX() + ", " + p.getY() + ", " + p.getZ() + "), V(" + v.getX() + ", " + v.getY() + ", " + v.getZ() + ")}";
    }

    @DefaultDataContext
    private Object writeReplace() {
        return new DTO(this);
    }

    @DefaultDataContext
    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20170414L;
        private double[] d;
        private final Frame frame;

        private DTO(CartesianOrbit orbit) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            AbsoluteDate j2000Epoch = DataContext.getDefault().getTimeScales().getJ2000Epoch();
            double epoch = FastMath.floor((double)pv.getDate().durationFrom(j2000Epoch));
            double offset = pv.getDate().durationFrom(j2000Epoch.shiftedBy(epoch));
            this.d = orbit.hasDerivatives() ? new double[]{epoch, offset, orbit.getMu(), pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()} : new double[]{epoch, offset, orbit.getMu(), pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ()};
            this.frame = orbit.getFrame();
        }

        private Object readResolve() {
            AbsoluteDate j2000Epoch = DataContext.getDefault().getTimeScales().getJ2000Epoch();
            if (this.d.length >= 12) {
                return new CartesianOrbit(new TimeStampedPVCoordinates(j2000Epoch.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8]), new Vector3D(this.d[9], this.d[10], this.d[11])), this.frame, this.d[2]);
            }
            return new CartesianOrbit(new TimeStampedPVCoordinates(j2000Epoch.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8])), this.frame, this.d[2]);
        }
    }
}

