/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.nonstiff.DormandPrince853Integrator;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.FrameAlignedProvider;
import org.orekit.bodies.CR3BPSystem;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.orbits.LibrationOrbitType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.HaloXZPlaneCrossingDetector;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.cr3bp.CR3BPForceModel;
import org.orekit.propagation.numerical.cr3bp.STMEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.AbsolutePVCoordinates;
import org.orekit.utils.PVCoordinates;

public class CR3BPDifferentialCorrection {
    private static final int MAX_ITER = 30;
    private static final double CROSSING_MAX_CHECK = 3600.0;
    private static final double CROSSING_TOLERANCE = 1.0E-10;
    private static final AbsoluteDate START_DATE = AbsoluteDate.ARBITRARY_EPOCH;
    private boolean cross;
    private final PVCoordinates firstGuess;
    private final CR3BPSystem syst;
    private final double orbitalPeriodApprox;
    private double orbitalPeriod;

    public CR3BPDifferentialCorrection(PVCoordinates firstguess, CR3BPSystem syst, double orbitalPeriod) {
        this.firstGuess = firstguess;
        this.syst = syst;
        this.orbitalPeriodApprox = orbitalPeriod;
    }

    private NumericalPropagator buildPropagator() {
        double minStep = 1.0E-12;
        double maxstep = 0.001;
        double positionTolerance = 1.0E-5;
        double velocityTolerance = 1.0E-5;
        double massTolerance = 1.0E-6;
        double[] vecAbsoluteTolerances = new double[]{1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-5, 1.0E-6};
        double[] vecRelativeTolerances = new double[vecAbsoluteTolerances.length];
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(1.0E-12, 0.001, vecAbsoluteTolerances, vecRelativeTolerances);
        NumericalPropagator propagator = new NumericalPropagator((ODEIntegrator)integrator, new FrameAlignedProvider(Rotation.IDENTITY, this.syst.getRotatingFrame()));
        propagator.setOrbitType(null);
        propagator.setIgnoreCentralAttraction(true);
        propagator.addForceModel(new CR3BPForceModel(this.syst));
        propagator.addEventDetector((EventDetector)new HaloXZPlaneCrossingDetector(3600.0, 1.0E-10).withHandler((state, detector, increasing) -> {
            this.cross = true;
            return Action.STOP;
        }));
        return propagator;
    }

    public PVCoordinates compute(LibrationOrbitType type) {
        return type == LibrationOrbitType.HALO ? this.computeHalo() : this.computeLyapunov();
    }

    private PVCoordinates computeHalo() {
        PVCoordinates pvHalo = this.firstGuess;
        for (int iHalo = 0; iHalo < 30; ++iHalo) {
            AbsolutePVCoordinates initialAbsPVHalo = new AbsolutePVCoordinates(this.syst.getRotatingFrame(), START_DATE, pvHalo);
            SpacecraftState initialStateHalo = new SpacecraftState(initialAbsPVHalo);
            NumericalPropagator propagator = this.buildPropagator();
            STMEquations stm = new STMEquations(this.syst);
            propagator.addAdditionalDerivativesProvider(stm);
            propagator.setInitialState(stm.setInitialPhi(initialStateHalo));
            this.cross = false;
            SpacecraftState finalStateHalo = propagator.propagate(START_DATE.shiftedBy(this.orbitalPeriodApprox));
            if (!this.cross) {
                throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_NOT_CROSSING_XZPLANE, new Object[0]);
            }
            RealMatrix phiHalo = stm.getStateTransitionMatrix(finalStateHalo);
            double dvxf = -finalStateHalo.getPVCoordinates().getVelocity().getX();
            double dvzf = -finalStateHalo.getPVCoordinates().getVelocity().getZ();
            this.orbitalPeriod = 2.0 * finalStateHalo.getDate().durationFrom(START_DATE);
            if (FastMath.abs((double)dvxf) <= 1.0E-8 && FastMath.abs((double)dvzf) <= 1.0E-8) break;
            double vy = finalStateHalo.getPVCoordinates().getVelocity().getY();
            Vector3D acc = finalStateHalo.getPVCoordinates().getAcceleration();
            double accx = acc.getX();
            double accz = acc.getZ();
            double a11 = phiHalo.getEntry(3, 0) - accx * phiHalo.getEntry(1, 0) / vy;
            double a12 = phiHalo.getEntry(3, 4) - accx * phiHalo.getEntry(1, 4) / vy;
            double a21 = phiHalo.getEntry(5, 0) - accz * phiHalo.getEntry(1, 0) / vy;
            double a22 = phiHalo.getEntry(5, 4) - accz * phiHalo.getEntry(1, 4) / vy;
            double aDet = a11 * a22 - a21 * a12;
            double deltax0 = (a22 * dvxf - a12 * dvzf) / aDet;
            double deltavy0 = (-a21 * dvxf + a11 * dvzf) / aDet;
            double newx = pvHalo.getPosition().getX() + deltax0;
            double newvy = pvHalo.getVelocity().getY() + deltavy0;
            pvHalo = new PVCoordinates(new Vector3D(newx, pvHalo.getPosition().getY(), pvHalo.getPosition().getZ()), new Vector3D(pvHalo.getVelocity().getX(), newvy, pvHalo.getVelocity().getZ()));
        }
        return pvHalo;
    }

    public PVCoordinates computeLyapunov() {
        PVCoordinates pvLyapunov = this.firstGuess;
        for (int iLyapunov = 0; iLyapunov < 30; ++iLyapunov) {
            AbsolutePVCoordinates initialAbsPVLyapunov = new AbsolutePVCoordinates(this.syst.getRotatingFrame(), START_DATE, pvLyapunov);
            SpacecraftState initialStateLyapunov = new SpacecraftState(initialAbsPVLyapunov);
            NumericalPropagator propagator = this.buildPropagator();
            STMEquations stm = new STMEquations(this.syst);
            propagator.addAdditionalDerivativesProvider(stm);
            propagator.setInitialState(stm.setInitialPhi(initialStateLyapunov));
            this.cross = false;
            SpacecraftState finalStateLyapunov = propagator.propagate(START_DATE.shiftedBy(this.orbitalPeriodApprox));
            if (!this.cross) {
                throw new OrekitException((Localizable)OrekitMessages.TRAJECTORY_NOT_CROSSING_XZPLANE, new Object[0]);
            }
            RealMatrix phi = stm.getStateTransitionMatrix(finalStateLyapunov);
            double dvxf = -finalStateLyapunov.getPVCoordinates().getVelocity().getX();
            this.orbitalPeriod = 2.0 * finalStateLyapunov.getDate().durationFrom(START_DATE);
            if (FastMath.abs((double)dvxf) <= 1.0E-14) break;
            double vy = finalStateLyapunov.getPVCoordinates().getVelocity().getY();
            double accy = finalStateLyapunov.getPVCoordinates().getAcceleration().getY();
            double deltavy0 = dvxf / (phi.getEntry(3, 4) - accy * phi.getEntry(1, 4) / vy);
            double newvy = pvLyapunov.getVelocity().getY() + deltavy0;
            pvLyapunov = new PVCoordinates(new Vector3D(pvLyapunov.getPosition().getX(), pvLyapunov.getPosition().getY(), 0.0), new Vector3D(pvLyapunov.getVelocity().getX(), newvy, 0.0));
        }
        return pvLyapunov;
    }

    public double getOrbitalPeriod() {
        return this.orbitalPeriod;
    }
}

