/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.ArrayList;
import java.util.Collection;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.AbstractTimeInterpolator;

public abstract class AbstractOrbitInterpolator
extends AbstractTimeInterpolator<Orbit> {
    private final Frame outputInertialFrame;

    public AbstractOrbitInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputInertialFrame) {
        super(interpolationPoints, extrapolationThreshold);
        this.checkFrameIsInertial(outputInertialFrame);
        this.outputInertialFrame = outputInertialFrame;
    }

    public static void checkOrbitsConsistency(Collection<Orbit> sample) {
        ArrayList<Orbit> sampleList = new ArrayList<Orbit>(sample);
        for (int i = 0; i < sampleList.size() - 1; ++i) {
            Orbit currentOrbit = (Orbit)sampleList.get(i);
            Orbit nextOrbit = (Orbit)sampleList.get(i + 1);
            if (currentOrbit.getMu() == nextOrbit.getMu()) continue;
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBITS_MUS_MISMATCH, currentOrbit.getMu(), nextOrbit.getMu());
        }
    }

    @Override
    public Orbit interpolate(AbsoluteDate interpolationDate, Collection<Orbit> sample) {
        AbstractOrbitInterpolator.checkOrbitsConsistency(sample);
        return super.interpolate(interpolationDate, sample);
    }

    public Frame getOutputInertialFrame() {
        return this.outputInertialFrame;
    }

    private void checkFrameIsInertial(Frame frame) {
        if (!frame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, frame.getName());
        }
    }
}

