/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.CalculusFieldElement;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.AbstractOrbitInterpolator;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.time.AbstractFieldTimeInterpolator;
import org.orekit.time.FieldAbsoluteDate;

public abstract class AbstractFieldOrbitInterpolator<KK extends CalculusFieldElement<KK>>
extends AbstractFieldTimeInterpolator<FieldOrbit<KK>, KK> {
    private final Frame outputInertialFrame;

    public AbstractFieldOrbitInterpolator(int interpolationPoints, double extrapolationThreshold, Frame outputInertialFrame) {
        super(interpolationPoints, extrapolationThreshold);
        this.checkFrameIsInertial(outputInertialFrame);
        this.outputInertialFrame = outputInertialFrame;
    }

    @Override
    public FieldOrbit<KK> interpolate(FieldAbsoluteDate<KK> interpolationDate, Collection<FieldOrbit<KK>> sample) {
        List<Orbit> orbits = sample.stream().map(FieldOrbit::toOrbit).collect(Collectors.toList());
        AbstractOrbitInterpolator.checkOrbitsConsistency(orbits);
        return super.interpolate(interpolationDate, sample);
    }

    public Frame getOutputInertialFrame() {
        return this.outputInertialFrame;
    }

    private void checkFrameIsInertial(Frame frame) {
        if (!frame.isPseudoInertial()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, frame.getName());
        }
    }
}

