/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather.water;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.water.WaterVaporPressureProvider;

public class Wang1988
implements WaterVaporPressureProvider {
    private static final double[] E_COEFFICIENTS = new double[]{-37.2465, 0.213166, -2.56908E-4};
    private static final PolynomialFunction E_POLYNOMIAL = new PolynomialFunction(E_COEFFICIENTS);

    @Override
    public double waterVaporPressure(double p, double t, double rh) {
        return TroposphericModelUtils.HECTO_PASCAL.toSI(rh * FastMath.exp((double)E_POLYNOMIAL.value(t)));
    }

    @Override
    public <T extends CalculusFieldElement<T>> T waterVaporPressure(T p, T t, T rh) {
        return (T)TroposphericModelUtils.HECTO_PASCAL.toSI((CalculusFieldElement)rh.multiply((FieldElement)FastMath.exp((CalculusFieldElement)E_POLYNOMIAL.value(t))));
    }
}

