/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather.water;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.interpolation.SplineInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.weather.water.WaterVaporPressureProvider;

public class NbsNrcSteamTable
implements WaterVaporPressureProvider {
    private static final double CELSIUS = 273.15;
    private static final double MIN_T = 273.15999999999997;
    private static final PolynomialSplineFunction MODEL;

    @Override
    public double waterVaporPressure(double p, double t, double rh) {
        return MODEL.value(FastMath.max((double)t, (double)273.15999999999997)) * rh;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T waterVaporPressure(T p, T t, T rh) {
        return (T)((CalculusFieldElement)MODEL.value(FastMath.max(t, (double)273.15999999999997)).multiply(rh));
    }

    static {
        double[] pressure = new double[]{611.73, 657.16, 706.05, 758.13, 813.59, 872.6, 935.37, 1002.09, 1072.97, 1148.25, 1228.1, 1312.9, 1402.7, 1497.9, 1598.8, 1705.6, 1818.5, 1938.0, 2064.4, 2197.9, 2338.8, 2487.7, 2644.7, 2810.4, 2985.0, 3169.1, 3362.9, 3567.0, 3781.8, 4007.8, 4245.5, 4495.3, 4757.8, 5033.5, 5322.9, 5626.7, 5945.4, 6279.5, 6629.8, 6996.9, 7381.4, 7784.0, 8205.4, 8646.4, 9107.6, 9589.8, 10093.8, 10620.5, 11170.6, 11744.9, 12344.0, 12970.0, 13623.0, 14303.0, 15012.0, 15752.0, 16522.0, 17324.0, 18159.0, 19028.0, 19932.0, 20873.0, 21851.0, 22868.0, 23925.0, 25022.0, 26163.0, 27347.0, 28576.0, 29852.0, 31176.0, 32549.0, 33972.0, 35448.0, 36978.0, 38563.0, 40205.0, 41905.0, 43665.0, 45487.0, 47373.0, 49324.0, 51342.0, 53428.0, 55585.0, 57815.0, 60119.0, 62499.0, 64958.0, 67496.0, 70117.0, 72823.0, 75614.0, 78495.0, 81465.0, 84529.0, 87688.0, 90945.0, 94301.0, 97759.0};
        double[] temperature = new double[pressure.length];
        for (int i = 0; i < temperature.length; ++i) {
            temperature[i] = i == 0 ? 273.15999999999997 : 273.15 + (double)i;
        }
        MODEL = new SplineInterpolator().interpolate(temperature, pressure);
    }
}

