/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather.water;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.water.WaterVaporPressureProvider;

public class CIPM2007
implements WaterVaporPressureProvider {
    private static final double L_P2 = 1.2378847E-5;
    private static final double L_P1 = -0.019121316;
    private static final double L_0 = 33.93711047;
    private static final double L_M1 = -6343.1645;
    private static final double CELSIUS = 273.15;
    private static final double F_0 = 1.00062;
    private static final double F_P = 3.14E-6;
    private static final double F_T2 = 5.6E-7;

    @Override
    public double waterVaporPressure(double p, double t, double rh) {
        double psv = FastMath.exp((double)(t * (t * 1.2378847E-5 + -0.019121316) + 33.93711047 + -6343.1645 / t));
        double tC = t - 273.15;
        double fw = TroposphericModelUtils.HECTO_PASCAL.fromSI(p) * 3.14E-6 + tC * tC * 5.6E-7 + 1.00062;
        return rh * fw * psv;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T waterVaporPressure(T p, T t, T rh) {
        CalculusFieldElement psv = FastMath.exp((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(1.2378847E-5)).add(-0.019121316)))).add(33.93711047)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)t.reciprocal()).multiply(-6343.1645)))));
        CalculusFieldElement tC = (CalculusFieldElement)t.subtract(273.15);
        CalculusFieldElement fw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)TroposphericModelUtils.HECTO_PASCAL.fromSI(p).multiply(3.14E-6)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)tC.multiply((FieldElement)tC)).multiply(5.6E-7)))).add(1.00062);
        return (T)((CalculusFieldElement)((CalculusFieldElement)rh.multiply((FieldElement)fw)).multiply((FieldElement)psv));
    }
}

