/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.util.HashMap;
import java.util.Map;

enum SeasonalModelType {
    PRESSURE("p"),
    TEMPERATURE("T"),
    QV("Q"),
    DT("dT"),
    AH("h", "a_h"),
    AW("w", "a_w"),
    LAMBDA("lambda"),
    TM("Tm"),
    GN_H("Gn_h"),
    GE_H("Ge_h"),
    GN_W("Gn_w"),
    GE_W("Ge_w");

    private static final String SUFFIX = ":a0";
    private static final Map<String, SeasonalModelType> LABELS_MAP;
    private final String[] labels;

    private SeasonalModelType(String ... labels) {
        this.labels = (String[])labels.clone();
    }

    public static SeasonalModelType parseType(String field, int lineNumber, String name) {
        return LABELS_MAP.get(field);
    }

    static {
        LABELS_MAP = new HashMap<String, SeasonalModelType>();
        for (SeasonalModelType type : SeasonalModelType.values()) {
            for (String label : type.labels) {
                LABELS_MAP.put(label + SUFFIX, type);
            }
        }
    }
}

