/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;

class SeasonalModel {
    private final double a0;
    private final double a1;
    private final double b1;
    private final double a2;
    private final double b2;

    SeasonalModel(double a0, double a1, double b1, double a2, double b2) {
        this.a0 = a0;
        this.a1 = a1;
        this.b1 = b1;
        this.a2 = a2;
        this.b2 = b2;
    }

    public double evaluate(int dayOfYear) {
        double coef = (double)dayOfYear / 365.25 * 2.0 * Math.PI;
        SinCos sc1 = FastMath.sinCos((double)coef);
        SinCos sc2 = FastMath.sinCos((double)(2.0 * coef));
        return this.a0 + this.a1 * sc1.cos() + this.b1 * sc1.sin() + this.a2 * sc2.cos() + this.b2 * sc2.sin();
    }
}

