/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.water.WaterVaporPressureProvider;

public class HeightDependentPressureTemperatureHumidityConverter {
    private final WaterVaporPressureProvider provider;

    public HeightDependentPressureTemperatureHumidityConverter(WaterVaporPressureProvider provider) {
        this.provider = provider;
    }

    public PressureTemperatureHumidity convert(PressureTemperatureHumidity pth0, double h) {
        double rh0 = this.provider.relativeHumidity(pth0.getPressure(), pth0.getTemperature(), pth0.getWaterVaporPressure());
        double dh = h - pth0.getAltitude();
        double p = pth0.getPressure() * FastMath.pow((double)(1.0 - 2.26E-5 * dh), (double)5.225);
        double t = pth0.getTemperature() - 0.0065 * dh;
        double rh = rh0 * FastMath.exp((double)(-6.396E-4 * dh));
        return new PressureTemperatureHumidity(h, p, t, this.provider.waterVaporPressure(p, t, rh), pth0.getTm(), pth0.getLambda());
    }

    public <T extends CalculusFieldElement<T>> FieldPressureTemperatureHumidity<T> convert(FieldPressureTemperatureHumidity<T> pth0, T h) {
        Object rh0 = this.provider.relativeHumidity(pth0.getPressure(), pth0.getTemperature(), pth0.getWaterVaporPressure());
        CalculusFieldElement dh = (CalculusFieldElement)h.subtract(pth0.getAltitude());
        CalculusFieldElement t = (CalculusFieldElement)pth0.getTemperature().subtract((FieldElement)((CalculusFieldElement)dh.multiply(0.0065)));
        CalculusFieldElement p = (CalculusFieldElement)pth0.getPressure().multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dh.multiply(2.26E-5)).negate()).add(1.0)).pow(5.225)));
        CalculusFieldElement rh = (CalculusFieldElement)rh0.multiply((FieldElement)FastMath.exp((CalculusFieldElement)((CalculusFieldElement)dh.multiply(-6.396E-4))));
        return new FieldPressureTemperatureHumidity<CalculusFieldElement>((CalculusFieldElement)h, p, t, this.provider.waterVaporPressure(p, t, rh), (CalculusFieldElement)pth0.getTm(), (CalculusFieldElement)pth0.getLambda());
    }
}

