/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.util.Map;
import org.orekit.models.earth.weather.SeasonalModel;
import org.orekit.models.earth.weather.SeasonalModelType;

class GridEntry {
    public static final int DEG_TO_MAS = 3600000;
    private final double latitude;
    private final int latKey;
    private final double longitude;
    private final int lonKey;
    private final double undulation;
    private final double hS;
    private Map<SeasonalModelType, SeasonalModel> models;

    GridEntry(double latitude, int latKey, double longitude, int lonKey, double undulation, double hS, Map<SeasonalModelType, SeasonalModel> models) {
        this.latitude = latitude;
        this.latKey = latKey;
        this.longitude = longitude;
        this.lonKey = lonKey;
        this.undulation = undulation;
        this.hS = hS;
        this.models = models;
    }

    public GridEntry buildWrappedEntry() {
        return new GridEntry(this.latitude, this.latKey, this.longitude + Math.PI * 2, this.lonKey + 1296000000, this.undulation, this.hS, this.models);
    }

    double getLatitude() {
        return this.latitude;
    }

    int getLatKey() {
        return this.latKey;
    }

    double getLongitude() {
        return this.longitude;
    }

    int getLonKey() {
        return this.lonKey;
    }

    double getUndulation() {
        return this.undulation;
    }

    double getHs() {
        return this.hS;
    }

    SeasonalModel getModel(SeasonalModelType type) {
        return this.models.get((Object)type);
    }
}

