/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.util.List;
import java.util.SortedSet;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.weather.CellInterpolator;
import org.orekit.models.earth.weather.FieldCellInterpolator;
import org.orekit.models.earth.weather.GridEntry;
import org.orekit.models.earth.weather.SeasonalModelType;

class Grid {
    private final SortedSet<Integer> latitudeSample;
    private final SortedSet<Integer> longitudeSample;
    private final GridEntry[][] entries;

    Grid(SortedSet<Integer> latitudeSample, SortedSet<Integer> longitudeSample, List<GridEntry> loadedEntries, String name) {
        int nA = latitudeSample.size();
        int nO = longitudeSample.size() + 1;
        this.entries = new GridEntry[nA][nO];
        this.latitudeSample = latitudeSample;
        this.longitudeSample = longitudeSample;
        for (GridEntry entry : loadedEntries) {
            int latitudeIndex = latitudeSample.headSet(entry.getLatKey() + 1).size() - 1;
            int longitudeIndex = longitudeSample.headSet(entry.getLonKey() + 1).size() - 1;
            this.entries[latitudeIndex][longitudeIndex] = entry;
        }
        for (GridEntry[] row : this.entries) {
            for (int longitudeIndex = 0; longitudeIndex < nO - 1; ++longitudeIndex) {
                if (row[longitudeIndex] != null) continue;
                throw new OrekitException((Localizable)OrekitMessages.IRREGULAR_OR_INCOMPLETE_GRID, name);
            }
            row[nO - 1] = row[0].buildWrappedEntry();
        }
    }

    private int getSouthIndex(double latitude) {
        int latKey = (int)FastMath.rint((double)(FastMath.toDegrees((double)latitude) * 3600000.0));
        int index = this.latitudeSample.headSet(latKey + 1).size() - 1;
        return FastMath.min((int)index, (int)(this.latitudeSample.size() - 2));
    }

    private int getWestIndex(double longitude) {
        int lonKey = (int)FastMath.rint((double)(FastMath.toDegrees((double)longitude) * 3600000.0));
        int index = this.longitudeSample.headSet(lonKey + 1).size() - 1;
        return index;
    }

    CellInterpolator getInterpolator(double latitude, double longitude) {
        double normalizedLongitude = MathUtils.normalizeAngle((double)longitude, (double)(this.entries[0][0].getLongitude() + Math.PI));
        int southIndex = this.getSouthIndex(latitude);
        int westIndex = this.getWestIndex(normalizedLongitude);
        return new CellInterpolator(latitude, normalizedLongitude, this.entries[southIndex][westIndex], this.entries[southIndex][westIndex + 1], this.entries[southIndex + 1][westIndex], this.entries[southIndex + 1][westIndex + 1]);
    }

    <T extends CalculusFieldElement<T>> FieldCellInterpolator<T> getInterpolator(T latitude, T longitude) {
        CalculusFieldElement normalizedLongitude = MathUtils.normalizeAngle(longitude, (CalculusFieldElement)((CalculusFieldElement)longitude.newInstance(this.entries[0][0].getLongitude() + Math.PI)));
        int southIndex = this.getSouthIndex(latitude.getReal());
        int westIndex = this.getWestIndex(normalizedLongitude.getReal());
        return new FieldCellInterpolator<CalculusFieldElement>(latitude, normalizedLongitude, this.entries[southIndex][westIndex], this.entries[southIndex][westIndex + 1], this.entries[southIndex + 1][westIndex], this.entries[southIndex + 1][westIndex + 1]);
    }

    boolean hasModels(SeasonalModelType ... types) {
        boolean hasAll = true;
        for (SeasonalModelType type : types) {
            hasAll &= this.entries[0][0].getModel(type) != null;
        }
        return hasAll;
    }
}

