/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.data.DataLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.weather.Grid;
import org.orekit.models.earth.weather.GridEntry;
import org.orekit.models.earth.weather.SeasonalModel;
import org.orekit.models.earth.weather.SeasonalModelType;

class GptNParser
implements DataLoader {
    private static final String COMMENT = "%";
    private static final Pattern SEPARATOR = Pattern.compile("\\s+");
    private static final String LATITUDE_LABEL = "lat";
    private static final String LONGITUDE_LABEL = "lon";
    private static final String UNDULATION_LABEL = "undu";
    private static final String HEIGHT_CORRECTION_LABEL = "Hs";
    private static final String A1 = "A1";
    private static final String B1 = "B1";
    private static final String A2 = "A2";
    private static final String B2 = "B2";
    private final SeasonalModelType[] expected;
    private int latitudeIndex;
    private int longitudeIndex;
    private int undulationIndex;
    private int heightCorrectionIndex;
    private int maxIndex;
    private int[] expectedIndices;
    private Grid grid;

    GptNParser(SeasonalModelType ... expected) {
        this.expected = (SeasonalModelType[])expected.clone();
        this.expectedIndices = new int[expected.length];
    }

    @Override
    public boolean stillAcceptsData() {
        return this.grid == null;
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException {
        TreeSet<Integer> latSample = new TreeSet<Integer>();
        TreeSet<Integer> lonSample = new TreeSet<Integer>();
        ArrayList<GridEntry> entries = new ArrayList<GridEntry>();
        int lineNumber = 0;
        String line = null;
        try (InputStreamReader isr = new InputStreamReader(input, StandardCharsets.UTF_8);
             BufferedReader br = new BufferedReader(isr);){
            line = br.readLine();
            while (line != null) {
                line = line.trim();
                if (++lineNumber == 1) {
                    this.parseHeader(line, lineNumber, name);
                } else {
                    GridEntry entry = this.parseEntry(line, lineNumber, name);
                    latSample.add(entry.getLatKey());
                    lonSample.add(entry.getLonKey());
                    entries.add(entry);
                }
                line = br.readLine();
            }
        }
        this.grid = new Grid(latSample, lonSample, entries, name);
    }

    private void parseHeader(String line, int lineNumber, String name) {
        this.latitudeIndex = -1;
        this.longitudeIndex = -1;
        this.undulationIndex = -1;
        this.heightCorrectionIndex = -1;
        this.maxIndex = -1;
        Arrays.fill(this.expectedIndices, -1);
        String[] fields = SEPARATOR.split(line.substring(COMMENT.length()).trim());
        String lookingFor = LATITUDE_LABEL;
        block20: for (int i = 0; i < fields.length; ++i) {
            this.maxIndex = FastMath.max((int)this.maxIndex, (int)i);
            this.checkLabel(fields[i], lookingFor, line, lineNumber, name);
            switch (fields[i]) {
                case "lat": {
                    this.latitudeIndex = i;
                    lookingFor = LONGITUDE_LABEL;
                    continue block20;
                }
                case "lon": {
                    lookingFor = null;
                    this.longitudeIndex = i;
                    continue block20;
                }
                case "undu": {
                    lookingFor = HEIGHT_CORRECTION_LABEL;
                    this.undulationIndex = i;
                    continue block20;
                }
                case "Hs": {
                    lookingFor = null;
                    this.heightCorrectionIndex = i;
                    continue block20;
                }
                case "A1": {
                    lookingFor = B1;
                    continue block20;
                }
                case "B1": {
                    lookingFor = A2;
                    continue block20;
                }
                case "A2": {
                    lookingFor = B2;
                    continue block20;
                }
                case "B2": {
                    lookingFor = null;
                    continue block20;
                }
                default: {
                    SeasonalModelType type = SeasonalModelType.parseType(fields[i], lineNumber, name);
                    for (int j = 0; j < this.expected.length; ++j) {
                        if (type != this.expected[j]) continue;
                        this.expectedIndices[j] = i;
                        lookingFor = A1;
                        continue block20;
                    }
                }
            }
        }
        int minIndex = FastMath.min((int)this.latitudeIndex, (int)FastMath.min((int)this.longitudeIndex, (int)FastMath.min((int)this.undulationIndex, (int)this.heightCorrectionIndex)));
        for (int index : this.expectedIndices) {
            minIndex = FastMath.min((int)minIndex, (int)index);
        }
        if (minIndex < 0) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
    }

    private void checkLabel(String label, String lookingFor, String line, int lineNumber, String name) {
        if (lookingFor != null && !lookingFor.equals(label)) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
    }

    private GridEntry parseEntry(String line, int lineNumber, String name) {
        try {
            String[] fields = SEPARATOR.split(line);
            if (fields.length != this.maxIndex + 1) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
            }
            double latDegree = Double.parseDouble(fields[this.latitudeIndex]);
            double lonDegree = Double.parseDouble(fields[this.longitudeIndex]);
            HashMap<SeasonalModelType, SeasonalModel> models = new HashMap<SeasonalModelType, SeasonalModel>(this.expected.length);
            for (int i = 0; i < this.expected.length; ++i) {
                int first = this.expectedIndices[i];
                models.put(this.expected[i], new SeasonalModel(Double.parseDouble(fields[first]), Double.parseDouble(fields[first + 1]), Double.parseDouble(fields[first + 2]), Double.parseDouble(fields[first + 3]), Double.parseDouble(fields[first + 4])));
            }
            return new GridEntry(FastMath.toRadians((double)latDegree), (int)FastMath.rint((double)(latDegree * 3600000.0)), FastMath.toRadians((double)lonDegree), (int)FastMath.rint((double)(lonDegree * 3600000.0)), Double.parseDouble(fields[this.undulationIndex]), Double.parseDouble(fields[this.heightCorrectionIndex]), models);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, name, line);
        }
    }

    public Grid getGrid() {
        return this.grid;
    }
}

