/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.frames.Frame;
import org.orekit.models.earth.Geoid;
import org.orekit.models.earth.ReferenceEllipsoid;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.GlobalPressureTemperature;
import org.orekit.models.earth.weather.PressureTemperature;
import org.orekit.models.earth.weather.WeatherModel;
import org.orekit.time.AbsoluteDate;

@Deprecated
public class GlobalPressureTemperatureModel
extends GlobalPressureTemperature
implements WeatherModel {
    private static final int DEGREE = 9;
    private static final int ORDER = 9;
    private final double latitude;
    private final double longitude;
    private double temperature;
    private double pressure;

    @DefaultDataContext
    public GlobalPressureTemperatureModel(double latitude, double longitude, Frame bodyFrame) {
        this(latitude, longitude, bodyFrame, DataContext.getDefault());
    }

    public GlobalPressureTemperatureModel(double latitude, double longitude, Frame bodyFrame, DataContext dataContext) {
        super(new Geoid(dataContext.getGravityFields().getNormalizedProvider(9, 9), ReferenceEllipsoid.getWgs84(bodyFrame)), dataContext.getTimeScales().getUTC());
        this.latitude = latitude;
        this.longitude = longitude;
        this.temperature = Double.NaN;
        this.pressure = Double.NaN;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getPressure() {
        return this.pressure;
    }

    @Override
    public void weatherParameters(double height, AbsoluteDate date) {
        GeodeticPoint location = new GeodeticPoint(this.latitude, this.longitude, height);
        PressureTemperature pt = this.getWeatherParameters(location, date);
        this.temperature = pt.getTemperature();
        this.pressure = TroposphericModelUtils.HECTO_PASCAL.fromSI(pt.getPressure());
    }
}

