/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.models.earth.Geoid;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.troposphere.ViennaACoefficients;
import org.orekit.models.earth.weather.GlobalPressureTemperature2;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.WeatherModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;

@Deprecated
public class GlobalPressureTemperature2Model
extends GlobalPressureTemperature2
implements WeatherModel {
    public static final String DEFAULT_SUPPORTED_NAMES = "gpt2_\\d+.grd";
    private double[] coefficientsA = null;
    private final double latitude;
    private final double longitude;
    private double temperature = Double.NaN;
    private double pressure = Double.NaN;
    private double e0 = Double.NaN;

    @DefaultDataContext
    public GlobalPressureTemperature2Model(String supportedNames, double latitude, double longitude, Geoid geoid) {
        this(supportedNames, latitude, longitude, geoid, DataContext.getDefault().getDataProvidersManager(), DataContext.getDefault().getTimeScales().getUTC());
    }

    public GlobalPressureTemperature2Model(String supportedNames, double latitude, double longitude, Geoid ignoredGeoid, DataProvidersManager dataProvidersManager, TimeScale utc) {
        super(supportedNames, dataProvidersManager, utc);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @DefaultDataContext
    public GlobalPressureTemperature2Model(double latitude, double longitude, Geoid geoid) {
        this(DEFAULT_SUPPORTED_NAMES, latitude, longitude, geoid);
    }

    public double[] getA() {
        return (double[])this.coefficientsA.clone();
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getPressure() {
        return this.pressure;
    }

    public double getWaterVaporPressure() {
        return this.e0;
    }

    @Override
    public void weatherParameters(double stationHeight, AbsoluteDate currentDate) {
        GeodeticPoint location = new GeodeticPoint(this.latitude, this.longitude, stationHeight);
        ViennaACoefficients aC = this.getA(location, currentDate);
        this.coefficientsA = new double[]{aC.getAh(), aC.getAw()};
        PressureTemperatureHumidity pth = this.getWeatherParamerers(location, currentDate);
        this.temperature = pth.getTemperature();
        this.pressure = TroposphericModelUtils.HECTO_PASCAL.fromSI(pth.getPressure());
        this.e0 = TroposphericModelUtils.HECTO_PASCAL.fromSI(pth.getWaterVaporPressure());
    }
}

