/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.models.earth.weather.FieldPressureTemperature;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;

public class FieldPressureTemperatureHumidity<T extends CalculusFieldElement<T>>
extends FieldPressureTemperature<T> {
    private final T waterVaporPressure;
    private final T tm;
    private final T lambda;

    public FieldPressureTemperatureHumidity(T altitude, T pressure, T temperature, T waterVaporPressure, T tm, T lambda) {
        super(altitude, pressure, temperature);
        this.waterVaporPressure = waterVaporPressure;
        this.tm = tm;
        this.lambda = lambda;
    }

    public FieldPressureTemperatureHumidity(Field<T> field, PressureTemperatureHumidity weather) {
        super(field, weather);
        this.waterVaporPressure = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getWaterVaporPressure());
        this.tm = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getTm());
        this.lambda = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getLambda());
    }

    public T getWaterVaporPressure() {
        return this.waterVaporPressure;
    }

    public T getTm() {
        return this.tm;
    }

    public T getLambda() {
        return this.lambda;
    }
}

