/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;

public class FieldPressureTemperature<T extends CalculusFieldElement<T>> {
    private final T altitude;
    private final T pressure;
    private final T temperature;

    public FieldPressureTemperature(T altitude, T pressure, T temperature) {
        this.altitude = altitude;
        this.pressure = pressure;
        this.temperature = temperature;
    }

    public FieldPressureTemperature(Field<T> field, PressureTemperatureHumidity weather) {
        this.altitude = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getAltitude());
        this.pressure = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getPressure());
        this.temperature = (CalculusFieldElement)((CalculusFieldElement)field.getZero()).newInstance(weather.getTemperature());
    }

    public T getAltitude() {
        return this.altitude;
    }

    public T getPressure() {
        return this.pressure;
    }

    public T getTemperature() {
        return this.temperature;
    }
}

