/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.util.function.ToDoubleFunction;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.orekit.models.earth.weather.GridEntry;

public class CellInterpolator {
    private final double latitude;
    private final double longitude;
    private final GridEntry southWest;
    private final GridEntry southEast;
    private final GridEntry northWest;
    private final GridEntry northEast;

    CellInterpolator(double latitude, double longitude, GridEntry southWest, GridEntry southEast, GridEntry northWest, GridEntry northEast) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.southWest = southWest;
        this.southEast = southEast;
        this.northWest = northWest;
        this.northEast = northEast;
    }

    double interpolate(ToDoubleFunction<GridEntry> gridGetter) {
        double[] xVal = new double[]{this.southWest.getLongitude(), this.southEast.getLongitude()};
        double[] yVal = new double[]{this.southWest.getLatitude(), this.northWest.getLatitude()};
        double[][] fval = new double[][]{{gridGetter.applyAsDouble(this.southWest), gridGetter.applyAsDouble(this.northWest)}, {gridGetter.applyAsDouble(this.southEast), gridGetter.applyAsDouble(this.northEast)}};
        return new BilinearInterpolatingFunction(xVal, yVal, (double[][])fval).value(this.longitude, this.latitude);
    }
}

