/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.weather;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataSource;
import org.orekit.models.earth.troposphere.AzimuthalGradientCoefficients;
import org.orekit.models.earth.troposphere.AzimuthalGradientProvider;
import org.orekit.models.earth.troposphere.FieldAzimuthalGradientCoefficients;
import org.orekit.models.earth.troposphere.FieldViennaACoefficients;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.troposphere.ViennaACoefficients;
import org.orekit.models.earth.troposphere.ViennaAProvider;
import org.orekit.models.earth.weather.CellInterpolator;
import org.orekit.models.earth.weather.FieldCellInterpolator;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.GptNParser;
import org.orekit.models.earth.weather.Grid;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.SeasonalModelType;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public class AbstractGlobalPressureTemperature
implements ViennaAProvider,
AzimuthalGradientProvider,
PressureTemperatureHumidityProvider {
    private static final double G = 9.80665;
    private static final double R = 287.0;
    private final Grid grid;
    private final TimeScale utc;

    protected AbstractGlobalPressureTemperature(DataSource source, TimeScale utc, SeasonalModelType ... expected) throws IOException {
        this.utc = utc;
        try (InputStream is = source.getOpener().openStreamOnce();
             BufferedInputStream bis = new BufferedInputStream(is);){
            GptNParser parser = new GptNParser(expected);
            parser.loadData(bis, source.getName());
            this.grid = parser.getGrid();
        }
    }

    @Deprecated
    protected AbstractGlobalPressureTemperature(Grid grid, TimeScale utc) {
        this.grid = grid;
        this.utc = utc;
    }

    @Override
    public ViennaACoefficients getA(GeodeticPoint location, AbsoluteDate date) {
        CellInterpolator interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
        int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
        return new ViennaACoefficients(interpolator.interpolate(e -> e.getModel(SeasonalModelType.AH).evaluate(dayOfYear)) * 0.001, interpolator.interpolate(e -> e.getModel(SeasonalModelType.AW).evaluate(dayOfYear)) * 0.001);
    }

    @Override
    public PressureTemperatureHumidity getWeatherParamerers(GeodeticPoint location, AbsoluteDate date) {
        CellInterpolator interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
        int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
        double undu = interpolator.interpolate(e -> e.getUndulation());
        double correctedheight = location.getAltitude() - undu - interpolator.interpolate(e -> e.getHs());
        double dTdH = interpolator.interpolate(e -> e.getModel(SeasonalModelType.DT).evaluate(dayOfYear)) * 0.001;
        double qv = interpolator.interpolate(e -> e.getModel(SeasonalModelType.QV).evaluate(dayOfYear)) * 0.001;
        double t0 = interpolator.interpolate(e -> e.getModel(SeasonalModelType.TEMPERATURE).evaluate(dayOfYear));
        double temperature = t0 + dTdH * correctedheight;
        double p0 = interpolator.interpolate(e -> e.getModel(SeasonalModelType.PRESSURE).evaluate(dayOfYear));
        double exponent = 9.80665 / (dTdH * 287.0);
        double pressure = p0 * FastMath.pow((double)(1.0 - dTdH / t0 * correctedheight), (double)exponent) * 0.01;
        double e0 = qv * pressure / (0.622 + 0.378 * qv);
        double tm = this.grid.hasModels(SeasonalModelType.TM) ? interpolator.interpolate(e -> e.getModel(SeasonalModelType.TM).evaluate(dayOfYear)) : Double.NaN;
        double lambda = this.grid.hasModels(SeasonalModelType.LAMBDA) ? interpolator.interpolate(e -> e.getModel(SeasonalModelType.LAMBDA).evaluate(dayOfYear)) : Double.NaN;
        return new PressureTemperatureHumidity(location.getAltitude(), TroposphericModelUtils.HECTO_PASCAL.toSI(pressure), temperature, TroposphericModelUtils.HECTO_PASCAL.toSI(e0), tm, lambda);
    }

    @Override
    public AzimuthalGradientCoefficients getGradientCoefficients(GeodeticPoint location, AbsoluteDate date) {
        if (this.grid.hasModels(SeasonalModelType.GN_H, SeasonalModelType.GE_H, SeasonalModelType.GN_W, SeasonalModelType.GE_W)) {
            CellInterpolator interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
            int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
            return new AzimuthalGradientCoefficients(interpolator.interpolate(e -> e.getModel(SeasonalModelType.GN_H).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GE_H).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GN_W).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GE_W).evaluate(dayOfYear)));
        }
        return null;
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldViennaACoefficients<T> getA(FieldGeodeticPoint<T> location, FieldAbsoluteDate<T> date) {
        FieldCellInterpolator<T> interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
        int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
        return new FieldViennaACoefficients<CalculusFieldElement>((CalculusFieldElement)interpolator.interpolate(e -> e.getModel(SeasonalModelType.AH).evaluate(dayOfYear)).multiply(0.001), (CalculusFieldElement)interpolator.interpolate(e -> e.getModel(SeasonalModelType.AW).evaluate(dayOfYear)).multiply(0.001));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldPressureTemperatureHumidity<T> getWeatherParamerers(FieldGeodeticPoint<T> location, FieldAbsoluteDate<T> date) {
        FieldCellInterpolator<T> interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
        int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
        T undu = interpolator.interpolate(e -> e.getUndulation());
        CalculusFieldElement correctedheight = (CalculusFieldElement)((CalculusFieldElement)location.getAltitude().subtract(undu)).subtract(interpolator.interpolate(e -> e.getHs()));
        CalculusFieldElement dTdH = (CalculusFieldElement)interpolator.interpolate(e -> e.getModel(SeasonalModelType.DT).evaluate(dayOfYear)).multiply(0.001);
        CalculusFieldElement qv = (CalculusFieldElement)interpolator.interpolate(e -> e.getModel(SeasonalModelType.QV).evaluate(dayOfYear)).multiply(0.001);
        T t0 = interpolator.interpolate(e -> e.getModel(SeasonalModelType.TEMPERATURE).evaluate(dayOfYear));
        CalculusFieldElement temperature = (CalculusFieldElement)((CalculusFieldElement)correctedheight.multiply((FieldElement)dTdH)).add(t0);
        T p0 = interpolator.interpolate(e -> e.getModel(SeasonalModelType.PRESSURE).evaluate(dayOfYear));
        CalculusFieldElement exponent = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)dTdH.multiply(287.0)).reciprocal()).multiply(9.80665);
        CalculusFieldElement pressure = (CalculusFieldElement)FastMath.pow((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)correctedheight.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)dTdH.negate()).divide(t0)))).add(1.0)), (CalculusFieldElement)exponent).multiply((FieldElement)((CalculusFieldElement)p0.multiply(0.01)));
        CalculusFieldElement e0 = (CalculusFieldElement)pressure.multiply((FieldElement)((CalculusFieldElement)qv.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)qv.multiply(0.378)).add(0.622)))));
        T tm = this.grid.hasModels(SeasonalModelType.TM) ? interpolator.interpolate(e -> e.getModel(SeasonalModelType.TM).evaluate(dayOfYear)) : (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(Double.NaN);
        T lambda = this.grid.hasModels(SeasonalModelType.LAMBDA) ? interpolator.interpolate(e -> e.getModel(SeasonalModelType.LAMBDA).evaluate(dayOfYear)) : (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(Double.NaN);
        return new FieldPressureTemperatureHumidity<CalculusFieldElement>((CalculusFieldElement)location.getAltitude(), TroposphericModelUtils.HECTO_PASCAL.toSI(pressure), temperature, TroposphericModelUtils.HECTO_PASCAL.toSI(e0), (CalculusFieldElement)tm, (CalculusFieldElement)lambda);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldAzimuthalGradientCoefficients<T> getGradientCoefficients(FieldGeodeticPoint<T> location, FieldAbsoluteDate<T> date) {
        if (this.grid.hasModels(SeasonalModelType.GN_H, SeasonalModelType.GE_H, SeasonalModelType.GN_W, SeasonalModelType.GE_W)) {
            FieldCellInterpolator<T> interpolator = this.grid.getInterpolator(location.getLatitude(), location.getLongitude());
            int dayOfYear = date.getComponents(this.utc).getDate().getDayOfYear();
            return new FieldAzimuthalGradientCoefficients<T>(interpolator.interpolate(e -> e.getModel(SeasonalModelType.GN_H).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GE_H).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GN_W).evaluate(dayOfYear)), interpolator.interpolate(e -> e.getModel(SeasonalModelType.GE_W).evaluate(dayOfYear)));
        }
        return null;
    }
}

