/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.models.earth.troposphere.ConstantAzimuthalGradientProvider;
import org.orekit.models.earth.troposphere.ConstantTroposphericModel;
import org.orekit.models.earth.troposphere.ConstantViennaAProvider;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.troposphere.ViennaACoefficients;
import org.orekit.models.earth.troposphere.ViennaThree;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.TrackingCoordinates;

@Deprecated
public class ViennaThreeModel
extends ViennaThree
implements DiscreteTroposphericModel,
MappingFunction {
    private final double[] zenithDelay;

    @DefaultDataContext
    public ViennaThreeModel(double[] coefficientA, double[] zenithDelay) {
        this(coefficientA, zenithDelay, DataContext.getDefault().getTimeScales().getUTC());
    }

    public ViennaThreeModel(double[] coefficientA, double[] zenithDelay, TimeScale utc) {
        super(new ConstantViennaAProvider(new ViennaACoefficients(coefficientA[0], coefficientA[1])), new ConstantAzimuthalGradientProvider(null), new ConstantTroposphericModel(new TroposphericDelay(zenithDelay[0], zenithDelay[1], zenithDelay[0], zenithDelay[1])), utc);
        this.zenithDelay = (double[])zenithDelay.clone();
    }

    @Override
    @Deprecated
    public double[] mappingFactors(double elevation, GeodeticPoint point, AbsoluteDate date) {
        return this.mappingFactors(new TrackingCoordinates(0.0, elevation, 0.0), point, TroposphericModelUtils.STANDARD_ATMOSPHERE, date);
    }

    @Override
    @Deprecated
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(T elevation, FieldGeodeticPoint<T> point, FieldAbsoluteDate<T> date) {
        return this.mappingFactors(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, new FieldPressureTemperatureHumidity<T>(date.getField(), TroposphericModelUtils.STANDARD_ATMOSPHERE), date);
    }

    @Override
    @Deprecated
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return this.pathDelay(new TrackingCoordinates(0.0, elevation, 0.0), point, TroposphericModelUtils.STANDARD_ATMOSPHERE, parameters, date).getDelay();
    }

    @Override
    @Deprecated
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.pathDelay(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, new FieldPressureTemperatureHumidity<T>(date.getField(), TroposphericModelUtils.STANDARD_ATMOSPHERE), (CalculusFieldElement[])parameters, date).getDelay();
    }

    public double[] computeZenithDelay(GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return (double[])this.zenithDelay.clone();
    }

    public <T extends CalculusFieldElement<T>> T[] computeZenithDelay(FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement[] delays = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        delays[0] = (CalculusFieldElement)zero.newInstance(this.zenithDelay[0]);
        delays[1] = (CalculusFieldElement)zero.newInstance(this.zenithDelay[1]);
        return delays;
    }
}

