/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.AbstractVienna;
import org.orekit.models.earth.troposphere.AzimuthalGradientProvider;
import org.orekit.models.earth.troposphere.FieldViennaACoefficients;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.troposphere.ViennaACoefficients;
import org.orekit.models.earth.troposphere.ViennaAProvider;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class ViennaOne
extends AbstractVienna {
    public ViennaOne(ViennaAProvider aProvider, AzimuthalGradientProvider gProvider, TroposphericModel zenithDelayProvider, TimeScale utc) {
        super(aProvider, gProvider, zenithDelayProvider, utc);
    }

    @Override
    public double[] mappingFactors(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, AbsoluteDate date) {
        double psi;
        double c11h;
        double c10h;
        ViennaACoefficients a = this.getAProvider().getA(point, date);
        int dofyear = this.getDayOfYear(date);
        double bh = 0.0029;
        double c0h = 0.062;
        double latitude = point.getLatitude();
        if (FastMath.sin((double)latitude) > 0.0) {
            c10h = 0.001;
            c11h = 0.005;
            psi = 0.0;
        } else {
            c10h = 0.002;
            c11h = 0.007;
            psi = Math.PI;
        }
        double t0 = 28.0;
        if (latitude < 0.0) {
            t0 += 183.0;
        }
        double coef = ((double)dofyear - t0) / 365.0 * 2.0 * Math.PI + psi;
        double ch = 0.062 + ((FastMath.cos((double)coef) + 1.0) * (c11h / 2.0) + c10h) * (1.0 - FastMath.cos((double)latitude));
        double bw = 0.00146;
        double cw = 0.04391;
        double[] function = new double[]{TroposphericModelUtils.mappingFunction(a.getAh(), 0.0029, ch, trackingCoordinates.getElevation()), TroposphericModelUtils.mappingFunction(a.getAw(), 0.00146, 0.04391, trackingCoordinates.getElevation())};
        double correction = TroposphericModelUtils.computeHeightCorrection(trackingCoordinates.getElevation(), point.getAltitude());
        function[0] = function[0] + correction;
        return function;
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, FieldAbsoluteDate<T> date) {
        CalculusFieldElement psi;
        CalculusFieldElement c11h;
        CalculusFieldElement c10h;
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldViennaACoefficients<T> a = this.getAProvider().getA(point, date);
        int dofyear = this.getDayOfYear(date.toAbsoluteDate());
        CalculusFieldElement bh = (CalculusFieldElement)zero.newInstance(0.0029);
        CalculusFieldElement c0h = (CalculusFieldElement)zero.newInstance(0.062);
        T latitude = point.getLatitude();
        if (FastMath.sin((double)latitude.getReal()) > 0.0) {
            c10h = (CalculusFieldElement)zero.newInstance(0.001);
            c11h = (CalculusFieldElement)zero.newInstance(0.005);
            psi = zero;
        } else {
            c10h = (CalculusFieldElement)zero.newInstance(0.002);
            c11h = (CalculusFieldElement)zero.newInstance(0.007);
            psi = (CalculusFieldElement)zero.getPi();
        }
        double t0 = 28.0;
        if (latitude.getReal() < 0.0) {
            t0 += 183.0;
        }
        CalculusFieldElement coef = (CalculusFieldElement)psi.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(2.0)).multiply(((double)dofyear - t0) / 365.0)));
        CalculusFieldElement ch = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)c11h.divide(2.0)).multiply((FieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)coef).add(1.0)))).add((FieldElement)c10h)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos(latitude).negate()).add(1.0)))).add((FieldElement)c0h);
        CalculusFieldElement bw = (CalculusFieldElement)zero.newInstance(0.00146);
        CalculusFieldElement cw = (CalculusFieldElement)zero.newInstance(0.04391);
        CalculusFieldElement[] function = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        function[0] = TroposphericModelUtils.mappingFunction(a.getAh(), bh, ch, trackingCoordinates.getElevation());
        function[1] = TroposphericModelUtils.mappingFunction(a.getAw(), bw, cw, trackingCoordinates.getElevation());
        T correction = TroposphericModelUtils.computeHeightCorrection(trackingCoordinates.getElevation(), point.getAltitude(), field);
        function[0] = (CalculusFieldElement)function[0].add(correction);
        return function;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

