/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.models.earth.weather.ConstantPressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.water.CIPM2007;
import org.orekit.utils.units.Unit;

public class TroposphericModelUtils {
    public static final Unit NANO_M = Unit.parse("nm");
    public static final Unit MICRO_M = Unit.parse("\u00b5m");
    public static final Unit HECTO_PASCAL = Unit.parse("hPa");
    public static final PressureTemperatureHumidity STANDARD_ATMOSPHERE;
    public static final PressureTemperatureHumidityProvider STANDARD_ATMOSPHERE_PROVIDER;

    private TroposphericModelUtils() {
    }

    public static double mappingFunction(double a, double b, double c, double elevation) {
        double sinE = FastMath.sin((double)elevation);
        double numMP = 1.0 + a / (1.0 + b / (1.0 + c));
        double denMP = sinE + a / (sinE + b / (sinE + c));
        double fElevation = numMP / denMP;
        return fElevation;
    }

    public static <T extends CalculusFieldElement<T>> T mappingFunction(T a, T b, T c, T elevation) {
        CalculusFieldElement sinE = FastMath.sin(elevation);
        CalculusFieldElement numMP = (CalculusFieldElement)((CalculusFieldElement)a.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.divide((FieldElement)((CalculusFieldElement)c.add(1.0)))).add(1.0)))).add(1.0);
        CalculusFieldElement denMP = (CalculusFieldElement)((CalculusFieldElement)a.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)b.divide((FieldElement)((CalculusFieldElement)c.add((FieldElement)sinE)))).add((FieldElement)sinE)))).add((FieldElement)sinE);
        CalculusFieldElement fElevation = (CalculusFieldElement)numMP.divide((FieldElement)denMP);
        return (T)fElevation;
    }

    public static double computeHeightCorrection(double elevation, double height) {
        double fixedHeight = FastMath.max((double)0.0, (double)height);
        double sinE = FastMath.sin((double)elevation);
        double function = TroposphericModelUtils.mappingFunction(2.53E-5, 0.00549, 0.00114, elevation);
        double dmdh = 1.0 / sinE - function;
        double correction = dmdh * (fixedHeight / 1000.0);
        return correction;
    }

    public static <T extends CalculusFieldElement<T>> T computeHeightCorrection(T elevation, T height, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement fixedHeight = FastMath.max((CalculusFieldElement)zero, height);
        CalculusFieldElement sinE = FastMath.sin(elevation);
        CalculusFieldElement function = TroposphericModelUtils.mappingFunction((CalculusFieldElement)zero.newInstance(2.53E-5), (CalculusFieldElement)zero.newInstance(0.00549), (CalculusFieldElement)zero.newInstance(0.00114), elevation);
        CalculusFieldElement dmdh = (CalculusFieldElement)((CalculusFieldElement)sinE.reciprocal()).subtract((FieldElement)function);
        CalculusFieldElement correction = (CalculusFieldElement)dmdh.multiply((FieldElement)((CalculusFieldElement)fixedHeight.divide(1000.0)));
        return (T)correction;
    }

    static {
        double h = 0.0;
        double p = HECTO_PASCAL.toSI(1013.25);
        double t = 293.15;
        double rh = 0.5;
        STANDARD_ATMOSPHERE = new PressureTemperatureHumidity(0.0, p, 293.15, new CIPM2007().waterVaporPressure(p, 293.15, 0.5), Double.NaN, Double.NaN);
        STANDARD_ATMOSPHERE_PROVIDER = new ConstantPressureTemperatureHumidityProvider(STANDARD_ATMOSPHERE);
    }
}

