/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.EstimatedTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

@Deprecated
public class TimeSpanEstimatedTroposphericModel
implements DiscreteTroposphericModel {
    public static final String DATE_BEFORE = " - Before ";
    public static final String DATE_AFTER = " - After ";
    private final TimeScale timeScale;
    private final TimeSpanMap<EstimatedTroposphericModel> troposphericModelMap;

    @DefaultDataContext
    public TimeSpanEstimatedTroposphericModel(EstimatedTroposphericModel model) {
        this(model, TimeScalesFactory.getUTC());
    }

    public TimeSpanEstimatedTroposphericModel(EstimatedTroposphericModel model, TimeScale timeScale) {
        this.troposphericModelMap = new TimeSpanMap<EstimatedTroposphericModel>(model);
        this.timeScale = timeScale;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        ArrayList<ParameterDriver> listTroposphericParameterDrivers = new ArrayList<ParameterDriver>();
        for (TimeSpanMap.Span<EstimatedTroposphericModel> span = this.getFirstSpan(); span != null; span = span.next()) {
            for (ParameterDriver tropoDriver : span.getData().getParametersDrivers()) {
                if (this.findByName(listTroposphericParameterDrivers, tropoDriver.getName())) continue;
                listTroposphericParameterDrivers.add(tropoDriver);
            }
        }
        return listTroposphericParameterDrivers;
    }

    public void addTroposphericModelValidBefore(EstimatedTroposphericModel model, AbsoluteDate latestValidityDate) {
        this.troposphericModelMap.addValidBefore(this.changeTroposphericParameterDriversNames(model, latestValidityDate, DATE_BEFORE), latestValidityDate, false);
    }

    public void addTroposphericModelValidAfter(EstimatedTroposphericModel model, AbsoluteDate earliestValidityDate) {
        this.troposphericModelMap.addValidAfter(this.changeTroposphericParameterDriversNames(model, earliestValidityDate, DATE_AFTER), earliestValidityDate, false);
    }

    public EstimatedTroposphericModel getTroposphericModel(AbsoluteDate date) {
        return this.troposphericModelMap.get(date);
    }

    public TimeSpanMap.Span<EstimatedTroposphericModel> getFirstSpan() {
        return this.troposphericModelMap.getFirstSpan();
    }

    public double[] extractParameters(double[] parameters, AbsoluteDate date) {
        List<ParameterDriver> troposphericParameterDriver = this.getTroposphericModel(date).getParametersDrivers();
        List<ParameterDriver> allTroposphericParameters = this.getParametersDrivers();
        double[] outParameters = new double[troposphericParameterDriver.size()];
        int index = 0;
        for (int i = 0; i < allTroposphericParameters.size(); ++i) {
            String driverName = allTroposphericParameters.get(i).getName();
            for (ParameterDriver tropoDriver : troposphericParameterDriver) {
                if (!tropoDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    public <T extends CalculusFieldElement<T>> T[] extractParameters(T[] parameters, FieldAbsoluteDate<T> date) {
        List<ParameterDriver> troposphericParameterDriver = this.getTroposphericModel(date.toAbsoluteDate()).getParametersDrivers();
        List<ParameterDriver> allTroposphericParameters = this.getParametersDrivers();
        CalculusFieldElement[] outParameters = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)troposphericParameterDriver.size());
        int index = 0;
        for (int i = 0; i < allTroposphericParameters.size(); ++i) {
            String driverName = allTroposphericParameters.get(i).getName();
            for (ParameterDriver tropoDriver : troposphericParameterDriver) {
                if (!tropoDriver.getName().equals(driverName)) continue;
                outParameters[index++] = parameters[i];
            }
        }
        return outParameters;
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        double[] extractedParameters = this.extractParameters(parameters, date);
        return this.getTroposphericModel(date).pathDelay(elevation, point, extractedParameters, date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] extractedParameters = this.extractParameters((CalculusFieldElement[])parameters, date);
        return (T)this.getTroposphericModel(date.toAbsoluteDate()).pathDelay(elevation, point, extractedParameters, date);
    }

    private boolean findByName(List<ParameterDriver> driversList, String name) {
        for (ParameterDriver driver : driversList) {
            if (!driver.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private EstimatedTroposphericModel changeTroposphericParameterDriversNames(EstimatedTroposphericModel troposphericModel, AbsoluteDate date, String datePrefix) {
        for (ParameterDriver driver : troposphericModel.getParametersDrivers()) {
            String driverName = driver.getName();
            if (!driverName.equals("total zenith delay")) continue;
            driver.setName(driverName + datePrefix + date.toString(this.timeScale));
        }
        return troposphericModel;
    }
}

