/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.BilinearInterpolatingFunction;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.data.DataContext;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.ConstantPressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.HeightDependentPressureTemperatureHumidityConverter;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.water.Wang1988;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.InterpolationTableLoader;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class ModifiedSaastamoinenModel
implements TroposphericModel,
DiscreteTroposphericModel {
    public static final String DELTA_R_FILE_NAME = "^saastamoinen-correction\\.txt$";
    public static final double DEFAULT_LOW_ELEVATION_THRESHOLD = 0.05;
    public static final Wang1988 WATER = new Wang1988();
    private static final Pattern FIRST_DELTA_R_PATTERN = Pattern.compile("^\\^");
    private static final Pattern SECOND_DELTA_R_PATTERN = Pattern.compile("\\$$");
    private static final double L0 = 2.277E-5;
    private static final double T_NUM = 1255.0;
    private static final double WET_OFFSET = 0.05;
    private static final double[] X_VALUES_FOR_B = new double[]{0.0, 500.0, 1000.0, 1500.0, 2000.0, 2500.0, 3000.0, 4000.0, 5000.0};
    private static final double[] Y_VALUES_FOR_B = new double[]{115.6, 107.9, 100.6, 93.8, 87.4, 81.3, 75.7, 65.4, 56.3};
    private static final PolynomialSplineFunction B_FUNCTION = new LinearInterpolator().interpolate(X_VALUES_FOR_B, Y_VALUES_FOR_B);
    private final BilinearInterpolatingFunction deltaRFunction;
    private final PressureTemperatureHumidityProvider pth0Provider;
    private final HeightDependentPressureTemperatureHumidityConverter converter;
    private double lowElevationThreshold;

    @Deprecated
    public ModifiedSaastamoinenModel(double t0, double p0, double r0) {
        this(t0, p0, r0, ModifiedSaastamoinenModel.defaultDeltaR());
    }

    @Deprecated
    @DefaultDataContext
    public ModifiedSaastamoinenModel(double t0, double p0, double r0, String deltaRFileName) {
        this(t0, p0, r0, deltaRFileName, DataContext.getDefault().getDataProvidersManager());
    }

    @Deprecated
    public ModifiedSaastamoinenModel(double t0, double p0, double r0, String deltaRFileName, DataProvidersManager dataProvidersManager) {
        this(t0, p0, r0, deltaRFileName == null ? ModifiedSaastamoinenModel.defaultDeltaR() : ModifiedSaastamoinenModel.loadDeltaR(deltaRFileName, dataProvidersManager));
    }

    @Deprecated
    private ModifiedSaastamoinenModel(double t0, double p0, double r0, BilinearInterpolatingFunction deltaR) {
        this((PressureTemperatureHumidityProvider)new ConstantPressureTemperatureHumidityProvider(new PressureTemperatureHumidity(0.0, TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, WATER.waterVaporPressure(TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, r0), Double.NaN, Double.NaN)), deltaR);
    }

    public ModifiedSaastamoinenModel(PressureTemperatureHumidityProvider pth0Provider) {
        this(pth0Provider, ModifiedSaastamoinenModel.defaultDeltaR());
    }

    @DefaultDataContext
    public ModifiedSaastamoinenModel(PressureTemperatureHumidityProvider pth0Provider, String deltaRFileName) {
        this(pth0Provider, deltaRFileName, DataContext.getDefault().getDataProvidersManager());
    }

    public ModifiedSaastamoinenModel(PressureTemperatureHumidityProvider pth0Provider, String deltaRFileName, DataProvidersManager dataProvidersManager) {
        this(pth0Provider, deltaRFileName == null ? ModifiedSaastamoinenModel.defaultDeltaR() : ModifiedSaastamoinenModel.loadDeltaR(deltaRFileName, dataProvidersManager));
    }

    private ModifiedSaastamoinenModel(PressureTemperatureHumidityProvider pth0Provider, BilinearInterpolatingFunction deltaR) {
        this.pth0Provider = pth0Provider;
        this.converter = new HeightDependentPressureTemperatureHumidityConverter(WATER);
        this.deltaRFunction = deltaR;
        this.lowElevationThreshold = 0.05;
    }

    public static ModifiedSaastamoinenModel getStandardModel() {
        double altitude = 0.0;
        double pressure = TroposphericModelUtils.HECTO_PASCAL.toSI(1013.25);
        double temperature = 291.15;
        double humidity = 0.5;
        PressureTemperatureHumidity pth = new PressureTemperatureHumidity(0.0, pressure, 291.15, WATER.waterVaporPressure(pressure, 291.15, 0.5), Double.NaN, Double.NaN);
        ConstantPressureTemperatureHumidityProvider pth0Provider = new ConstantPressureTemperatureHumidityProvider(pth);
        return new ModifiedSaastamoinenModel(pth0Provider);
    }

    public PressureTemperatureHumidityProvider getPth0Provider() {
        return this.pth0Provider;
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return this.pathDelay(new TrackingCoordinates(0.0, elevation, 0.0), point, this.pth0Provider.getWeatherParamerers(point, date), parameters, date).getDelay();
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.pathDelay(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, this.pth0Provider.getWeatherParamerers(point, date), (CalculusFieldElement[])parameters, date).getDelay();
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double fixedHeight = FastMath.min((double)FastMath.max((double)point.getAltitude(), (double)X_VALUES_FOR_B[0]), (double)X_VALUES_FOR_B[X_VALUES_FOR_B.length - 1]);
        PressureTemperatureHumidity pth = this.converter.convert(weather, fixedHeight);
        double B = B_FUNCTION.value(fixedHeight);
        double z = FastMath.abs((double)(1.5707963267948966 - FastMath.max((double)trackingCoordinates.getElevation(), (double)this.lowElevationThreshold)));
        double deltaR = this.getDeltaR(fixedHeight, z);
        double invCos = 1.0 / FastMath.cos((double)z);
        double tan = FastMath.tan((double)z);
        double zh = 2.277E-5 * pth.getPressure();
        double zw = 2.277E-5 * (1255.0 / pth.getTemperature() + 0.05) * pth.getWaterVaporPressure();
        double sh = zh * invCos;
        double sw = (zw - 2.277E-5 * B * tan * tan) * invCos + deltaR;
        return new TroposphericDelay(zh, zw, sh, sw);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement fixedHeight = FastMath.min((CalculusFieldElement)FastMath.max(point.getAltitude(), (double)X_VALUES_FOR_B[0]), (double)X_VALUES_FOR_B[X_VALUES_FOR_B.length - 1]);
        FieldPressureTemperatureHumidity<CalculusFieldElement> pth = this.converter.convert(weather, fixedHeight);
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement B = B_FUNCTION.value(fixedHeight);
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.max(trackingCoordinates.getElevation(), (CalculusFieldElement)((CalculusFieldElement)zero.newInstance(this.lowElevationThreshold))).negate()).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(0.5)))));
        CalculusFieldElement deltaR = this.getDeltaR(fixedHeight, z, field);
        CalculusFieldElement invCos = (CalculusFieldElement)FastMath.cos((CalculusFieldElement)z).reciprocal();
        CalculusFieldElement tan = FastMath.tan((CalculusFieldElement)z);
        CalculusFieldElement zh = (CalculusFieldElement)pth.getPressure().multiply(2.277E-5);
        CalculusFieldElement zw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pth.getTemperature().reciprocal()).multiply(1255.0)).add(0.05)).multiply((FieldElement)pth.getWaterVaporPressure())).multiply(2.277E-5);
        CalculusFieldElement sh = (CalculusFieldElement)zh.multiply((FieldElement)invCos);
        CalculusFieldElement sw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zw.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)B.multiply((FieldElement)tan)).multiply((FieldElement)tan)).multiply(2.277E-5)))).multiply((FieldElement)invCos)).add((FieldElement)deltaR);
        return new FieldTroposphericDelay<CalculusFieldElement>(zh, zw, sh, sw);
    }

    private double getDeltaR(double height, double zenith) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)height), (double)5000.0);
        double z = FastMath.min((double)Math.abs(zenith), (double)1.5707963267948966);
        return this.deltaRFunction.value(h, z);
    }

    private <T extends CalculusFieldElement<T>> T getDeltaR(T height, T zenith, Field<T> field) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement h = FastMath.min((CalculusFieldElement)FastMath.max((CalculusFieldElement)zero, height), (CalculusFieldElement)((CalculusFieldElement)zero.add(5000.0)));
        CalculusFieldElement z = FastMath.min((CalculusFieldElement)((CalculusFieldElement)zenith.abs()), (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(0.5)));
        return (T)this.deltaRFunction.value(h, z);
    }

    private static BilinearInterpolatingFunction loadDeltaR(String deltaRFileName, DataProvidersManager dataProvidersManager) {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        dataProvidersManager.feed(deltaRFileName, loader);
        if (!loader.stillAcceptsData()) {
            double[] elevations = loader.getOrdinateGrid();
            for (int i = 0; i < elevations.length; ++i) {
                elevations[i] = FastMath.toRadians((double)elevations[i]);
            }
            return new BilinearInterpolatingFunction(loader.getAbscissaGrid(), elevations, loader.getValuesSamples());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, SECOND_DELTA_R_PATTERN.matcher(FIRST_DELTA_R_PATTERN.matcher(deltaRFileName).replaceAll("")).replaceAll(""));
    }

    private static BilinearInterpolatingFunction defaultDeltaR() {
        double[] xValForR = new double[]{0.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};
        double[] yValForR = new double[]{FastMath.toRadians((double)0.0), FastMath.toRadians((double)60.0), FastMath.toRadians((double)66.0), FastMath.toRadians((double)70.0), FastMath.toRadians((double)73.0), FastMath.toRadians((double)75.0), FastMath.toRadians((double)76.0), FastMath.toRadians((double)77.0), FastMath.toRadians((double)78.0), FastMath.toRadians((double)78.5), FastMath.toRadians((double)79.0), FastMath.toRadians((double)79.5), FastMath.toRadians((double)79.75), FastMath.toRadians((double)80.0), FastMath.toRadians((double)90.0)};
        double[][] fval = new double[][]{{0.0, 0.003, 0.006, 0.012, 0.02, 0.031, 0.039, 0.05, 0.065, 0.075, 0.087, 0.102, 0.111, 0.121, 0.121}, {0.0, 0.003, 0.006, 0.011, 0.018, 0.028, 0.035, 0.045, 0.059, 0.068, 0.079, 0.093, 0.101, 0.11, 0.11}, {0.0, 0.002, 0.005, 0.01, 0.017, 0.025, 0.032, 0.041, 0.054, 0.062, 0.072, 0.085, 0.092, 0.1, 0.1}, {0.0, 0.002, 0.005, 0.009, 0.015, 0.023, 0.029, 0.037, 0.049, 0.056, 0.065, 0.077, 0.083, 0.091, 0.091}, {0.0, 0.002, 0.004, 0.008, 0.013, 0.021, 0.026, 0.033, 0.044, 0.051, 0.059, 0.07, 0.076, 0.083, 0.083}, {0.0, 0.002, 0.003, 0.006, 0.011, 0.017, 0.021, 0.027, 0.036, 0.042, 0.049, 0.058, 0.063, 0.068, 0.068}, {0.0, 0.001, 0.003, 0.005, 0.009, 0.014, 0.017, 0.022, 0.03, 0.034, 0.04, 0.047, 0.052, 0.056, 0.056}, {0.0, 0.001, 0.002, 0.004, 0.007, 0.011, 0.014, 0.018, 0.024, 0.028, 0.033, 0.039, 0.043, 0.047, 0.047}};
        return new BilinearInterpolatingFunction(xValForR, yValForR, (double[][])fval);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    public double getLowElevationThreshold() {
        return this.lowElevationThreshold;
    }

    public void setLowElevationThreshold(double lowElevationThreshold) {
        this.lowElevationThreshold = lowElevationThreshold;
    }
}

