/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.FieldSinCos;
import org.hipparchus.util.SinCos;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class ModifiedHopfieldModel
implements TroposphericModel {
    private static final double HD0 = 40136.0;
    private static final double HD1 = 148.72;
    private static final double T0 = 273.16;
    private static final double HW0 = 11000.0;
    private static final double ND = 7.764E-5;
    private static final double NW1 = -1.296E-5;
    private static final double NW2 = 0.3718;
    private static final double RE = 6378137.0;

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double zenithAngle = 1.5707963267948966 - trackingCoordinates.getElevation();
        double hd = 40136.0 + 148.72 * (weather.getTemperature() - 273.16);
        double nd = 7.764E-5 * TroposphericModelUtils.HECTO_PASCAL.fromSI(weather.getPressure()) / weather.getTemperature();
        double hw = 11000.0;
        double nw = (-1.296E-5 + 0.3718 / weather.getTemperature()) / weather.getTemperature();
        return new TroposphericDelay(this.delay(0.0, hd, nd), this.delay(0.0, 11000.0, nw), this.delay(zenithAngle, hd, nd), this.delay(zenithAngle, 11000.0, nw));
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement zenithAngle = (CalculusFieldElement)((CalculusFieldElement)trackingCoordinates.getElevation().negate()).add(1.5707963267948966);
        CalculusFieldElement hd = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)weather.getTemperature().subtract(273.16)).multiply(148.72)).add(40136.0);
        CalculusFieldElement nd = (CalculusFieldElement)((CalculusFieldElement)TroposphericModelUtils.HECTO_PASCAL.fromSI(weather.getPressure()).multiply(7.764E-5)).divide(weather.getTemperature());
        CalculusFieldElement hw = (CalculusFieldElement)((CalculusFieldElement)date.getField().getZero()).newInstance(11000.0);
        CalculusFieldElement nw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)weather.getTemperature().reciprocal()).multiply(0.3718)).add(-1.296E-5)).divide(weather.getTemperature());
        return new FieldTroposphericDelay<CalculusFieldElement>(this.delay((CalculusFieldElement)date.getField().getZero(), hd, nd), this.delay((CalculusFieldElement)date.getField().getZero(), hw, nw), this.delay(zenithAngle, hd, nd), this.delay(zenithAngle, hw, nw));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double delay(double zenithAngle, double hi, double ni) {
        SinCos scZ = FastMath.sinCos((double)zenithAngle);
        double rePhi = 6378137.0 + hi;
        double reS = 6378137.0 * scZ.sin();
        double reC = 6378137.0 * scZ.cos();
        double ri = FastMath.sqrt((double)(rePhi * rePhi - reS * reS)) - reC;
        double ai = -scZ.cos() / hi;
        double bi = -scZ.sin() * scZ.sin() / (2.0 * hi * 6378137.0);
        double ai2 = ai * ai;
        double bi2 = bi * bi;
        double f1i = 1.0;
        double f2i = 4.0 * ai;
        double f3i = 6.0 * ai2 + 4.0 * bi;
        double f4i = 4.0 * ai * (ai2 + 3.0 * bi);
        double f5i = ai2 * ai2 + 12.0 * ai2 * bi + 6.0 * bi2;
        double f6i = 4.0 * ai * bi * (ai2 + 3.0 * bi);
        double f7i = bi2 * (6.0 * ai2 + 4.0 * bi);
        double f8i = 4.0 * ai * bi * bi2;
        double f9i = bi2 * bi2;
        return ni * (ri * (1.0 + ri * (f2i / 2.0 + ri * (f3i / 3.0 + ri * (f4i / 4.0 + ri * (f5i / 5.0 + ri * (f6i / 6.0 + ri * (f7i / 7.0 + ri * (f8i / 8.0 + ri * f9i / 9.0)))))))));
    }

    private <T extends CalculusFieldElement<T>> T delay(T zenithAngle, T hi, T ni) {
        FieldSinCos scZ = FastMath.sinCos(zenithAngle);
        CalculusFieldElement rePhi = (CalculusFieldElement)hi.add(6378137.0);
        CalculusFieldElement reS = (CalculusFieldElement)((CalculusFieldElement)scZ.sin()).multiply(6378137.0);
        CalculusFieldElement reC = (CalculusFieldElement)((CalculusFieldElement)scZ.cos()).multiply(6378137.0);
        CalculusFieldElement ri = (CalculusFieldElement)FastMath.sqrt((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)rePhi.multiply((FieldElement)rePhi)).subtract((FieldElement)((CalculusFieldElement)reS.multiply((FieldElement)reS))))).subtract((FieldElement)reC);
        CalculusFieldElement ai = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scZ.cos()).negate()).divide(hi);
        CalculusFieldElement bi = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)scZ.sin()).multiply((FieldElement)((CalculusFieldElement)scZ.sin()))).negate()).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)hi.add(hi)).multiply(6378137.0)));
        CalculusFieldElement ai2 = (CalculusFieldElement)ai.multiply((FieldElement)ai);
        CalculusFieldElement bi2 = (CalculusFieldElement)bi.multiply((FieldElement)bi);
        CalculusFieldElement f1i = (CalculusFieldElement)ai.getField().getOne();
        CalculusFieldElement f2i = (CalculusFieldElement)ai.multiply(4);
        CalculusFieldElement f3i = (CalculusFieldElement)((CalculusFieldElement)ai2.multiply(6)).add((FieldElement)((CalculusFieldElement)bi.multiply(4)));
        CalculusFieldElement f4i = (CalculusFieldElement)((CalculusFieldElement)ai.multiply(4)).multiply((FieldElement)((CalculusFieldElement)ai2.add((FieldElement)((CalculusFieldElement)bi.multiply(3)))));
        CalculusFieldElement f5i = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ai2.multiply((FieldElement)ai2)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ai2.multiply(12)).multiply((FieldElement)bi)))).add((FieldElement)((CalculusFieldElement)bi2.multiply(6)));
        CalculusFieldElement f6i = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ai.multiply(4)).multiply((FieldElement)bi)).multiply((FieldElement)((CalculusFieldElement)ai2.add((FieldElement)((CalculusFieldElement)bi.multiply(3)))));
        CalculusFieldElement f7i = (CalculusFieldElement)bi2.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)ai2.multiply(6)).add((FieldElement)((CalculusFieldElement)bi.multiply(4)))));
        CalculusFieldElement f8i = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)ai.multiply(4)).multiply((FieldElement)bi)).multiply((FieldElement)bi2);
        CalculusFieldElement f9i = (CalculusFieldElement)bi2.multiply((FieldElement)bi2);
        return (T)((CalculusFieldElement)ni.multiply((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)f1i.add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f2i.divide(2.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f3i.divide(3.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f4i.divide(4.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f5i.divide(5.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f6i.divide(6.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f7i.divide(7.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)f8i.divide(8.0)).add((FieldElement)((CalculusFieldElement)ri.multiply((FieldElement)((CalculusFieldElement)f9i.divide(9.0))))))))))))))))))))))))))))))))))))));
    }
}

