/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.MappingFunction;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.ConstantPressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.water.CIPM2007;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;
import org.orekit.utils.units.Unit;
import org.orekit.utils.units.UnitsConverter;

public class MendesPavlisModel
implements DiscreteTroposphericModel,
TroposphericModel,
MappingFunction,
TroposphereMappingFunction {
    private static final double[] K_COEFFICIENTS = new double[]{238.0185, 19990.975, 57.362, 579.55174};
    private static final double[] W_COEFFICIENTS = new double[]{295.235, 2.6422, -0.03238, 0.004028};
    private static final double[][] A_COEFFICIENTS = new double[][]{{0.00121008, 1.7295E-6, 3.191E-5, -1.8478E-8}, {0.00304965, 2.344E-6, -1.035E-4, -1.856E-8}, {0.068777, 1.972E-5, -0.003458, 1.06E-7}};
    private static final double C02 = 0.99995995;
    private final double fLambdaH;
    private final double fLambdaNH;
    private final PressureTemperatureHumidityProvider pthProvider;

    @Deprecated
    public MendesPavlisModel(double t0, double p0, double rh, double lambda) {
        this(new ConstantPressureTemperatureHumidityProvider(new PressureTemperatureHumidity(0.0, TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, new CIPM2007().waterVaporPressure(TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, rh), Double.NaN, Double.NaN)), lambda, TroposphericModelUtils.MICRO_M);
    }

    public MendesPavlisModel(PressureTemperatureHumidityProvider pthProvider, double lambda, Unit lambdaUnits) {
        this.pthProvider = pthProvider;
        double lambdaMicrometer = new UnitsConverter(lambdaUnits, TroposphericModelUtils.MICRO_M).convert(lambda);
        double sigma = 1.0 / lambdaMicrometer;
        double sigma2 = sigma * sigma;
        double coef1 = K_COEFFICIENTS[0] + sigma2;
        double coef2 = K_COEFFICIENTS[0] - sigma2;
        double coef3 = K_COEFFICIENTS[2] + sigma2;
        double coef4 = K_COEFFICIENTS[2] - sigma2;
        double frac1 = coef1 / (coef2 * coef2);
        double frac2 = coef3 / (coef4 * coef4);
        this.fLambdaH = 0.01 * (K_COEFFICIENTS[1] * frac1 + K_COEFFICIENTS[3] * frac2) * 0.99995995;
        double sigma4 = sigma2 * sigma2;
        double sigma6 = sigma4 * sigma2;
        double w1s2 = 3.0 * W_COEFFICIENTS[1] * sigma2;
        double w2s4 = 5.0 * W_COEFFICIENTS[2] * sigma4;
        double w3s6 = 7.0 * W_COEFFICIENTS[3] * sigma6;
        this.fLambdaNH = 0.003101 * (W_COEFFICIENTS[0] + w1s2 + w2s4 + w3s6);
    }

    @Deprecated
    public static MendesPavlisModel getStandardModel(double lambda) {
        return MendesPavlisModel.getStandardModel(lambda, TroposphericModelUtils.MICRO_M);
    }

    public static MendesPavlisModel getStandardModel(double lambda, Unit lambdaUnits) {
        double h = 0.0;
        double p = TroposphericModelUtils.HECTO_PASCAL.toSI(1013.25);
        double t = 291.15;
        double rh = 0.5;
        PressureTemperatureHumidity pth = new PressureTemperatureHumidity(0.0, p, 291.15, new CIPM2007().waterVaporPressure(p, 291.15, 0.5), Double.NaN, Double.NaN);
        return new MendesPavlisModel(new ConstantPressureTemperatureHumidityProvider(pth), lambda, lambdaUnits);
    }

    @Override
    @Deprecated
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return this.pathDelay(new TrackingCoordinates(0.0, elevation, 0.0), point, TroposphericModelUtils.STANDARD_ATMOSPHERE, parameters, date).getDelay();
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double[] zenithDelay = this.computeZenithDelay(point, parameters, date);
        double[] mappingFunction = this.mappingFactors(trackingCoordinates, point, weather, date);
        return new TroposphericDelay(zenithDelay[0], zenithDelay[1], zenithDelay[0] * mappingFunction[0], zenithDelay[1] * mappingFunction[1]);
    }

    @Override
    @Deprecated
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.pathDelay(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, new FieldPressureTemperatureHumidity<T>(date.getField(), TroposphericModelUtils.STANDARD_ATMOSPHERE), (CalculusFieldElement[])parameters, date).getDelay();
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] zenithDelay = this.computeZenithDelay(point, (CalculusFieldElement[])parameters, date);
        CalculusFieldElement[] mappingFunction = this.mappingFactors(trackingCoordinates, point, weather, date);
        return new FieldTroposphericDelay<CalculusFieldElement>(zenithDelay[0], zenithDelay[1], (CalculusFieldElement)zenithDelay[0].multiply((FieldElement)mappingFunction[0]), (CalculusFieldElement)zenithDelay[1].multiply((FieldElement)mappingFunction[1]));
    }

    public double[] computeZenithDelay(GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        PressureTemperatureHumidity pth = this.pthProvider.getWeatherParamerers(point, date);
        double fsite = this.getSiteFunctionValue(point);
        double[] delay = new double[]{pth.getPressure() * 2.416579E-5 * (this.fLambdaH / fsite), 1.0E-6 * (5.316 * this.fLambdaNH - 3.759 * this.fLambdaH) * (pth.getWaterVaporPressure() / fsite)};
        return delay;
    }

    public <T extends CalculusFieldElement<T>> T[] computeZenithDelay(FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        FieldPressureTemperatureHumidity<T> pth = this.pthProvider.getWeatherParamerers(point, date);
        T fsite = this.getSiteFunctionValue(point);
        CalculusFieldElement[] delay = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
        delay[0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)pth.getPressure().multiply(2.416579E-5)).multiply(this.fLambdaH)).divide(fsite);
        delay[1] = (CalculusFieldElement)((CalculusFieldElement)pth.getWaterVaporPressure().divide(fsite)).multiply(1.0E-6 * (5.316 * this.fLambdaNH - 3.759 * this.fLambdaH));
        return delay;
    }

    @Override
    @Deprecated
    public double[] mappingFactors(double elevation, GeodeticPoint point, AbsoluteDate date) {
        return this.mappingFactors(new TrackingCoordinates(0.0, elevation, 0.0), point, TroposphericModelUtils.STANDARD_ATMOSPHERE, date);
    }

    @Override
    public double[] mappingFactors(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, AbsoluteDate date) {
        double sinE = FastMath.sin((double)trackingCoordinates.getElevation());
        PressureTemperatureHumidity pth = this.pthProvider.getWeatherParamerers(point, date);
        double T2degree = pth.getTemperature() - 273.15;
        double a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, point);
        double a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, point);
        double a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, point);
        double numMP = 1.0 + a1 / (1.0 + a2 / (1.0 + a3));
        double denMP = sinE + a1 / (sinE + a2 / (sinE + a3));
        double factor = numMP / denMP;
        return new double[]{factor, factor};
    }

    @Override
    @Deprecated
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(T elevation, FieldGeodeticPoint<T> point, FieldAbsoluteDate<T> date) {
        return this.mappingFactors(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, new FieldPressureTemperatureHumidity<T>(date.getField(), TroposphericModelUtils.STANDARD_ATMOSPHERE), date);
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement sinE = FastMath.sin(trackingCoordinates.getElevation());
        FieldPressureTemperatureHumidity<T> pth = this.pthProvider.getWeatherParamerers(point, date);
        CalculusFieldElement T2degree = (CalculusFieldElement)pth.getTemperature().subtract(273.15);
        CalculusFieldElement a1 = this.computeMFCoeffient(A_COEFFICIENTS[0][0], A_COEFFICIENTS[0][1], A_COEFFICIENTS[0][2], A_COEFFICIENTS[0][3], T2degree, point);
        CalculusFieldElement a2 = this.computeMFCoeffient(A_COEFFICIENTS[1][0], A_COEFFICIENTS[1][1], A_COEFFICIENTS[1][2], A_COEFFICIENTS[1][3], T2degree, point);
        CalculusFieldElement a3 = this.computeMFCoeffient(A_COEFFICIENTS[2][0], A_COEFFICIENTS[2][1], A_COEFFICIENTS[2][2], A_COEFFICIENTS[2][3], T2degree, point);
        CalculusFieldElement numMP = (CalculusFieldElement)((CalculusFieldElement)a1.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a2.divide((FieldElement)((CalculusFieldElement)a3.add(1.0)))).add(1.0)))).add(1.0);
        CalculusFieldElement denMP = (CalculusFieldElement)((CalculusFieldElement)a1.divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)a2.divide((FieldElement)((CalculusFieldElement)a3.add((FieldElement)sinE)))).add((FieldElement)sinE)))).add((FieldElement)sinE);
        CalculusFieldElement factor = (CalculusFieldElement)numMP.divide((FieldElement)denMP);
        CalculusFieldElement[] mapping = (CalculusFieldElement[])MathArrays.buildArray(field, (int)2);
        mapping[0] = factor;
        mapping[1] = factor;
        return mapping;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getSiteFunctionValue(GeodeticPoint point) {
        return 1.0 - 0.00266 * FastMath.cos((double)(2.0 * point.getLatitude())) - 2.8E-7 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T getSiteFunctionValue(FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2.0))).multiply(0.00266)).add((FieldElement)((CalculusFieldElement)point.getAltitude().multiply(2.8E-7)))).negate()).add(1.0));
    }

    private double computeMFCoeffient(double a0, double a1, double a2, double a3, double t, GeodeticPoint point) {
        return a0 + a1 * t + a2 * FastMath.cos((double)point.getLatitude()) + a3 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T computeMFCoeffient(double a0, double a1, double a2, double a3, T t, FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)point.getAltitude().multiply(a3)).add((FieldElement)((CalculusFieldElement)FastMath.cos(point.getLatitude()).multiply(a2)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(a1)).add(a0))));
    }
}

