/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.MariniMurray;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.models.earth.weather.water.CIPM2007;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.TrackingCoordinates;

@Deprecated
public class MariniMurrayModel
extends MariniMurray
implements DiscreteTroposphericModel {
    private final PressureTemperatureHumidity pth;

    public MariniMurrayModel(double t0, double p0, double rh, double lambda) {
        super(lambda, TroposphericModelUtils.NANO_M);
        this.pth = new PressureTemperatureHumidity(0.0, TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, new CIPM2007().waterVaporPressure(TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, rh), Double.NaN, Double.NaN);
    }

    public static MariniMurrayModel getStandardModel(double lambda) {
        double p = TroposphericModelUtils.HECTO_PASCAL.toSI(1013.25);
        double t = 293.15;
        double rh = 0.5;
        return new MariniMurrayModel(293.15, p, 0.5, lambda);
    }

    @Override
    public double pathDelay(double elevation, GeodeticPoint point, double[] parameters, AbsoluteDate date) {
        return this.pathDelay(new TrackingCoordinates(0.0, elevation, 0.0), point, this.pth, parameters, date).getDelay();
    }

    @Override
    public <T extends CalculusFieldElement<T>> T pathDelay(T elevation, FieldGeodeticPoint<T> point, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.pathDelay(new FieldTrackingCoordinates<CalculusFieldElement>((CalculusFieldElement)date.getField().getZero(), elevation, (CalculusFieldElement)date.getField().getZero()), point, new FieldPressureTemperatureHumidity<T>(date.getField(), this.pth), (CalculusFieldElement[])parameters, date).getDelay();
    }
}

