/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;
import org.orekit.utils.units.Unit;
import org.orekit.utils.units.UnitsConverter;

public class MariniMurray
implements TroposphericModel {
    private final double fLambda;

    public MariniMurray(double lambda, Unit lambdaUnits) {
        double lambdaMicrometer = new UnitsConverter(lambdaUnits, TroposphericModelUtils.MICRO_M).convert(lambda);
        double l2 = lambdaMicrometer * lambdaMicrometer;
        this.fLambda = 0.965 + (0.0164 + 2.28E-4 / l2) / l2;
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double p = weather.getPressure();
        double t = weather.getTemperature();
        double e = weather.getWaterVaporPressure();
        double Ah = 2.357E-5 * p;
        double Aw = 1.41E-6 * e;
        double K = 1.163 - 0.00968 * FastMath.cos((double)(2.0 * point.getLatitude())) - 0.00104 * t + 1.435E-7 * p;
        double B = 1.084E-10 * p * t * K + 4.734E-12 * p * (p / t) * (2.0 * K) / (3.0 * K - 1.0);
        double flambda = this.getLaserFrequencyParameter();
        double fsite = this.getSiteFunctionValue(point);
        double sinE = FastMath.sin((double)trackingCoordinates.getElevation());
        double totalZenith = flambda / fsite * (Ah + Aw + B) / (1.0 + B / ((Ah + Aw + B) * 1.01));
        double totalElev = flambda / fsite * (Ah + Aw + B) / (sinE + B / ((Ah + Aw + B) * (sinE + 0.01)));
        double hydrostaticZenith = flambda / fsite * (Ah + B) / (1.0 + B / ((Ah + B) * 1.01));
        double hydrostaticElev = flambda / fsite * (Ah + B) / (sinE + B / ((Ah + B) * (sinE + 0.01)));
        return new TroposphericDelay(hydrostaticZenith, totalZenith - hydrostaticZenith, hydrostaticElev, totalElev - hydrostaticElev);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        Object p = weather.getPressure();
        Object t = weather.getTemperature();
        T e = weather.getWaterVaporPressure();
        CalculusFieldElement Ah = (CalculusFieldElement)p.multiply(2.357E-5);
        CalculusFieldElement Aw = (CalculusFieldElement)e.multiply(1.41E-6);
        CalculusFieldElement K = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2.0))).multiply(0.00968)).negate()).add(1.163)).subtract((FieldElement)((CalculusFieldElement)t.multiply(0.00104)))).add((FieldElement)((CalculusFieldElement)p.multiply(1.435E-7)));
        CalculusFieldElement B = (CalculusFieldElement)((CalculusFieldElement)K.multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)t.multiply(p)).multiply(1.084E-10)))).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)K.multiply(2.0)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)p.multiply(p)).divide(t)).multiply(4.734E-12)))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)K.multiply(3.0)).subtract(1.0)))));
        double flambda = this.getLaserFrequencyParameter();
        T fsite = this.getSiteFunctionValue(point);
        CalculusFieldElement sinE = FastMath.sin(trackingCoordinates.getElevation());
        CalculusFieldElement one = (CalculusFieldElement)date.getField().getOne();
        CalculusFieldElement totalZenith = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(flambda)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)).add((FieldElement)Aw)))).divide((FieldElement)((CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)one.add(0.01)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)).add((FieldElement)Aw)))).divide((FieldElement)B)).reciprocal()))));
        CalculusFieldElement totalElev = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(flambda)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)).add((FieldElement)Aw)))).divide((FieldElement)((CalculusFieldElement)sinE.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.add(0.01)).multiply((FieldElement)((CalculusFieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)).add((FieldElement)Aw)))).divide((FieldElement)B)).reciprocal()))));
        CalculusFieldElement hydrostaticZenith = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(flambda)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)))).divide((FieldElement)((CalculusFieldElement)one.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)one.add(0.01)).multiply((FieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)))).divide((FieldElement)B)).reciprocal()))));
        CalculusFieldElement hydrostaticElev = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)fsite.divide(flambda)).reciprocal()).multiply((FieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)))).divide((FieldElement)((CalculusFieldElement)sinE.add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)sinE.add(0.01)).multiply((FieldElement)((CalculusFieldElement)B.add((FieldElement)Ah)))).divide((FieldElement)B)).reciprocal()))));
        return new FieldTroposphericDelay<CalculusFieldElement>(hydrostaticZenith, (CalculusFieldElement)totalZenith.subtract((FieldElement)hydrostaticZenith), hydrostaticElev, (CalculusFieldElement)totalElev.subtract((FieldElement)hydrostaticElev));
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    private double getLaserFrequencyParameter() {
        return this.fLambda;
    }

    private double getSiteFunctionValue(GeodeticPoint point) {
        return 1.0 - 0.0026 * FastMath.cos((double)(2.0 * point.getLatitude())) - 3.1E-7 * point.getAltitude();
    }

    private <T extends CalculusFieldElement<T>> T getSiteFunctionValue(FieldGeodeticPoint<T> point) {
        return (T)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)FastMath.cos((CalculusFieldElement)((CalculusFieldElement)point.getLatitude().multiply(2))).multiply(0.0026)).add((FieldElement)((CalculusFieldElement)((CalculusFieldElement)point.getAltitude().multiply(0.001)).multiply(3.1E-4)))).negate()).add(1.0));
    }
}

