/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.ModifiedSaastamoinenModel;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelUtils;
import org.orekit.models.earth.weather.ConstantPressureTemperatureHumidityProvider;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class EstimatedModel
implements TroposphericModel {
    public static final String TOTAL_ZENITH_DELAY = "total zenith delay";
    private final TroposphereMappingFunction model;
    private final ParameterDriver totalZenithDelay;
    private final TroposphericModel hydrostatic;

    @DefaultDataContext
    public EstimatedModel(double h0, double t0, double p0, TroposphereMappingFunction model, double totalDelay) {
        this(new ModifiedSaastamoinenModel(new ConstantPressureTemperatureHumidityProvider(new PressureTemperatureHumidity(h0, TroposphericModelUtils.HECTO_PASCAL.toSI(p0), t0, 0.0, Double.NaN, Double.NaN))), model, totalDelay);
    }

    public EstimatedModel(TroposphericModel hydrostatic, TroposphereMappingFunction model, double totalDelay) {
        this.totalZenithDelay = new ParameterDriver(TOTAL_ZENITH_DELAY, totalDelay, FastMath.scalb((double)1.0, (int)0), 0.0, Double.POSITIVE_INFINITY);
        this.hydrostatic = hydrostatic;
        this.model = model;
    }

    @DefaultDataContext
    public EstimatedModel(TroposphereMappingFunction model, double totalDelay) {
        this(0.0, 291.15, 1013.25, model, totalDelay);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.singletonList(this.totalZenithDelay);
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double zd = this.hydrostatic.pathDelay(trackingCoordinates, point, weather, parameters, date).getZh();
        double wd = parameters[0] - zd;
        double[] mf = this.model.mappingFactors(trackingCoordinates, point, weather, date);
        return new TroposphericDelay(zd, wd, mf[0] * zd, mf[1] * wd);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        Object zd = this.hydrostatic.pathDelay(trackingCoordinates, point, weather, (CalculusFieldElement[])parameters, date).getZh();
        CalculusFieldElement wd = (CalculusFieldElement)parameters[0].subtract(zd);
        CalculusFieldElement[] mf = this.model.mappingFactors(trackingCoordinates, point, weather, date);
        return new FieldTroposphericDelay<CalculusFieldElement>((CalculusFieldElement)zd, wd, (CalculusFieldElement)mf[0].multiply(zd), (CalculusFieldElement)mf[1].multiply((FieldElement)wd));
    }
}

