/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.TrackingCoordinates;

public class DummyMappingFunction
implements TroposphereMappingFunction {
    protected DummyMappingFunction() {
    }

    @Override
    public double[] mappingFactors(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, AbsoluteDate date) {
        return new double[]{1.0, 1.0};
    }

    @Override
    public <T extends CalculusFieldElement<T>> T[] mappingFactors(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] mapping = (CalculusFieldElement[])MathArrays.buildArray(date.getField(), (int)2);
        mapping[0] = (CalculusFieldElement)date.getField().getOne();
        mapping[1] = (CalculusFieldElement)date.getField().getOne();
        return mapping;
    }
}

