/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.util.FastMath;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class CanonicalSaastamoinenModel
implements TroposphericModel {
    public static final double DEFAULT_LOW_ELEVATION_THRESHOLD = 0.05;
    private static final double L0 = 2.2768E-5;
    private static final double T_NUM = 1255.0;
    private static final double WET_OFFSET = 0.05;
    private static final double[] X_VALUES_FOR_B = new double[]{0.0, 200.0, 400.0, 600.0, 800.0, 1000.0, 1500.0, 2000.0, 2500.0, 3000.0, 4000.0, 5000.0, 6000.0};
    private static final double[] Y_VALUES_FOR_B = new double[]{116.0, 113.0, 110.0, 107.0, 104.0, 101.0, 94.0, 88.0, 82.0, 76.0, 66.0, 57.0, 49.0};
    private static final PolynomialSplineFunction B_FUNCTION = new LinearInterpolator().interpolate(X_VALUES_FOR_B, Y_VALUES_FOR_B);
    private double lowElevationThreshold = 0.05;

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double fixedHeight = FastMath.min((double)FastMath.max((double)point.getAltitude(), (double)X_VALUES_FOR_B[0]), (double)X_VALUES_FOR_B[X_VALUES_FOR_B.length - 1]);
        double B = B_FUNCTION.value(fixedHeight);
        double z = FastMath.abs((double)(1.5707963267948966 - FastMath.max((double)trackingCoordinates.getElevation(), (double)this.lowElevationThreshold)));
        double invCos = 1.0 / FastMath.cos((double)z);
        double tan = FastMath.tan((double)z);
        double zh = 2.2768E-5 * weather.getPressure();
        double zw = 2.2768E-5 * (1255.0 / weather.getTemperature() + 0.05) * weather.getWaterVaporPressure();
        double sh = zh * invCos;
        double sw = (zw - 2.2768E-5 * B * tan * tan) * invCos;
        return new TroposphericDelay(zh, zw, sh, sw);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        CalculusFieldElement fixedHeight = FastMath.min((CalculusFieldElement)FastMath.max(point.getAltitude(), (double)X_VALUES_FOR_B[0]), (double)X_VALUES_FOR_B[X_VALUES_FOR_B.length - 1]);
        CalculusFieldElement B = B_FUNCTION.value(fixedHeight);
        CalculusFieldElement z = FastMath.abs((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)zero.getPi()).multiply(0.5)).subtract((FieldElement)FastMath.max(trackingCoordinates.getElevation(), (double)this.lowElevationThreshold))));
        CalculusFieldElement invCos = (CalculusFieldElement)FastMath.cos((CalculusFieldElement)z).reciprocal();
        CalculusFieldElement tan = FastMath.tan((CalculusFieldElement)z);
        CalculusFieldElement zh = (CalculusFieldElement)weather.getPressure().multiply(2.2768E-5);
        CalculusFieldElement zw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)weather.getTemperature().reciprocal()).multiply(1255.0)).add(0.05)).multiply(weather.getWaterVaporPressure())).multiply(2.2768E-5);
        CalculusFieldElement sh = (CalculusFieldElement)zh.multiply((FieldElement)invCos);
        CalculusFieldElement sw = (CalculusFieldElement)((CalculusFieldElement)zw.subtract((FieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)B.multiply((FieldElement)tan)).multiply((FieldElement)tan)).multiply(2.2768E-5)))).multiply((FieldElement)invCos);
        return new FieldTroposphericDelay<CalculusFieldElement>(zh, zw, sh, sw);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    public double getLowElevationThreshold() {
        return this.lowElevationThreshold;
    }

    public void setLowElevationThreshold(double lowElevationThreshold) {
        this.lowElevationThreshold = lowElevationThreshold;
    }
}

