/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth.troposphere;

import java.util.Collections;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.FieldElement;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.models.earth.troposphere.FieldTroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphereMappingFunction;
import org.orekit.models.earth.troposphere.TroposphericDelay;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.weather.FieldPressureTemperatureHumidity;
import org.orekit.models.earth.weather.PressureTemperatureHumidity;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public class AskneNordiusModel
implements TroposphericModel {
    public static final double LOW_ELEVATION_THRESHOLD = 0.05;
    private static final double L0 = 2.2768E-5;
    private static final double K_PRIME_2 = 16.5203;
    private static final double K_3 = 377600.0;
    private static final double RD = 287.0464;
    private static final double FACTOR = 1.0E-6;
    private final TroposphereMappingFunction mappingFunction;

    public AskneNordiusModel(TroposphereMappingFunction mappingFunction) {
        this.mappingFunction = mappingFunction;
    }

    @Override
    public TroposphericDelay pathDelay(TrackingCoordinates trackingCoordinates, GeodeticPoint point, PressureTemperatureHumidity weather, double[] parameters, AbsoluteDate date) {
        double[] mf = this.mappingFunction.mappingFactors(trackingCoordinates, point, weather, date);
        double zh = 2.2768E-5 * weather.getPressure();
        double zw = 1.0E-6 * (16.5203 + 377600.0 / weather.getTm()) * 287.0464 * weather.getWaterVaporPressure() / (9.80665 * (weather.getLambda() + 1.0));
        double sh = zh * mf[0];
        double sw = zw * mf[1];
        return new TroposphericDelay(zh, zw, sh, sw);
    }

    @Override
    public <T extends CalculusFieldElement<T>> FieldTroposphericDelay<T> pathDelay(FieldTrackingCoordinates<T> trackingCoordinates, FieldGeodeticPoint<T> point, FieldPressureTemperatureHumidity<T> weather, T[] parameters, FieldAbsoluteDate<T> date) {
        CalculusFieldElement[] mf = this.mappingFunction.mappingFactors(trackingCoordinates, point, weather, date);
        CalculusFieldElement zh = (CalculusFieldElement)weather.getPressure().multiply(2.2768E-5);
        CalculusFieldElement zw = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)weather.getTm().reciprocal()).multiply(377600.0)).add(16.5203)).multiply((FieldElement)((CalculusFieldElement)weather.getWaterVaporPressure().multiply(287.0464)))).divide((FieldElement)((CalculusFieldElement)((CalculusFieldElement)weather.getLambda().add(1.0)).multiply(9.80665)))).multiply(1.0E-6);
        CalculusFieldElement sh = (CalculusFieldElement)zh.multiply((FieldElement)mf[0]);
        CalculusFieldElement sw = (CalculusFieldElement)zw.multiply((FieldElement)mf[1]);
        return new FieldTroposphericDelay<CalculusFieldElement>(zh, zw, sh, sw);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

